/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddDriverDialog
extends JPanel {
    private DefaultListModel dlm;
    private List drvs;
    private boolean customizer = false;
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private static final String BUNDLE = "org.netbeans.modules.db.resources.Bundle";
    private static final Logger LOGGER = Logger.getLogger(AddDriverDialog.class.getName());
    private JButton browseButton;
    private JComboBox drvClassComboBox;
    private JLabel drvClassLabel;
    private JList drvList;
    private JLabel drvListLabel;
    private JScrollPane drvListScrollPane;
    private JButton findButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JButton removeButton;

    public AddDriverDialog() {
        this.initComponents();
        this.initAccessibility();
        this.dlm = (DefaultListModel)this.drvList.getModel();
        this.drvs = new LinkedList();
    }

    public AddDriverDialog(JDBCDriver jDBCDriver) {
        this();
        this.customizer = true;
        String string = null;
        URL[] uRLArray = jDBCDriver.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            Serializable serializable;
            FileObject fileObject;
            Serializable serializable2 = uRLArray[i];
            if ("nbinst".equals(serializable2.getProtocol()) && (fileObject = URLMapper.findFileObject((URL)serializable2)) != null && (serializable = URLMapper.findURL((FileObject)fileObject, (int)1)) != null) {
                serializable2 = serializable;
            }
            if ((fileObject = URLMapper.findFileObject((URL)serializable2)) != null) {
                serializable = FileUtil.toFile((FileObject)fileObject);
                if (serializable != null) {
                    string = ((File)serializable).getAbsolutePath();
                }
            } else {
                try {
                    string = new File(new URI(serializable2.toExternalForm())).getAbsolutePath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                    string = null;
                }
            }
            if (string == null) continue;
            this.dlm.addElement(string);
            this.drvs.add(uRLArray[i]);
        }
        this.drvClassComboBox.addItem(jDBCDriver.getClassName());
        this.drvClassComboBox.setSelectedItem(jDBCDriver.getClassName());
        this.nameTextField.setText(jDBCDriver.getDisplayName());
        this.drvList.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                AddDriverDialog.this.updateFindButtonState();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                AddDriverDialog.this.updateFindButtonState();
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                AddDriverDialog.this.updateFindButtonState();
            }
        });
        this.updateRemoveButtonState();
        this.updateFindButtonState();
    }

    private void updateRemoveButtonState() {
        boolean bl = this.drvList.getSelectedIndices().length > 0;
        this.removeButton.setEnabled(bl);
    }

    private void updateFindButtonState() {
        boolean bl = this.drvList.getModel().getSize() > 0;
        this.findButton.setEnabled(bl);
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)BUNDLE);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_AddDriverDialogA11yDesc"));
        this.drvListLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_AddDriverDriverFileA11yDesc"));
        this.drvList.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_AddDriverDriverFileListA11yName"));
        this.drvClassLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_AddDriverDriverDriverClassA11yDesc"));
        this.drvClassComboBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_AddDriverDriverDriverClassComboBoxA11yName"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_AddDriverDriverNameA11yDesc"));
        this.nameTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_AddDriverDriverNameTextFieldA11yName"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_AddDriverAddButtonA11yDesc"));
        this.findButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_AddDriverRemoveButtonA11yDesc"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_AddDriverFindButtonA11yDesc"));
        this.progressContainerPanel.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_AddDriverProgressBarA11yName"));
        this.progressContainerPanel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_AddDriverProgressBarA11yDesc"));
    }

    private void initComponents() {
        this.drvListLabel = new JLabel();
        this.drvListScrollPane = new JScrollPane();
        this.drvList = new JList();
        this.browseButton = new JButton();
        this.removeButton = new JButton();
        this.drvClassLabel = new JLabel();
        this.drvClassComboBox = new JComboBox();
        this.findButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.drvListLabel.setLabelFor(this.drvList);
        Mnemonics.setLocalizedText((JLabel)this.drvListLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverFile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.drvListLabel, gridBagConstraints);
        this.drvList.setModel(new DefaultListModel());
        this.drvList.addListSelectionListener(formListener);
        this.drvListScrollPane.setViewportView(this.drvList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.drvListScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverAdd"));
        this.browseButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.browseButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverRemove"));
        this.removeButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.drvClassLabel.setLabelFor(this.drvClassComboBox);
        Mnemonics.setLocalizedText((JLabel)this.drvClassLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.drvClassLabel, gridBagConstraints);
        this.drvClassComboBox.setEditable(true);
        this.drvClassComboBox.addItemListener(formListener);
        this.drvClassComboBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 12);
        this.add((Component)this.drvClassComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.findButton, (String)NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverFind"));
        this.findButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.findButton, gridBagConstraints);
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getBundle((String)BUNDLE).getString("AddDriverDriverName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 12);
        this.add((Component)this.nameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.progressMessageLabel, (String)" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.progressMessageLabel, gridBagConstraints);
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.progressContainerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.progressContainerPanel, gridBagConstraints);
    }

    private void drvClassComboBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.customizer) {
            this.nameTextField.setText(DriverListUtil.findFreeName(DriverListUtil.getName((String)this.drvClassComboBox.getSelectedItem())));
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.stopProgress();
        ListSelectionModel listSelectionModel = this.drvList.getSelectionModel();
        int n = this.dlm.getSize();
        int n2 = 0;
        if (n < 1) {
            return;
        }
        do {
            if (listSelectionModel.isSelectedIndex(n2)) {
                this.dlm.remove(n2);
                this.drvs.remove(n2);
                --n;
                continue;
            }
            ++n2;
        } while (n != n2);
        this.findDriverClass();
    }

    private void findButtonActionPerformed(ActionEvent actionEvent) {
        this.findDriverClassByInspection();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        this.stopProgress();
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getBundle((String)BUNDLE).getString("AddDriver_Chooser_Title"));
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }

            public String getDescription() {
                return NbBundle.getBundle((String)AddDriverDialog.BUNDLE).getString("AddDriver_Chooser_Filter");
            }
        });
        if (jFileChooser.showOpenDialog(this) == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] == null || !fileArray[i].isFile()) continue;
                this.dlm.addElement(fileArray[i].toString());
                try {
                    this.drvs.add(fileArray[i].toURI().toURL());
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.log(Level.WARNING, "Unable to add driver jar file " + fileArray[i].getAbsolutePath() + ": can not convert to URL", malformedURLException);
                }
            }
            this.findDriverClass();
        }
    }

    private void drvListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateRemoveButtonState();
    }

    private void drvClassComboBoxItemStateChanged(ItemEvent itemEvent) {
    }

    private boolean isDriverClass(URLClassLoader uRLClassLoader, String string) {
        Class<?> clazz;
        try {
            clazz = uRLClassLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.FINE, null, throwable);
            LOGGER.log(Level.INFO, "Got an exception trying to load class " + string + " during search for JDBC drivers in " + " driver jar(s): " + throwable.getClass().getName() + ": " + throwable.getMessage() + ".  Skipping this class...");
            return false;
        }
        return Driver.class.isAssignableFrom(clazz);
    }

    public String getDisplayName() {
        return this.nameTextField.getText();
    }

    public List getDriverLocation() {
        return this.drvs;
    }

    public String getDriverClass() {
        return (String)this.drvClassComboBox.getSelectedItem();
    }

    private void findDriverClass() {
        String[] stringArray = DriverListUtil.getDrivers().toArray(new String[DriverListUtil.getDrivers().size()]);
        this.drvClassComboBox.removeAllItems();
        for (int i = 0; i < this.drvs.size(); ++i) {
            try {
                URL uRL;
                Object object;
                URL uRL2 = (URL)this.drvs.get(i);
                if ("nbinst".equals(uRL2.getProtocol()) && (object = URLMapper.findFileObject((URL)uRL2)) != null && (uRL = URLMapper.findURL((FileObject)object, (int)1)) != null) {
                    uRL2 = uRL;
                }
                object = new File(new URI(uRL2.toExternalForm()));
                JarFile jarFile = new JarFile((File)object);
                for (int j = 0; j < stringArray.length; ++j) {
                    if (jarFile.getEntry(stringArray[j].replace('.', '/') + ".class") == null) continue;
                    this.addDriverClass(stringArray[j]);
                }
                jarFile.close();
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private void findDriverClassByInspection() {
        this.drvClassComboBox.removeAllItems();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AddDriverDialog.this.startProgress();
                URLClassLoader uRLClassLoader = new URLClassLoader(AddDriverDialog.this.drvs.toArray(new URL[AddDriverDialog.this.drvs.size()]), this.getClass().getClassLoader());
                for (int i = 0; i < AddDriverDialog.this.dlm.size(); ++i) {
                    try {
                        String string = (String)AddDriverDialog.this.dlm.get(i);
                        JarFile jarFile = new JarFile(string);
                        try {
                            Enumeration<JarEntry> enumeration = jarFile.entries();
                            while (enumeration.hasMoreElements()) {
                                JarEntry jarEntry = enumeration.nextElement();
                                String string2 = jarEntry.getName();
                                if (!string2.endsWith(".class")) continue;
                                string2 = string2.replace('/', '.');
                                if (!AddDriverDialog.this.isDriverClass(uRLClassLoader, string2 = string2.substring(0, string2.length() - 6))) continue;
                                AddDriverDialog.this.addDriverClass(string2);
                            }
                            continue;
                        }
                        finally {
                            jarFile.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                AddDriverDialog.this.stopProgress();
            }
        }, 0);
    }

    private void addDriverClass(String string) {
        if (((DefaultComboBoxModel)this.drvClassComboBox.getModel()).getIndexOf(string) < 0) {
            this.drvClassComboBox.addItem(string);
        }
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddDriverDialog.this.progressHandle = ProgressHandleFactory.createHandle(null);
                AddDriverDialog.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)AddDriverDialog.this.progressHandle);
                AddDriverDialog.this.progressContainerPanel.add((Component)AddDriverDialog.this.progressComponent, "Center");
                AddDriverDialog.this.progressHandle.start();
                AddDriverDialog.this.progressMessageLabel.setText(NbBundle.getBundle((String)AddDriverDialog.BUNDLE).getString("AddDriverProgressStart"));
            }
        });
    }

    private void stopProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AddDriverDialog.this.progressHandle != null) {
                    AddDriverDialog.this.progressHandle.finish();
                    AddDriverDialog.this.progressHandle = null;
                    AddDriverDialog.this.progressMessageLabel.setText(" ");
                    AddDriverDialog.this.progressContainerPanel.remove(AddDriverDialog.this.progressComponent);
                    AddDriverDialog.this.repaint();
                }
            }
        });
    }

    private class FormListener
    implements ActionListener,
    ItemListener,
    ListSelectionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AddDriverDialog.this.browseButton) {
                AddDriverDialog.this.browseButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AddDriverDialog.this.removeButton) {
                AddDriverDialog.this.removeButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AddDriverDialog.this.drvClassComboBox) {
                AddDriverDialog.this.drvClassComboBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AddDriverDialog.this.findButton) {
                AddDriverDialog.this.findButtonActionPerformed(actionEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == AddDriverDialog.this.drvClassComboBox) {
                AddDriverDialog.this.drvClassComboBoxItemStateChanged(itemEvent);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == AddDriverDialog.this.drvList) {
                AddDriverDialog.this.drvListValueChanged(listSelectionEvent);
            }
        }
    }
}

