/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.ThreadUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;

public class BandWidget
extends SeparatorWidget
implements PropertyChangeListener {
    private final JRBand band;

    public BandWidget(ReportObjectScene scene, JRBand band) {
        super((Scene)scene, SeparatorWidget.Orientation.HORIZONTAL);
        this.band = band;
        if (band instanceof JRDesignBand) {
            ((JRDesignBand)band).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.setToolTipText(ModelUtils.nameOf(band, scene.getJasperDesign()));
        this.updateBounds();
    }

    public JRBand getBand() {
        return this.band;
    }

    public void updateBounds() {
        JasperDesign jasperDesign = ((ReportObjectScene)this.getScene()).getJasperDesign();
        this.setPreferredLocation(new Point(0, ModelUtils.getBandLocation(this.band, jasperDesign)));
        this.setPreferredBounds(new Rectangle(0, 0, jasperDesign.getPageWidth(), this.band.getHeight()));
    }

    protected void paintWidget() {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Runnable r = null;
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("height")) {
            r = new Runnable(){

                public void run() {
                    ((ReportObjectScene)BandWidget.this.getScene()).refreshDocument();
                }
            };
        }
        if (r != null) {
            ThreadUtils.invokeInAWTThread(r);
        }
    }
}

