/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import java.lang.reflect.Method;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ObjectPropertyUndoableEdit
extends AggregatedUndoableEdit {
    private Object object;
    private String property;
    private Object oldValue;
    private Object newValue;
    private Class propertyClass;

    public ObjectPropertyUndoableEdit(Object object, String property, Class propertyClass, Object oldValue, Object newValue) {
        this.object = object;
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.propertyClass = propertyClass;
        this.setPresentationName(this.getProperty() + " of " + this.getObject());
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            Method m = this.getObject().getClass().getMethod("set" + this.getProperty(), this.getPropertyClass());
            m.invoke(this.getObject(), this.getOldValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CannotUndoException();
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        try {
            Method m = this.getObject().getClass().getMethod("set" + this.getProperty(), this.getPropertyClass());
            m.invoke(this.getObject(), this.getNewValue());
        }
        catch (Exception ex) {
            throw new CannotUndoException();
        }
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public Class getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(Class propertyClass) {
        this.propertyClass = propertyClass;
    }
}

