/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.editors.ExpressionPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import java.beans.PropertyEditor;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public abstract class ExpressionProperty
extends AbstractProperty {
    private PropertyEditor editor = null;

    public ExpressionProperty(Object object, ExpressionContext context) {
        super(String.class, object);
        this.setValue("EXPRESSION_CONTEXT", context);
    }

    public ExpressionProperty(Object object, JRDesignDataset dataset) {
        this(object, new ExpressionContext(dataset));
    }

    public Object getPropertyValue() {
        JRDesignExpression expression = this.getExpression();
        if (expression == null) {
            return null;
        }
        return expression.getText();
    }

    public Object getOwnPropertyValue() {
        return this.getPropertyValue();
    }

    public Object getDefaultValue() {
        return null;
    }

    public void validate(Object value) {
    }

    public void setPropertyValue(Object value) {
        this.setExpression(this.createExpression((String)value));
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new ExpressionPropertyEditor();
        }
        return this.editor;
    }

    private JRDesignExpression createExpression(String text) {
        String valueClassName;
        JRDesignExpression newExp = null;
        JRDesignExpression oldExp = this.getExpression();
        String defaultValueClassName = this.getDefaultExpressionClassName();
        String string = valueClassName = oldExp == null || oldExp.getValueClassName() == null ? defaultValueClassName : oldExp.getValueClassName();
        if (text != null && text.trim().length() > 0 || !defaultValueClassName.equals(valueClassName)) {
            newExp = new JRDesignExpression();
            newExp.setText(text);
            newExp.setValueClassName(valueClassName);
        }
        return newExp;
    }

    public abstract String getDefaultExpressionClassName();

    public abstract JRDesignExpression getExpression();

    public abstract void setExpression(JRDesignExpression var1);
}

