/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor;

import bsh.ParseException;
import bsh.Parser;
import bsh.Token;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.CrosstabTotalVariable;
import com.jaspersoft.ireport.designer.editor.ExpObject;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorPane;
import com.jaspersoft.ireport.designer.editor.MethodsListCellRenderer;
import com.jaspersoft.ireport.designer.editor.NamedIconItem;
import com.jaspersoft.ireport.designer.editor.NamedIconTreeCellRenderer;
import com.jaspersoft.ireport.designer.editor.functions.Function;
import com.jaspersoft.ireport.designer.editor.functions.FunctionAndExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.editor.functions.FunctionPanel;
import com.jaspersoft.ireport.designer.editor.functions.FunctionsUtils;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEditor2
extends JPanel {
    public static final String USER_DEFINED_EXPRESSIONS = "USER_DEFINED_EXPRESSIONS";
    public static final String PARAMETERS = "PARAMETERS";
    public static final String FIELDS = "FIELDS";
    public static final String VARIABLES = "VARIABLES";
    public static final String RECENT_EXPRESSIONS = "RECENT_EXPRESSIONS";
    public static final String WIZARDS = "WIZARDS";
    public static final String FUNCTIONS = "FUNCTIONS";
    public static final String FUNCTIONS_CATEGORY = "FUNCTIONS_CATEGORY";
    private ExpressionContext expressionContext = null;
    private JDialog dialog = null;
    private int dialogResult = 2;
    private boolean refreshingContext = false;
    private FunctionPanel functionPanel = null;
    private JPanel thirdColumnPanel = null;
    private static DefaultMutableTreeNode functionsNode = null;
    private static ArrayList<String> recentExpressions = new ArrayList();
    private static ArrayList<String> defaultExpressions = null;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton14;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JButton jButtonExport;
    private JButton jButtonImport;
    private ExpressionEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JLabel jLabelCaretPosition;
    private JLabel jLabelErrors;
    private JList jList2;
    private JList jList3;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelEditorArea;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneColumn2;
    private JScrollPane jScrollPaneColumn3;
    private JScrollPane jScrollPanecolumn1;
    private JTree jTree1;
    private JXMultiSplitPane jXMultiSplitPane1;

    public String getExpression() {
        return this.jEditorPane1.getText();
    }

    public void setExpression(String expression) {
        this.jEditorPane1.setText(expression);
        this.checkSyntax();
    }

    public static ArrayList<String> getPredefinedExpressions() {
        ArrayList<String> exps = new ArrayList<String>();
        Preferences pref = IReportManager.getPreferences();
        if (pref.getBoolean("custom_expressions_set", false)) {
            int i = 0;
            while (pref.get("customexpression." + i, null) != null) {
                exps.add(pref.get("customexpression." + i, ""));
                ++i;
            }
        } else {
            exps.addAll(ExpressionEditor2.getDefaultPredefinedExpressions());
        }
        return exps;
    }

    public static ArrayList<String> getDefaultPredefinedExpressions() {
        return defaultExpressions;
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
        this.jEditorPane1.setExpressionContext(expressionContext);
        this.refreshContext();
    }

    public ExpressionEditor2() {
        this.initComponents();
        this.jButtonApply.setVisible(false);
        this.jButtonCancel.setVisible(false);
        this.jTree1.setCellRenderer(new NamedIconTreeCellRenderer());
        this.jList2.setModel(new DefaultListModel());
        this.jList3.setModel(new DefaultListModel());
        this.jList2.setCellRenderer(new FunctionAndExpObjectCellRenderer(this.jList2));
        this.jList3.setCellRenderer(new MethodsListCellRenderer(this.jList3));
        this.thirdColumnPanel = new JPanel();
        this.thirdColumnPanel.setLayout(new BorderLayout());
        this.thirdColumnPanel.setPreferredSize(new Dimension(250, 10));
        String layoutDef = "(COLUMN (LEAF name=top weight=0.4) (ROW weight=0.6 (LEAF name=list1 weight=0.25) (LEAF name=list2 weight=0.25) (LEAF name=list3 weight=0.50)))";
        MultiSplitLayout.Node modelRoot = MultiSplitLayout.parseModel((String)layoutDef);
        this.jXMultiSplitPane1.setDividerSize(10);
        this.jXMultiSplitPane1.getMultiSplitLayout().setModel(modelRoot);
        this.jXMultiSplitPane1.add((Component)this.jPanelEditorArea, (Object)"top");
        this.jXMultiSplitPane1.add((Component)this.jScrollPanecolumn1, (Object)"list1");
        this.jXMultiSplitPane1.add((Component)this.jScrollPaneColumn2, (Object)"list2");
        this.jXMultiSplitPane1.add((Component)this.thirdColumnPanel, (Object)"list3");
        this.thirdColumnPanel.add(this.jScrollPaneColumn3);
        this.jEditorPane1.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int y = 0;
                int x = 0;
                try {
                    String text = ExpressionEditor2.this.jEditorPane1.getText(0, ExpressionEditor2.this.jEditorPane1.getCaretPosition());
                    String[] lines = text.split("[\\r\\n]+");
                    y = lines.length;
                    x = lines[lines.length - 1].length();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ExpressionEditor2.this.jLabelCaretPosition.setText("Ln " + y + ", Col " + x);
            }
        });
        this.jEditorPane1.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ExpressionEditor2.this.checkSyntax();
            }

            public void removeUpdate(DocumentEvent e) {
                ExpressionEditor2.this.checkSyntax();
            }

            public void changedUpdate(DocumentEvent e) {
                ExpressionEditor2.this.checkSyntax();
            }
        });
        this.refreshContext();
    }

    public void checkSyntax() {
        this.jLabelErrors.setForeground(Color.BLACK);
        this.jLabelErrors.setText("The expression syntax is correct");
        String exp = this.jEditorPane1.getText();
        while (exp.length() > 0 && Character.isWhitespace(exp.charAt(exp.length() - 1))) {
            exp = exp.substring(0, exp.length() - 1);
        }
        if (exp.endsWith(";")) {
            Point p = this.findCaretPosition(exp);
            this.jLabelErrors.setForeground(Color.red.darker());
            this.jLabelErrors.setText("Invalid character ';' at line: " + p.y + ", column: " + p.x);
        }
        String[] patterns = new String[]{"$P{", "$V{", "$F{", "$R{"};
        String[] patternNames = new String[]{"Parameter", "Variable", "Field", "Resource"};
        for (int k = 0; k < patterns.length; ++k) {
            while (exp.indexOf(patterns[k]) >= 0) {
                int initialIndex = exp.indexOf(patterns[k]);
                boolean endFound = false;
                for (int index = initialIndex; index >= 0 && index < exp.length(); ++index) {
                    char c = exp.charAt(index);
                    exp = exp.substring(0, index) + "X" + exp.substring(index + 1);
                    if (c != '}') continue;
                    endFound = true;
                    break;
                }
                if (endFound) continue;
                String text = this.jEditorPane1.getText();
                Point p = this.findCaretPosition(text, initialIndex);
                this.jLabelErrors.setForeground(Color.red.darker());
                this.jLabelErrors.setText("Report " + patternNames[k] + " reference not closed at line: " + p.y + ", column: " + p.x);
                return;
            }
        }
        exp = exp + ";";
        Parser parser = new Parser((Reader)new StringReader(exp));
        try {
            parser.Line();
        }
        catch (ParseException ex) {
            Token errorToken = null;
            Token tmp = parser.getToken(0);
            int i = 1;
            while (tmp != null) {
                errorToken = tmp;
                tmp = tmp.next;
                ++i;
            }
            String message = ex.getMessage() + "\n";
            if (errorToken != null) {
                Point p = this.findCaretPosition(exp);
                if (p.y == errorToken.beginLine && p.x == errorToken.beginColumn) {
                    message = "Incomplete expression.";
                }
            }
            this.jLabelErrors.setForeground(Color.red.darker());
            this.jLabelErrors.setText(message);
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    private Point findCaretPosition(String text) {
        Point p = new Point(0, 1);
        String[] lines = text.split("[\\r\\n]+");
        p.y = lines.length;
        p.x = lines[lines.length - 1].length();
        return p;
    }

    private Point findCaretPosition(String text, int position) {
        return this.findCaretPosition(text.substring(0, position));
    }

    public void refreshContext() {
        this.setRefreshingContext(true);
        this.jList2.removeAll();
        this.jList3.removeAll();
        ((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).removeAllChildren();
        if (this.getExpressionContext() != null) {
            if (this.getExpressionContext().getDatasets().size() > 0) {
                JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                ((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).add(new DefaultMutableTreeNode(new NamedIconItem((Object)PARAMETERS, I18n.getString("ExpressionEditor.IconName.Parameters"), "com/jaspersoft/ireport/designer/resources/parameters-16.png")));
                ((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).add(new DefaultMutableTreeNode(new NamedIconItem((Object)FIELDS, I18n.getString("ExpressionEditor.IconName.Fields"), "com/jaspersoft/ireport/designer/resources/fields-16.png")));
                ((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).add(new DefaultMutableTreeNode(new NamedIconItem((Object)VARIABLES, I18n.getString("ExpressionEditor.IconName.Variables"), "com/jaspersoft/ireport/designer/resources/variables-16.png")));
            }
            int i = 0;
            for (JRDesignCrosstab crosstab : this.getExpressionContext().getCrosstabs()) {
                ++i;
                String key = crosstab.getKey();
                if (key == null) {
                    key = "";
                }
                ((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).add(new DefaultMutableTreeNode(new NamedIconItem((Object)crosstab, I18n.getString("ExpressionEditor.IconName.Crosstab") + i + ") " + key, "com/jaspersoft/ireport/designer/resources/crosstab-16.png")));
            }
        }
        ((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).add(this.getFunctionsNode());
        ((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).add(new DefaultMutableTreeNode(new NamedIconItem((Object)USER_DEFINED_EXPRESSIONS, I18n.getString("ExpressionEditor.IconName.UserDefinedExpr"), "com/jaspersoft/ireport/designer/resources/folder.png")));
        ((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).add(new DefaultMutableTreeNode(new NamedIconItem((Object)RECENT_EXPRESSIONS, I18n.getString("ExpressionEditor.IconName.RecentExpr"), "com/jaspersoft/ireport/designer/resources/folder.png")));
        this.jTree1.updateUI();
        this.setRefreshingContext(false);
    }

    public String getPrintableTypeName(String type) {
        if (type == null) {
            return "void";
        }
        if (type.endsWith(";")) {
            type = type.substring(0, type.length() - 1);
        }
        while (type.startsWith("[")) {
            if ((type = type.substring(1) + "[]").startsWith("[")) continue;
            if (type.startsWith("L")) {
                type = type.substring(1);
            }
            if (type.startsWith("Z")) {
                type = "boolean" + type.substring(1);
            }
            if (type.startsWith("B")) {
                type = "byte" + type.substring(1);
            }
            if (type.startsWith("C")) {
                type = "char" + type.substring(1);
            }
            if (type.startsWith("D")) {
                type = "double" + type.substring(1);
            }
            if (type.startsWith("F")) {
                type = "float" + type.substring(1);
            }
            if (type.startsWith("I")) {
                type = "int" + type.substring(1);
            }
            if (type.startsWith("J")) {
                type = "long" + type.substring(1);
            }
            if (!type.startsWith("S")) continue;
            type = "short" + type.substring(1);
        }
        if (type.startsWith("java.lang.") && (type = type.substring("java.lang.".length())).indexOf(".") > 0) {
            type = "java.lang." + type;
        }
        return type;
    }

    private void initComponents() {
        this.jScrollPanecolumn1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jPanelEditorArea = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new ExpressionEditorPane();
        this.jPanel3 = new JPanel();
        this.jLabelErrors = new JLabel();
        this.jLabelCaretPosition = new JLabel();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.jButton12 = new JButton();
        this.jButton13 = new JButton();
        this.jButton14 = new JButton();
        this.jScrollPaneColumn2 = new JScrollPane();
        this.jList2 = new JList();
        this.jScrollPaneColumn3 = new JScrollPane();
        this.jList3 = new JList();
        this.jButtonImport = new JButton();
        this.jButtonExport = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonApply = new JButton();
        this.jLabel1 = new JLabel();
        this.jXMultiSplitPane1 = new JXMultiSplitPane();
        this.jTree1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTree1.setRootVisible(false);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ExpressionEditor2.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPanecolumn1.setViewportView(this.jTree1);
        this.jPanelEditorArea.setLayout(new BorderLayout());
        this.jEditorPane1.addInputMethodListener(new InputMethodListener(){

            public void caretPositionChanged(InputMethodEvent evt) {
                ExpressionEditor2.this.jEditorPane1CaretPositionChanged(evt);
            }

            public void inputMethodTextChanged(InputMethodEvent evt) {
            }
        });
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.jPanelEditorArea.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelErrors.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/errorhandler/accept.png")));
        this.jLabelErrors.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jLabelErrors.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jLabelErrors, gridBagConstraints);
        this.jLabelCaretPosition.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jLabelCaretPosition.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabelCaretPosition, gridBagConstraints);
        this.jButton1.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton1.toolTipText"));
        this.jButton1.setMargin(new Insets(2, 8, 2, 8));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor2.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton2.text"));
        this.jButton2.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton2.toolTipText"));
        this.jButton2.setMargin(new Insets(2, 8, 2, 8));
        this.jButton3.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton3.text"));
        this.jButton3.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton3.toolTipText"));
        this.jButton3.setMargin(new Insets(2, 8, 2, 8));
        this.jButton4.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton4.text"));
        this.jButton4.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton4.toolTipText"));
        this.jButton4.setMargin(new Insets(2, 8, 2, 8));
        this.jButton5.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton5.text"));
        this.jButton5.setMargin(new Insets(2, 8, 2, 8));
        this.jButton6.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton6.text"));
        this.jButton6.setMargin(new Insets(2, 8, 2, 8));
        this.jButton7.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton7.text"));
        this.jButton7.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton7.toolTipText"));
        this.jButton7.setMargin(new Insets(2, 8, 2, 8));
        this.jButton8.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton8.text"));
        this.jButton8.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton8.toolTipText"));
        this.jButton8.setMargin(new Insets(2, 8, 2, 8));
        this.jButton9.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton9.text"));
        this.jButton9.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton9.toolTipText"));
        this.jButton9.setMargin(new Insets(2, 8, 2, 8));
        this.jButton10.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton10.text"));
        this.jButton10.setMargin(new Insets(2, 8, 2, 8));
        this.jButton11.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton11.text"));
        this.jButton11.setMargin(new Insets(2, 8, 2, 8));
        this.jButton12.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton12.text"));
        this.jButton12.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton12.toolTipText"));
        this.jButton12.setMargin(new Insets(2, 8, 2, 8));
        this.jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor2.this.jButton12ActionPerformed(evt);
            }
        });
        this.jButton13.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton13.text"));
        this.jButton13.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton13.toolTipText"));
        this.jButton13.setMargin(new Insets(2, 8, 2, 8));
        this.jButton13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor2.this.jButton13ActionPerformed(evt);
            }
        });
        this.jButton14.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton14.text"));
        this.jButton14.setToolTipText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButton14.toolTipText"));
        this.jButton14.setMargin(new Insets(2, 8, 2, 8));
        this.jButton14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor2.this.jButton14ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jButton1).add(2, 2, 2).add((Component)this.jButton2).add(2, 2, 2).add((Component)this.jButton3).add(2, 2, 2).add((Component)this.jButton4).add(2, 2, 2).add((Component)this.jButton5).add(2, 2, 2).add((Component)this.jButton6).add(2, 2, 2).add((Component)this.jButton7).add(2, 2, 2).add((Component)this.jButton8).add(2, 2, 2).add((Component)this.jButton9).add(2, 2, 2).add((Component)this.jButton10).add(2, 2, 2).add((Component)this.jButton11).add(2, 2, 2).add((Component)this.jButton12).add(2, 2, 2).add((Component)this.jButton13).add(2, 2, 2).add((Component)this.jButton14)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jButton1).add((Component)this.jButton2).add((Component)this.jButton3).add((Component)this.jButton4).add((Component)this.jButton7).add((Component)this.jButton8).add((Component)this.jButton9).add((Component)this.jButton10).add((Component)this.jButton11).add((Component)this.jButton12).add((Component)this.jButton13).add((Component)this.jButton5).add((Component)this.jButton6).add((Component)this.jButton14)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanelEditorArea.add((Component)this.jPanel3, "South");
        this.jList2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jList2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ExpressionEditor2.this.jList2MouseClicked(evt);
            }
        });
        this.jList2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExpressionEditor2.this.jList2ValueChanged(evt);
            }
        });
        this.jScrollPaneColumn2.setViewportView(this.jList2);
        this.jList3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ExpressionEditor2.this.jList3MouseClicked(evt);
            }
        });
        this.jScrollPaneColumn3.setViewportView(this.jList3);
        this.setPreferredSize(new Dimension(750, 650));
        this.jButtonImport.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButtonImport.text"));
        this.jButtonImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor2.this.jButtonImportActionPerformed(evt);
            }
        });
        this.jButtonExport.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButtonExport.text"));
        this.jButtonExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor2.this.jButtonExportActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor2.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonApply.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jButtonApply.text"));
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExpressionEditor2.this.jButtonApplyActionPerformed(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(ExpressionEditor2.class, (String)"ExpressionEditor2.jLabel1.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jXMultiSplitPane1, -1, 730, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonImport).addPreferredGap(0).add((Component)this.jButtonExport).addPreferredGap(0, 440, Short.MAX_VALUE).add((Component)this.jButtonApply).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (Component)this.jLabel1, -1, 730, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jXMultiSplitPane1, -1, 579, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonImport).add((Component)this.jButtonExport).add((Component)this.jButtonCancel).add((Component)this.jButtonApply)).addContainerGap()));
    }

    private void jList2ValueChanged(ListSelectionEvent evt) {
        if (this.isRefreshingContext()) {
            return;
        }
        DefaultListModel dlm = (DefaultListModel)this.jList3.getModel();
        dlm.removeAllElements();
        Class<?> clazz = null;
        if (this.jList2.getSelectedValue() instanceof ExpObject) {
            Component c = this.thirdColumnPanel.getComponent(0);
            if (c != this.jScrollPaneColumn3) {
                this.thirdColumnPanel.removeAll();
                this.thirdColumnPanel.add((Component)this.jScrollPaneColumn3, "Center");
                this.thirdColumnPanel.updateUI();
            }
            try {
                clazz = IReportManager.getReportClassLoader().loadClass(((ExpObject)this.jList2.getSelectedValue()).getClassType());
            }
            catch (Throwable ex3) {
                // empty catch block
            }
            if (clazz != null) {
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if ((methods[i].getModifiers() & 1) == 0) continue;
                    String method_firm = methods[i].getName() + "(";
                    Class<?>[] params = methods[i].getParameterTypes();
                    int j = 0;
                    for (j = 0; j < params.length; ++j) {
                        method_firm = j > 0 ? method_firm + ", " : method_firm + " ";
                        method_firm = method_firm + this.getPrintableTypeName(params[j].getName());
                    }
                    if (j > 0) {
                        method_firm = method_firm + " ";
                    }
                    method_firm = method_firm + ") ";
                    String rname = methods[i].getReturnType().getName();
                    if (rname.equals("void")) continue;
                    method_firm = method_firm + this.getPrintableTypeName(rname);
                    dlm.addElement(method_firm);
                }
            }
        } else if (this.jList2.getSelectedValue() instanceof Function) {
            Component c = this.thirdColumnPanel.getComponent(0);
            if (c != this.functionPanel || this.functionPanel == null) {
                if (this.functionPanel == null) {
                    this.functionPanel = new FunctionPanel();
                }
                this.thirdColumnPanel.removeAll();
                this.thirdColumnPanel.add((Component)this.functionPanel, "Center");
                this.thirdColumnPanel.updateUI();
            }
            this.functionPanel.setFunction((Function)this.jList2.getSelectedValue());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialogResult = 2;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jList3MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.jList2.getSelectedValue() != null && this.jList3.getSelectedValue() != null) {
            try {
                String objName = "";
                objName = this.jList2.getSelectedValue() instanceof ExpObject ? ((ExpObject)this.jList2.getSelectedValue()).getExpression() : "" + this.jList2.getSelectedValue();
                String method = this.jList3.getSelectedValue() + "";
                method = method.substring(0, method.lastIndexOf(")") + 1);
                this.jEditorPane1.replaceSelection(objName + "." + method);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jList2MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            try {
                String objName = "";
                objName = this.jList2.getSelectedValue() instanceof ExpObject ? ((ExpObject)this.jList2.getSelectedValue()).getExpression() : "" + this.jList2.getSelectedValue();
                this.jEditorPane1.replaceSelection(objName + "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        if (this.dialog != null && this.dialog.isVisible()) {
            String exp = this.getExpression();
            recentExpressions.remove(exp);
            recentExpressions.add(0, exp);
            this.dialogResult = 0;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        String expression = Misc.loadExpression(this);
        if (expression != null) {
            this.jEditorPane1.setText(expression);
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        Misc.saveExpression(this.jEditorPane1.getText(), this);
    }

    private void jEditorPane1CaretPositionChanged(InputMethodEvent evt) {
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        Object obj = this.jTree1.getSelectionPath().getLastPathComponent();
        if (obj != null && obj instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)obj).getUserObject() instanceof NamedIconItem) {
            NamedIconItem item = (NamedIconItem)((DefaultMutableTreeNode)obj).getUserObject();
            if (this.isRefreshingContext()) {
                return;
            }
            this.setRefreshingContext(true);
            DefaultListModel<Object> dlm2 = new DefaultListModel<Object>();
            DefaultListModel dlm3 = (DefaultListModel)this.jList3.getModel();
            dlm2.removeAllElements();
            dlm3.removeAllElements();
            if (item != null) {
                if (item.getItem() instanceof Tag && ((Tag)item.getItem()).getValue() instanceof String) {
                    List<Function> exps = FunctionsUtils.getFunctionsByCategory((String)((Tag)item.getItem()).getValue());
                    for (Function s : exps) {
                        dlm2.addElement(s);
                    }
                } else if (item.getItem().equals(USER_DEFINED_EXPRESSIONS)) {
                    ArrayList<String> exps = ExpressionEditor2.getPredefinedExpressions();
                    for (String s : exps) {
                        dlm2.addElement(s);
                    }
                } else if (item.getItem().equals(RECENT_EXPRESSIONS)) {
                    for (String s : recentExpressions) {
                        dlm2.addElement(s);
                    }
                } else if (item.getItem().equals(PARAMETERS)) {
                    JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                    Iterator parameters = ds.getParametersList().iterator();
                    while (parameters.hasNext()) {
                        dlm2.addElement(new ExpObject(parameters.next()));
                    }
                } else if (item.getItem().equals(FIELDS)) {
                    JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                    Iterator fields = ds.getFieldsList().iterator();
                    while (fields.hasNext()) {
                        ExpObject eo = new ExpObject(fields.next());
                        dlm2.addElement(eo);
                    }
                } else if (item.getItem().equals(VARIABLES)) {
                    JRDesignDataset ds = this.getExpressionContext().getDatasets().get(0);
                    Iterator variables = ds.getVariablesList().iterator();
                    while (variables.hasNext()) {
                        dlm2.addElement(new ExpObject(variables.next()));
                    }
                } else if (item.getItem() instanceof JRDesignCrosstab) {
                    int i;
                    JRDesignCrosstab crosstab = (JRDesignCrosstab)item.getItem();
                    List rowGroups = crosstab.getRowGroupsList();
                    List columnGroups = crosstab.getColumnGroupsList();
                    for (JRDesignCrosstabMeasure measure : crosstab.getMesuresList()) {
                        dlm2.addElement(new ExpObject(measure.getVariable()));
                        for (int i2 = 0; i2 < rowGroups.size(); ++i2) {
                            JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i2);
                            dlm2.addElement(new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, null));
                            for (int j = 0; j < columnGroups.size(); ++j) {
                                JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(j);
                                if (j == 0) {
                                    dlm2.addElement(new CrosstabTotalVariable((JRCrosstabMeasure)measure, null, (JRCrosstabColumnGroup)columnGroup));
                                }
                                dlm2.addElement(new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, (JRCrosstabColumnGroup)columnGroup));
                            }
                        }
                    }
                    for (i = 0; i < rowGroups.size(); ++i) {
                        JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i);
                        dlm2.addElement(new ExpObject(rowGroup.getVariable()));
                    }
                    for (i = 0; i < columnGroups.size(); ++i) {
                        JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(i);
                        dlm2.addElement(new ExpObject(columnGroup.getVariable()));
                    }
                    List crosstabParameters = crosstab.getParametersList();
                    for (int i3 = 0; i3 < crosstabParameters.size(); ++i3) {
                        JRDesignCrosstabParameter parameter = (JRDesignCrosstabParameter)crosstabParameters.get(i3);
                        dlm2.addElement(new ExpObject(parameter));
                    }
                }
                this.jList2.setModel(dlm2);
                this.setRefreshingContext(false);
                if (dlm2.size() > 0) {
                    this.jList2.setSelectedIndex(0);
                }
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
    }

    private void jButton14ActionPerformed(ActionEvent evt) {
    }

    public int showDialog(Component parent) {
        Window pWin;
        this.jButtonApply.setVisible(true);
        this.jButtonCancel.setVisible(true);
        Window window = pWin = parent != null ? SwingUtilities.windowForComponent(parent) : null;
        this.dialog = pWin instanceof Dialog ? new JDialog((Dialog)pWin) : (pWin instanceof Frame ? new JDialog((Frame)pWin) : new JDialog());
        this.dialog.setModal(true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ExpressionEditor2.this.jButtonCancelActionPerformed(e);
            }
        };
        this.dialog.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.dialog.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.dialog.getRootPane().setDefaultButton(this.jButtonApply);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialogResult = 2;
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setTitle(I18n.getString("ExpressionEditor.Title.ExpressionEditor"));
        this.dialog.setVisible(true);
        return this.dialogResult;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isEnabled() && this.isFocusable()) {
            this.jEditorPane1.requestFocus();
        }
    }

    public boolean isRefreshingContext() {
        return this.refreshingContext;
    }

    public void setRefreshingContext(boolean refreshingContext) {
        this.refreshingContext = refreshingContext;
    }

    public DefaultMutableTreeNode getFunctionsNode() {
        if (functionsNode == null) {
            functionsNode = new DefaultMutableTreeNode(new NamedIconItem((Object)FUNCTIONS, "Built-in functions", "com/jaspersoft/ireport/designer/resources/folder.png"));
            List<Tag> categories = FunctionsUtils.getFunctionCategories();
            for (Tag t : categories) {
                functionsNode.add(new DefaultMutableTreeNode(new NamedIconItem((Object)t, "" + t, "com/jaspersoft/ireport/designer/resources/folder.png")));
            }
        }
        return functionsNode;
    }

    static {
        defaultExpressions = new ArrayList();
        defaultExpressions.add("( <condition> ? exp1 : exp2 )");
        defaultExpressions.add("msg(<pattern>, <arg0>)");
        defaultExpressions.add("msg(<pattern>, <arg0>, <arg1>)");
        defaultExpressions.add("msg(<pattern>, <arg0>, <arg1>, <arg2>)");
        defaultExpressions.add("str(<key>)");
        defaultExpressions.add("((net.sf.jasperreports.engine.data.JRXmlDataSource)$P{REPORT_DATA_SOURCE}).subDataSource(<select expression>)");
        defaultExpressions.add("((net.sf.jasperreports.engine.data.JRXmlDataSource)$P{REPORT_DATA_SOURCE}).dataSource(<select expression>)");
    }
}

