/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ThreadUtils;
import com.jaspersoft.ireport.designer.actions.KeyboardElementMoveAction;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithMoveStrategyProvider;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithResizeStrategyProvider;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithWidgetCollector;
import com.jaspersoft.ireport.designer.actions.TranslucentRectangularSelectDecorator;
import com.jaspersoft.ireport.designer.crosstab.CellInfo;
import com.jaspersoft.ireport.designer.crosstab.actions.CellSelectionAction;
import com.jaspersoft.ireport.designer.crosstab.actions.CellSeparatorMoveAction;
import com.jaspersoft.ireport.designer.crosstab.widgets.CellSeparatorWidget;
import com.jaspersoft.ireport.designer.crosstab.widgets.CrosstabWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignImageWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import com.jaspersoft.ireport.designer.widgets.visitor.ConfigurableDrawVisitor;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabObjectScene
extends AbstractReportObjectScene
implements PropertyChangeListener {
    private CrosstabWidget crosstabWidget = null;
    private List<JRDesignElement> selectedElements = new ArrayList<JRDesignElement>();
    private ReportAlignWithWidgetCollector reportAlignWithWidgetCollector = null;
    private ReportAlignWithMoveStrategyProvider reportAlignWithMoveStrategyProvider = null;
    private ReportAlignWithResizeStrategyProvider reportAlignWithResizeStrategyProvider = null;
    private KeyboardElementMoveAction keyboardElementMoveAction = null;
    private CellSelectionAction cellSelectionAction = null;
    private List<Integer> verticalSeparators = new ArrayList<Integer>();
    private List<Integer> horizontalSeparators = new ArrayList<Integer>();
    private JasperDesign jasperDesign = null;
    private JRDesignCrosstab designCrosstab = null;
    private DrawVisitor drawVisitor = null;
    LayerWidget backgroundLayer = null;
    LayerWidget pageLayer = null;
    LayerWidget interractionLayer = null;
    LayerWidget cellSeparatorsLayer = null;

    @Override
    public void setSnapToGrid(boolean snapToGrid) {
        if (this.snapToGrid != snapToGrid) {
            this.snapToGrid = snapToGrid;
            this.reportAlignWithMoveStrategyProvider.setSnapToGrid(snapToGrid);
            this.reportAlignWithResizeStrategyProvider.setSnapToGrid(snapToGrid);
        }
    }

    @Override
    public void setGridVisible(boolean gridVisible) {
        if (this.gridVisible != gridVisible) {
            this.gridVisible = gridVisible;
            this.pageLayer.revalidate(true);
            this.validate();
        }
    }

    public ReportAlignWithWidgetCollector getReportAlignWithWidgetCollector() {
        return this.reportAlignWithWidgetCollector;
    }

    public void setReportAlignWithWidgetCollector(ReportAlignWithWidgetCollector reportAlignWithWidgetCollector) {
        this.reportAlignWithWidgetCollector = reportAlignWithWidgetCollector;
    }

    @Override
    public DrawVisitor getDrawVisitor() {
        return this.drawVisitor;
    }

    public void setDrawVisitor(DrawVisitor drawVisitor) {
        this.drawVisitor = drawVisitor;
    }

    @Override
    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
        if (jasperDesign == null) {
            this.drawVisitor = null;
            this.rebuildDocument();
            return;
        }
        this.drawVisitor = new ConfigurableDrawVisitor((JRReport)jasperDesign, null);
        jasperDesign.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.jasperDesign.getGroupsList().size(); ++i) {
            JRDesignGroup grp = (JRDesignGroup)this.jasperDesign.getGroupsList().get(i);
            grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        ThreadUtils.invokeInAWTThread(new Runnable(){

            public void run() {
                CrosstabObjectScene.this.rebuildDocument();
            }
        });
    }

    public void addElementWidget(JRDesignElement de) {
        if (de == null) {
            return;
        }
        JRDesignElementWidget widget = null;
        widget = de instanceof JRDesignImage ? new JRDesignImageWidget((AbstractReportObjectScene)this, (JRDesignImage)de) : new JRDesignElementWidget(this, de);
        widget.getActions().addAction(this.getReportSelectAction());
        widget.getSelectionWidget().getActions().addAction((WidgetAction)this.keyboardElementMoveAction);
        widget.getSelectionWidget().getActions().addAction(this.getReportSelectAction());
        widget.getSelectionWidget().getActions().addAction(this.createObjectHoverAction());
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)this.reportAlignWithResizeStrategyProvider, (ResizeProvider)this.reportAlignWithResizeStrategyProvider));
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)this.reportAlignWithMoveStrategyProvider, (MoveProvider)this.reportAlignWithMoveStrategyProvider));
        widget.getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)this.reportAlignWithResizeStrategyProvider, (ResizeProvider)this.reportAlignWithResizeStrategyProvider));
        widget.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)this.reportAlignWithMoveStrategyProvider, (MoveProvider)this.reportAlignWithMoveStrategyProvider));
        widget.getActions().addAction(this.inplaceEditorAction);
        widget.getSelectionWidget().getActions().addAction(this.inplaceEditorAction);
        widget.getActions().addAction(elementPopupMenuAction);
        widget.getSelectionWidget().getActions().addAction(elementPopupMenuAction);
        widget.getActions().addAction(ActionFactory.createActionMapAction((InputMap)elementInputMap, (ActionMap)elementActionMap));
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createActionMapAction((InputMap)elementInputMap, (ActionMap)elementActionMap));
        this.elementsLayer.addChild((Widget)widget);
        this.selectionLayer.addChild((Widget)widget.getSelectionWidget());
        this.addObject(de, new Widget[]{widget});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildDocument() {
        boolean oldUpdateingStatus = this.isUpdatingView();
        try {
            this.setUpdatingView(true);
            this.pageLayer.removeChildren();
            this.elementsLayer.removeChildren();
            this.cellSeparatorsLayer.removeChildren();
            this.selectionLayer.removeChildren();
            this.backgroundLayer.removeChildren();
            this.interractionLayer.removeChildren();
            while (this.getObjects().size() > 0) {
                this.removeObject(this.getObjects().iterator().next());
            }
            if (this.jasperDesign == null) {
                return;
            }
            this.getDesignCrosstab().preprocess();
            if (this.crosstabWidget == null) {
                this.crosstabWidget = new CrosstabWidget(this, this.getDesignCrosstab());
            } else {
                this.crosstabWidget.updateBounds();
            }
            this.pageLayer.addChild((Widget)this.getCrosstabWidget());
            this.refreshCells();
        }
        finally {
            this.setUpdatingView(oldUpdateingStatus);
        }
    }

    public boolean[] columnExistsArray() {
        JRCrosstabRowGroup[] row_groups = this.getDesignCrosstab().getRowGroups();
        JRCrosstabColumnGroup[] col_groups = this.getDesignCrosstab().getColumnGroups();
        boolean[] cols = new boolean[row_groups.length + col_groups.length + 1];
        Arrays.fill(cols, true);
        int w = col_groups.length + 1;
        int currentX = row_groups.length;
        for (JRCrosstabColumnGroup colGroup : col_groups) {
            if (colGroup.getTotalPositionValue() == CrosstabTotalPositionEnum.START) {
                ++currentX;
            } else if (colGroup.getTotalPositionValue() == CrosstabTotalPositionEnum.NONE) {
                cols[currentX + w - 1] = false;
            }
            --w;
        }
        return cols;
    }

    public boolean[] rowExistsArray() {
        JRCrosstabRowGroup[] row_groups = this.getDesignCrosstab().getRowGroups();
        JRCrosstabColumnGroup[] col_groups = this.getDesignCrosstab().getColumnGroups();
        boolean[] rows = new boolean[row_groups.length + col_groups.length + 1];
        Arrays.fill(rows, true);
        int h = row_groups.length + 1;
        int currentY = col_groups.length;
        for (JRCrosstabRowGroup rowGroup : row_groups) {
            if (rowGroup.getTotalPositionValue() == CrosstabTotalPositionEnum.START) {
                ++currentY;
            } else if (rowGroup.getTotalPositionValue() == CrosstabTotalPositionEnum.NONE) {
                rows[currentY + h - 1] = false;
            }
            --h;
        }
        return rows;
    }

    public void refreshCells() {
        int i;
        int i2;
        int i3;
        List bWidgets = this.cellSeparatorsLayer.getChildren();
        this.cellSeparatorsLayer.removeChildren();
        this.getHorizontalSeparators().clear();
        this.getVerticalSeparators().clear();
        ArrayList<JRDesignCellContents> cellContents = new ArrayList<JRDesignCellContents>();
        cellContents.add((JRDesignCellContents)this.getDesignCrosstab().getHeaderCell());
        JRCrosstabRowGroup[] row_groups = this.getDesignCrosstab().getRowGroups();
        JRCrosstabColumnGroup[] col_groups = this.getDesignCrosstab().getColumnGroups();
        JRCrosstabCell[][] cells = ModelUtils.normalizeCell(this.getDesignCrosstab().getCells(), row_groups, col_groups);
        int current_x = 0;
        for (i3 = 0; i3 < row_groups.length; ++i3) {
            this.getVerticalSeparators().add(current_x += row_groups[i3].getHeader().getWidth());
            cellContents.add((JRDesignCellContents)row_groups[i3].getHeader());
            if (row_groups[i3].getTotalPosition() == 0) continue;
            cellContents.add((JRDesignCellContents)row_groups[i3].getTotalHeader());
        }
        for (i3 = cells[0].length - 1; i3 >= 0; --i3) {
            this.getVerticalSeparators().add(current_x += ModelUtils.findColumnWidth(cells, i3));
        }
        int current_y = 0;
        for (i2 = 0; i2 < col_groups.length; ++i2) {
            this.getHorizontalSeparators().add(current_y += col_groups[i2].getHeader().getHeight());
            cellContents.add((JRDesignCellContents)col_groups[i2].getHeader());
            if (col_groups[i2].getTotalPosition() == 0) continue;
            cellContents.add((JRDesignCellContents)col_groups[i2].getTotalHeader());
        }
        for (i2 = cells.length - 1; i2 >= 0; --i2) {
            this.getHorizontalSeparators().add(current_y += ModelUtils.findRowHeight(cells, i2));
        }
        boolean[] rowsExists = this.rowExistsArray();
        for (int i4 = 0; i4 < this.getHorizontalSeparators().size(); ++i4) {
            if (!rowsExists[i4]) continue;
            CellSeparatorWidget w = new CellSeparatorWidget(this, i4, SeparatorWidget.Orientation.HORIZONTAL);
            w.getActions().addAction((WidgetAction)new CellSeparatorMoveAction(true, 64));
            w.getActions().addAction((WidgetAction)new CellSeparatorMoveAction());
            this.cellSeparatorsLayer.addChild((Widget)w);
        }
        boolean[] colsExists = this.columnExistsArray();
        for (i = 0; i < this.getVerticalSeparators().size(); ++i) {
            if (!colsExists[i]) continue;
            CellSeparatorWidget w = new CellSeparatorWidget(this, i, SeparatorWidget.Orientation.VERTICAL);
            w.getActions().addAction((WidgetAction)new CellSeparatorMoveAction(true, 64));
            w.getActions().addAction((WidgetAction)new CellSeparatorMoveAction());
            this.cellSeparatorsLayer.addChild((Widget)w);
        }
        for (i = cells.length - 1; i >= 0; --i) {
            for (int j = cells[i].length - 1; j >= 0; --j) {
                if (cells[i][j] == null) continue;
                cellContents.add((JRDesignCellContents)cells[i][j].getContents());
            }
        }
        ArrayList toBeRemovedObjects = new ArrayList();
        ArrayList<Widget> toBeRemoved = new ArrayList<Widget>();
        ArrayList<SelectionWidget> toBeRemovedSelection = new ArrayList<SelectionWidget>();
        for (Object obj : this.getObjects()) {
            if (!(obj instanceof JRDesignElement) || !ModelUtils.isOrphan((JRDesignElement)obj, this.getJasperDesign())) continue;
            Widget w = this.findWidget(obj);
            if (w != null) {
                toBeRemoved.add(w);
                toBeRemovedSelection.add(((JRDesignElementWidget)w).getSelectionWidget());
            }
            toBeRemovedObjects.add(obj);
        }
        for (Object obj : toBeRemovedObjects) {
            this.removeObject(obj);
        }
        this.elementsLayer.removeChildren(toBeRemoved);
        this.selectionLayer.removeChildren(toBeRemovedSelection);
        for (JRDesignCellContents content : cellContents) {
            if (content == null) continue;
            this.addElements(content.getChildren());
        }
        List widgets = this.elementsLayer.getChildren();
        this.validate();
    }

    private void addElements(List children) {
        for (int i = 0; i < children.size(); ++i) {
            Object obj = children.get(i);
            if (obj instanceof JRDesignElementGroup) {
                if (!this.elementGroupListeners.containsKey(obj)) {
                    AbstractReportObjectScene.GroupChangeListener gcl = new AbstractReportObjectScene.GroupChangeListener((JRDesignElementGroup)obj);
                    ((JRDesignElementGroup)obj).getEventSupport().addPropertyChangeListener((PropertyChangeListener)gcl);
                    this.elementGroupListeners.put(obj, gcl);
                }
                this.addElements(((JRDesignElementGroup)obj).getChildren());
            }
            if (!(obj instanceof JRDesignElement)) continue;
            JRDesignElement de = (JRDesignElement)children.get(i);
            JRDesignElementWidget w = (JRDesignElementWidget)this.findWidget(de);
            if (w != null) {
                w.updateBounds();
            } else {
                this.addElementWidget(de);
            }
            if (!(de instanceof JRDesignFrame)) continue;
            this.addElements(((JRDesignFrame)de).getChildren());
        }
    }

    public JRDesignElementWidget findElementWidget(JRDesignElement de) {
        List widgets = this.elementsLayer.getChildren();
        for (Widget w : widgets) {
            JRDesignElementWidget dew;
            if (!(w instanceof JRDesignElementWidget) || (dew = (JRDesignElementWidget)w).getElement() != de) continue;
            return dew;
        }
        return null;
    }

    @Override
    public void refreshElementGroup(JRElementGroup group) {
    }

    public LayerWidget getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public LayerWidget getPageLayer() {
        return this.pageLayer;
    }

    public LayerWidget getInterractionLayer() {
        return this.interractionLayer;
    }

    public LayerWidget getCellSeparatorsLayer() {
        return this.cellSeparatorsLayer;
    }

    public void setCellSeparatorsLayer(LayerWidget cellSeparatorsLayer) {
        this.cellSeparatorsLayer = cellSeparatorsLayer;
    }

    public CrosstabObjectScene(JRDesignCrosstab ct, JasperDesign jd) {
        this.jasperDesign = jd;
        this.designCrosstab = ct;
        this.initScene();
    }

    private void initScene() {
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.backgroundLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.backgroundLayer);
        this.pageLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.pageLayer);
        this.elementsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.elementsLayer);
        this.cellSeparatorsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.cellSeparatorsLayer);
        this.selectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.selectionLayer);
        this.guideLinesLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.guideLinesLayer);
        this.interractionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.interractionLayer);
        this.reportAlignWithWidgetCollector = new ReportAlignWithWidgetCollector(this);
        this.reportAlignWithMoveStrategyProvider = new ReportAlignWithMoveStrategyProvider(this.reportAlignWithWidgetCollector, this.interractionLayer, ALIGN_WITH_MOVE_DECORATOR_DEFAULT, false);
        this.reportAlignWithResizeStrategyProvider = new ReportAlignWithResizeStrategyProvider(this.reportAlignWithWidgetCollector, this.interractionLayer, ALIGN_WITH_MOVE_DECORATOR_DEFAULT, false);
        this.cellSelectionAction = new CellSelectionAction();
        this.getActions().addAction(reportPopupMenuAction);
        this.getActions().addAction((WidgetAction)this.cellSelectionAction);
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((RectangularSelectDecorator)new TranslucentRectangularSelectDecorator((Scene)this), (LayerWidget)this.interractionLayer, (RectangularSelectProvider)ActionFactory.createObjectSceneRectangularSelectProvider((ObjectScene)this)));
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.1));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.keyboardElementMoveAction = new KeyboardElementMoveAction();
        this.getActions().addAction((WidgetAction)this.keyboardElementMoveAction);
        this.setMaximumBounds(new Rectangle(-10, -10, Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.drawVisitor = new ConfigurableDrawVisitor((JRReport)this.getJasperDesign(), null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CrosstabObjectScene.this.rebuildDocument();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public JRDesignCrosstab getDesignCrosstab() {
        return this.designCrosstab;
    }

    public void setDesignCrosstab(JRDesignCrosstab designCrosstab) {
        this.designCrosstab = designCrosstab;
    }

    public CrosstabWidget getCrosstabWidget() {
        return this.crosstabWidget;
    }

    public List<Integer> getVerticalSeparators() {
        return this.verticalSeparators;
    }

    public List<Integer> getHorizontalSeparators() {
        return this.horizontalSeparators;
    }

    @Override
    public boolean acceptDropAt(Point location) {
        Point p = this.convertViewToScene(location);
        JRDesignCrosstab crosstab = this.getDesignCrosstab();
        List<CellInfo> cells = ModelUtils.getCellInfos(crosstab);
        int crosstabWidth = 0;
        int crosstabHeight = 0;
        for (int i = 0; i < cells.size(); ++i) {
            int thisH;
            CellInfo ci = cells.get(i);
            int thisW = ci.getLeft() + ci.getCellContents().getWidth();
            if (thisW > crosstabWidth) {
                crosstabWidth = thisW;
            }
            if ((thisH = ci.getTop() + ci.getCellContents().getHeight()) <= crosstabHeight) continue;
            crosstabHeight = thisH;
        }
        return new Rectangle(0, 0, crosstabWidth, crosstabHeight).contains(p);
    }
}

