/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

abstract class LookupSensitiveAction
extends BasicAction
implements Runnable,
LookupListener,
Presenter.Popup,
Presenter.Menu {
    static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions");
    private static Logger LOG = Logger.getLogger(LookupSensitiveAction.class.getName());
    private Lookup lookup;
    private Class<?>[] watch;
    private Lookup.Result[] results;
    private boolean needsRefresh = true;
    private boolean initialized = false;
    private boolean refreshing = false;

    public LookupSensitiveAction(Icon icon, Lookup lookup, Class[] classArray) {
        super(null, icon);
        if (lookup == null) {
            lookup = LastActivatedWindowLookup.INSTANCE;
        }
        this.lookup = lookup;
        this.watch = classArray;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        assert (EventQueue.isDispatchThread()) : "Cannot be called outside EQ!";
        this.results = new Lookup.Result[this.watch.length];
        for (int i = 0; i < this.watch.length; ++i) {
            this.results[i] = this.lookup.lookupResult(this.watch[i]);
            this.results[i].allItems();
            LookupListener lookupListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)this.results[i]);
            this.results[i].addLookupListener(lookupListener);
        }
        this.initialized = true;
    }

    public Object getValue(String string) {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh();
        }
        return super.getValue(string);
    }

    public boolean isEnabled() {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh();
        }
        return super.isEnabled();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        this.init();
        if (UILOG.isLoggable(Level.FINE) && !(bl = actionEvent.getSource() instanceof JMenuItem ? false : !(actionEvent.getSource() instanceof JButton))) {
            LogRecord logRecord = new LogRecord(Level.FINE, "UI_ACTION_BUTTON_PRESS");
            logRecord.setResourceBundle(NbBundle.getBundle(LookupSensitiveAction.class));
            logRecord.setParameters(new Object[]{actionEvent.getSource(), actionEvent.getSource().getClass().getName(), this, this.getClass().getName(), this.getValue("Name")});
            logRecord.setLoggerName(UILOG.getName());
            UILOG.log(logRecord);
        }
        this.actionPerformed(this.lookup);
    }

    protected final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh() {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        try {
            if (LOG.isLoggable(Level.FINER)) {
                LogRecord logRecord = new LogRecord(Level.FINER, "LOG_ACTION_REFRESH");
                logRecord.setResourceBundle(NbBundle.getBundle(LookupSensitiveAction.class));
                logRecord.setParameters(new Object[]{this.getClass(), this.lookup});
                logRecord.setLoggerName(LOG.getName());
                LOG.log(logRecord);
            }
            this.refresh(this.lookup);
        }
        finally {
            this.refreshing = false;
        }
        this.needsRefresh = false;
    }

    protected abstract void actionPerformed(Lookup var1);

    protected abstract void refresh(Lookup var1);

    public void resultChanged(LookupEvent lookupEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.getPropertyChangeListeners().length == 0) {
            this.needsRefresh = true;
        } else {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    public void run() {
        this.doRefresh();
    }

    public JMenuItem getMenuPresenter() {
        return new DynamicMenuItem(this, false);
    }

    public JMenuItem getPopupPresenter() {
        return new DynamicMenuItem(this, true);
    }

    static final class LastActivatedWindowLookup
    extends ProxyLookup
    implements PropertyChangeListener {
        static final Lookup INSTANCE = new LastActivatedWindowLookup();
        private final TopComponent.Registry reg = TopComponent.getRegistry();

        LastActivatedWindowLookup() {
            this.reg.addPropertyChangeListener((PropertyChangeListener)this);
            this.updateLookups();
        }

        private void updateLookups() {
            Node[] nodeArray = this.reg.getActivatedNodes();
            Lookup[] lookupArray = new Lookup[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                lookupArray[i] = nodeArray[i].getLookup();
            }
            this.setLookups(lookupArray);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("activatedNodes".equals(propertyChangeEvent.getPropertyName())) {
                this.updateLookups();
            }
        }
    }

    private class DynamicMenuItem
    extends JMenuItem
    implements DynamicMenuContent {
        private AbstractAction action;
        private boolean popup;

        public DynamicMenuItem(AbstractAction abstractAction, boolean bl) {
            this.action = abstractAction;
            this.popup = bl;
            Actions.connect((JMenuItem)this, (Action)abstractAction, (boolean)bl);
        }

        public JComponent[] getMenuPresenters() {
            JMenuItem jMenuItem = new JMenuItem();
            Actions.connect((JMenuItem)jMenuItem, (Action)this.action, (boolean)this.popup);
            return new JComponent[]{jMenuItem};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.getMenuPresenters();
        }
    }
}

