/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveConfigAction
extends CallableSystemAction
implements LookupListener,
PropertyChangeListener,
ContextAwareAction {
    private static final Logger LOGGER = Logger.getLogger(ActiveConfigAction.class.getName());
    private static final DefaultComboBoxModel EMPTY_MODEL = new DefaultComboBoxModel();
    private static final Object CUSTOMIZE_ENTRY = new Object();
    private final PropertyChangeListener lst;
    private final LookupListener looklst;
    private final JComboBox configListCombo;
    private boolean listeningToCombo = true;
    private Project currentProject;
    private ProjectConfigurationProvider pcp;
    private Lookup.Result<ProjectConfigurationProvider> currentResult;
    private Lookup lookup;

    public ActiveConfigAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.configListCombo = new JComboBox();
        this.configListCombo.setRenderer(new ConfigCellRenderer());
        this.configListCombo.setToolTipText(Actions.cutAmpersand((String)this.getName()));
        this.configurationsListChanged(null);
        this.configListCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ActiveConfigAction.this.listeningToCombo) {
                    return;
                }
                Object object = ActiveConfigAction.this.configListCombo.getSelectedItem();
                if (object == CUSTOMIZE_ENTRY) {
                    ActiveConfigAction.this.activeConfigurationChanged(ActiveConfigAction.this.pcp != null ? ActiveConfigAction.getActiveConfiguration(ActiveConfigAction.this.pcp) : null);
                    ActiveConfigAction.this.pcp.customize();
                } else if (object != null) {
                    ActiveConfigAction.this.activeConfigurationSelected((ProjectConfiguration)object, null);
                }
            }
        });
        this.lst = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("configurations".equals(propertyChangeEvent.getPropertyName())) {
                    ActiveConfigAction.this.configurationsListChanged(ActiveConfigAction.getConfigurations(ActiveConfigAction.this.pcp));
                } else if ("activeConfiguration".equals(propertyChangeEvent.getPropertyName())) {
                    ActiveConfigAction.this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(ActiveConfigAction.this.pcp));
                }
            }
        };
        this.activeProjectChanged(OpenProjectList.getDefault().getMainProject());
        OpenProjectList.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
                    ActiveConfigAction.this.activeProjectChanged(OpenProjectList.getDefault().getMainProject());
                }
            }
        });
        this.looklst = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ActiveConfigAction.this.activeProjectProviderChanged();
            }
        };
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.lookup = LookupSensitiveAction.LastActivatedWindowLookup.INSTANCE;
        Lookup.Result result = this.lookup.lookupResult(Project.class);
        Lookup.Result result2 = this.lookup.lookupResult(DataObject.class);
        result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)result));
        result2.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)result2));
        DynLayer.INSTANCE.setEnabled(true);
        this.refreshView(this.lookup);
    }

    private synchronized void configurationsListChanged(Collection<? extends ProjectConfiguration> collection) {
        LOGGER.log(Level.FINER, "configurationsListChanged: {0}", collection);
        if (collection == null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ActiveConfigAction.this.configListCombo.setModel(EMPTY_MODEL);
                    ActiveConfigAction.this.configListCombo.setEnabled(false);
                }
            });
        } else {
            final DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(collection.toArray());
            if (this.pcp.hasCustomizer()) {
                defaultComboBoxModel.addElement(CUSTOMIZE_ENTRY);
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ActiveConfigAction.this.configListCombo.setModel(defaultComboBoxModel);
                    ActiveConfigAction.this.configListCombo.setEnabled(true);
                }
            });
        }
        if (this.pcp != null) {
            this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(this.pcp));
        }
    }

    private synchronized void activeConfigurationChanged(final ProjectConfiguration projectConfiguration) {
        LOGGER.log(Level.FINER, "activeConfigurationChanged: {0}", projectConfiguration);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block4: {
                    ActiveConfigAction.this.listeningToCombo = false;
                    try {
                        ActiveConfigAction.this.configListCombo.setSelectedIndex(-1);
                        if (projectConfiguration == null) break block4;
                        ComboBoxModel comboBoxModel = ActiveConfigAction.this.configListCombo.getModel();
                        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                            if (!projectConfiguration.equals(comboBoxModel.getElementAt(i))) continue;
                            ActiveConfigAction.this.configListCombo.setSelectedIndex(i);
                            break;
                        }
                    }
                    finally {
                        ActiveConfigAction.this.listeningToCombo = true;
                    }
                }
            }
        });
    }

    private synchronized void activeConfigurationSelected(ProjectConfiguration projectConfiguration, ProjectConfigurationProvider projectConfigurationProvider) {
        ProjectConfigurationProvider projectConfigurationProvider2 = this.pcp;
        if (projectConfigurationProvider != null) {
            projectConfigurationProvider2 = projectConfigurationProvider;
        }
        LOGGER.log(Level.FINER, "activeConfigurationSelected: {0}", projectConfiguration);
        if (projectConfigurationProvider2 != null && projectConfiguration != null && !projectConfiguration.equals(ActiveConfigAction.getActiveConfiguration(projectConfigurationProvider2))) {
            try {
                ActiveConfigAction.setActiveConfiguration(projectConfigurationProvider2, projectConfiguration);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ActiveConfigAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.label");
    }

    public void performAction() {
        Toolkit.getDefaultToolkit().beep();
    }

    public Component getToolbarPresenter() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.setMaximumSize(new Dimension(150, 80));
        jPanel.setMinimumSize(new Dimension(150, 0));
        jPanel.setPreferredSize(new Dimension(150, 23));
        jPanel.add((Component)this.configListCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(1, 6, 1, 5), 0, 0));
        return jPanel;
    }

    public JMenuItem getMenuPresenter() {
        return new ConfigMenu(null);
    }

    private synchronized void activeProjectChanged(Project project) {
        LOGGER.log(Level.FINER, "activeProjectChanged: {0} -> {1}", new Object[]{this.currentProject, project});
        if (this.currentResult != null) {
            this.currentResult.removeLookupListener(this.looklst);
        }
        this.currentResult = null;
        if (this.currentProject != project) {
            if (this.pcp != null) {
                this.pcp.removePropertyChangeListener(this.lst);
            }
            this.currentProject = project;
            if (this.currentProject != null) {
                this.currentResult = this.currentProject.getLookup().lookupResult(ProjectConfigurationProvider.class);
                this.pcp = this.currentResult.allInstances().isEmpty() ? null : (ProjectConfigurationProvider)this.currentResult.allInstances().iterator().next();
                this.currentResult.addLookupListener(this.looklst);
                if (this.pcp != null) {
                    this.pcp.addPropertyChangeListener(this.lst);
                }
            } else {
                this.pcp = null;
            }
            this.configurationsListChanged(this.pcp == null ? null : ActiveConfigAction.getConfigurations(this.pcp));
        }
    }

    private synchronized void activeProjectProviderChanged() {
        if (this.currentResult != null) {
            Collection collection;
            if (this.pcp != null) {
                this.pcp.removePropertyChangeListener(this.lst);
            }
            ProjectConfigurationProvider projectConfigurationProvider = this.pcp = (collection = this.currentResult.allInstances()).isEmpty() ? null : (ProjectConfigurationProvider)collection.iterator().next();
            if (this.pcp != null) {
                this.pcp.addPropertyChangeListener(this.lst);
            }
            this.configurationsListChanged(this.pcp == null ? null : ActiveConfigAction.getConfigurations(this.pcp));
        }
    }

    public Action createContextAwareInstance(final Lookup lookup) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A
        extends AbstractAction
        implements Presenter.Popup {
            A() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                assert (false);
            }

            public JMenuItem getPopupPresenter() {
                return new ConfigMenu(lookup);
            }
        }
        return new A();
    }

    private static Collection<? extends ProjectConfiguration> getConfigurations(final ProjectConfigurationProvider<?> projectConfigurationProvider) {
        return (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectConfiguration>>(){

            public Collection<? extends ProjectConfiguration> run() {
                return projectConfigurationProvider.getConfigurations();
            }
        });
    }

    private static ProjectConfiguration getActiveConfiguration(final ProjectConfigurationProvider<?> projectConfigurationProvider) {
        return (ProjectConfiguration)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectConfiguration>(){

            public ProjectConfiguration run() {
                return projectConfigurationProvider.getActiveConfiguration();
            }
        });
    }

    private static void setActiveConfiguration(ProjectConfigurationProvider<?> projectConfigurationProvider, final ProjectConfiguration projectConfiguration) throws IOException {
        final ProjectConfigurationProvider<?> projectConfigurationProvider2 = projectConfigurationProvider;
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    projectConfigurationProvider2.setActiveConfiguration(projectConfiguration);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private void refreshView(Lookup lookup) {
        Project project = OpenProjectList.getDefault().getMainProject();
        Project project2 = null;
        if (project == null) {
            project2 = this.getProjectFromLookup(lookup);
        }
        if (project2 != null) {
            this.activeProjectChanged(project2);
        }
    }

    private Project getProjectFromLookup(Lookup lookup) {
        Project project = null;
        ArrayList<Project> arrayList = new ArrayList<Project>();
        if (lookup != null) {
            for (Project project2 : lookup.lookupAll(Project.class)) {
                arrayList.add(project2);
            }
        }
        if (arrayList.size() > 0) {
            project = (Project)arrayList.get(0);
        } else {
            for (Project project2 : lookup.lookupAll(DataObject.class)) {
                FileObject fileObject = project2.getPrimaryFile();
                project = FileOwnerQuery.getOwner((FileObject)fileObject);
            }
        }
        return project;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("MainProject") || propertyChangeEvent.getPropertyName().equals("OpenProjects")) {
            this.refreshView(this.lookup);
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refreshView(this.lookup);
    }

    private static class ConfigCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private Border defaultBorder = this.getBorder();

        public ConfigCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            String string = null;
            if (object instanceof ProjectConfiguration) {
                string = ((ProjectConfiguration)object).getDisplayName();
                this.setBorder(this.defaultBorder);
            } else if (object == CUSTOMIZE_ENTRY) {
                string = Actions.cutAmpersand((String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow")), this.defaultBorder));
            } else {
                assert (object == null);
                string = null;
                this.setBorder(this.defaultBorder);
            }
            this.setText(string);
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigMenu
    extends JMenu
    implements DynamicMenuContent,
    ActionListener {
        private final Lookup context;

        public ConfigMenu(Lookup lookup) {
            this.context = lookup;
            if (lookup != null) {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.context.label"));
            } else {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)ActiveConfigAction.this.getName());
            }
        }

        private ProjectConfigurationProvider<?> findPCP() {
            if (this.context != null) {
                Collection collection = this.context.lookupAll(Project.class);
                if (collection.size() == 1) {
                    return (ProjectConfigurationProvider)((Project)collection.iterator().next()).getLookup().lookup(ProjectConfigurationProvider.class);
                }
                return null;
            }
            return ActiveConfigAction.this.pcp;
        }

        public JComponent[] getMenuPresenters() {
            this.removeAll();
            ProjectConfigurationProvider<?> projectConfigurationProvider = this.findPCP();
            if (projectConfigurationProvider != null) {
                boolean bl = false;
                ProjectConfiguration projectConfiguration = ActiveConfigAction.getActiveConfiguration(projectConfigurationProvider);
                for (final ProjectConfiguration projectConfiguration2 : ActiveConfigAction.getConfigurations(projectConfigurationProvider)) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(projectConfiguration2.getDisplayName(), projectConfiguration2.equals(projectConfiguration));
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ActiveConfigAction.this.activeConfigurationSelected(projectConfiguration2, ConfigMenu.this.findPCP());
                        }
                    });
                    this.add(jRadioButtonMenuItem);
                    bl = true;
                }
                if (projectConfigurationProvider.hasCustomizer()) {
                    if (bl) {
                        this.addSeparator();
                    }
                    bl = true;
                    JMenuItem jMenuItem = new JMenuItem();
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                    jMenuItem.addActionListener(this);
                    this.add(jMenuItem);
                }
                this.setEnabled(bl);
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.getMenuPresenters();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProjectConfigurationProvider<?> projectConfigurationProvider = this.findPCP();
            if (projectConfigurationProvider != null) {
                projectConfigurationProvider.customize();
            }
        }
    }

    public static final class DynLayer
    extends MultiFileSystem {
        static DynLayer INSTANCE;
        private final FileSystem fragment;

        public DynLayer() {
            INSTANCE = this;
            this.fragment = FileUtil.createMemoryFileSystem();
            try {
                FileObject fileObject = FileUtil.createData((FileObject)this.fragment.getRoot(), (String)"Toolbars/Build/org-netbeans-modules-project-ui-actions-ActiveConfigAction.shadow");
                fileObject.setAttribute("originalFile", (Object)"Actions/Project/org-netbeans-modules-project-ui-actions-ActiveConfigAction.instance");
                fileObject.setAttribute("position", (Object)80);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        void setEnabled(boolean bl) {
            if (bl) {
                this.setDelegates(new FileSystem[]{this.fragment});
            } else {
                this.setDelegates(new FileSystem[0]);
            }
        }
    }
}

