/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.nodes;

import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnEndAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnGroupAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnStartAction;
import com.jaspersoft.ireport.components.table.nodes.TableSectionChildren;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TableSectionNode
extends IRIndexedNode {
    JasperDesign jd = null;
    private JRDesignComponentElement tableElement = null;
    private byte sectionType = 0;
    private JRDesignGroup group = null;
    private PropertyChangeListener groupNameListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TableSectionNode.this.updateDisplayName();
        }
    };

    public TableSectionNode(JasperDesign jd, JRDesignComponentElement tableElement, byte sectionType, JRDesignGroup group, Lookup doLkp) {
        this(new TableSectionChildren(jd, tableElement, sectionType, group, doLkp), jd, tableElement, sectionType, group, doLkp);
    }

    public TableSectionNode(TableSectionChildren pc, JasperDesign jd, JRDesignComponentElement tableElement, byte sectionType, JRDesignGroup group, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, tableElement})}));
        this.jd = jd;
        this.tableElement = tableElement;
        this.sectionType = sectionType;
        this.group = group;
        this.updateDisplayName();
        if (group != null) {
            group.getEventSupport().addPropertyChangeListener("name", this.groupNameListener);
        }
        this.setName("column");
    }

    public void updateDisplayName() {
        switch (this.sectionType) {
            case 0: {
                this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/table-headers.png");
                this.setDisplayName(I18n.getString((String)"TableHeaderNode.name"));
                break;
            }
            case 1: {
                this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/column-headers.png");
                this.setDisplayName(I18n.getString((String)"ColumnHeaderNode.name"));
                break;
            }
            case 2: {
                this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/group-headers.png");
                this.setDisplayName(I18n.getString((String)"GroupHeaderNode.name", (Object)this.group.getName()));
                break;
            }
            case 3: {
                this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/table-detail.png");
                this.setDisplayName(I18n.getString((String)"DetailNode.name"));
                break;
            }
            case 4: {
                this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/group-footers.png");
                this.setDisplayName(I18n.getString((String)"GroupFooterNode.name", (Object)this.group.getName()));
                break;
            }
            case 5: {
                this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/column-footers.png");
                this.setDisplayName(I18n.getString((String)"ColumnFooterNode.name"));
                break;
            }
            case 6: {
                this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/table-footers.png");
                this.setDisplayName(I18n.getString((String)"TableFooterNode.name"));
            }
        }
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public JRDesignComponentElement getComponentElement() {
        return this.tableElement;
    }

    public StandardTable getTable() {
        return (StandardTable)this.getComponentElement().getComponent();
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public byte getSectionType() {
        return this.sectionType;
    }

    public void setSectionType(byte sectionType) {
        this.sectionType = sectionType;
    }

    public PasteType getDropType(Transferable t, int action, final int index) {
        BaseColumn column;
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction((Transferable)t);
        if (null != dropNode && index >= 0 && null != (column = (BaseColumn)dropNode.getLookup().lookup(BaseColumn.class))) {
            final TableMatrix matrix = new TableMatrix(this.getJasperDesign(), this.getTable());
            if (matrix.getColumnIndex(column) < 0) {
                return null;
            }
            return new PasteType(){

                public Transferable paste() throws IOException {
                    matrix.moveColumn(column, TableSectionNode.this.getTable(), index);
                    return null;
                }
            };
        }
        return null;
    }

    public Action[] getActions(boolean popup) {
        ArrayList<SystemAction> list = new ArrayList<SystemAction>();
        list.add(SystemAction.get(AddTableColumnStartAction.class));
        list.add(SystemAction.get(AddTableColumnEndAction.class));
        list.add(SystemAction.get(AddTableColumnGroupAction.class));
        return list.toArray(new Action[list.size()]);
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public JRDesignGroup getGroup() {
        return this.group;
    }

    public void setGroup(JRDesignGroup group) {
        this.group = group;
    }
}

