/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.barcode.barbecue;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import org.openide.nodes.PropertySupport;

public final class BarbecueTypeProperty
extends PropertySupport {
    private StandardBarbecueComponent component;
    private ComboBoxPropertyEditor editor;
    private static String[] providerNames = new String[]{"2of7", "3of9", "Bookland", "Codabar", "Code128", "Code128A", "Code128B", "Code128C", "Code39", "Code39 (Extended)", "EAN128", "EAN13", "GlobalTradeItemNumber", "Int2of5", "Monarch", "NW7", "PDF417", "PostNet", "RandomWeightUPCA", "SCC14ShippingCode", "ShipmentIdentificationNumber", "SSCC18", "Std2of5", "UCC128", "UPCA", "USD3", "USD4", "USPS"};

    public BarbecueTypeProperty(StandardBarbecueComponent component) {
        super("type", String.class, I18n.getString((String)"barbecue.property.type.name"), I18n.getString((String)"barbecue.property.type.description"), true, true);
        this.component = component;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new ComboBoxPropertyEditor(false, (List)this.getListOfTags());
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.component.getType();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val != null && val instanceof String) {
            String oldValue = this.component.getType();
            String newValue = (String)val;
            this.component.setType(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit((Object)this.component, "Type", String.class, (Object)oldValue, (Object)newValue);
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)urob);
        }
    }

    private ArrayList getListOfTags() {
        Arrays.sort(providerNames);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int i = 0; i < providerNames.length; ++i) {
            tags.add(new Tag((Object)providerNames[i], providerNames[i]));
        }
        return tags;
    }
}

