/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.deprecated.pre61settings;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.Lookup;

public final class KitchenSink {
    private static final Logger LOG = Logger.getLogger(KitchenSink.class.getName());
    public static final String JAVATYPE_KEY_PREFIX = "nbeditor-javaType-for-legacy-setting_";

    public static Object getValueFromPrefs(String string, Preferences preferences, MimePath mimePath) {
        Object object = null;
        if (preferences != null && null != preferences.get(string, null)) {
            Class clazz = null;
            String string2 = preferences.get(JAVATYPE_KEY_PREFIX + string, null);
            if (string2 != null) {
                clazz = KitchenSink.typeFromString(string2);
            }
            if (clazz != null) {
                if (clazz.equals(SettingsConversions.class)) {
                    object = SettingsConversions.callFactory((Preferences)preferences, (MimePath)mimePath, (String)string, null);
                } else if (clazz.equals(Boolean.class)) {
                    object = preferences.getBoolean(string, false);
                } else if (clazz.equals(Integer.class)) {
                    object = preferences.getInt(string, 0);
                } else if (clazz.equals(Long.class)) {
                    object = preferences.getLong(string, 0L);
                } else if (clazz.equals(Float.class)) {
                    object = Float.valueOf(preferences.getFloat(string, 0.0f));
                } else if (clazz.equals(Double.class)) {
                    object = preferences.getDouble(string, 0.0);
                } else if (clazz.equals(Insets.class)) {
                    object = SettingsConversions.parseInsets((String)preferences.get(string, null));
                } else if (clazz.equals(Dimension.class)) {
                    object = SettingsConversions.parseDimension((String)preferences.get(string, null));
                } else if (clazz.equals(Color.class)) {
                    object = SettingsConversions.parseColor((String)preferences.get(string, null));
                } else if (clazz.equals(String.class)) {
                    object = preferences.get(string, null);
                } else {
                    LOG.log(Level.WARNING, "Can't load setting '" + string + "' with value '" + preferences.get(string, null) + "' through org.netbeans.editor.Settings! Unsupported value conversion to " + clazz, new Throwable("Stacktrace"));
                }
            } else {
                LOG.warning("Can't determine type of '" + string + "' editor setting. If you supplied this setting" + " through the editor implementation of java.util.prefs.Preferences you should use the 'javaType'" + " attribute and specify the class representing values of this setting. There seem to be legacy" + " clients accessing your setting through the old org.netbeans.editor.Settings.");
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean setValueToPreferences(String string, Object object, Preferences preferences, MimePath mimePath) {
        if (object == null) {
            preferences.remove(string);
            return true;
        }
        if (object instanceof Boolean) {
            preferences.putBoolean(string, (Boolean)object);
            return true;
        }
        if (object instanceof Integer) {
            preferences.putInt(string, (Integer)object);
            return true;
        }
        if (object instanceof Long) {
            preferences.putLong(string, (Long)object);
            return true;
        }
        if (object instanceof Float) {
            preferences.putFloat(string, ((Float)object).floatValue());
            return true;
        }
        if (object instanceof Double) {
            preferences.putDouble(string, (Double)object);
            return true;
        }
        if (object instanceof Insets) {
            preferences.put(string, SettingsConversions.insetsToString((Insets)((Insets)object)));
            preferences.put(JAVATYPE_KEY_PREFIX + string, Insets.class.getName());
            return true;
        }
        if (object instanceof Dimension) {
            preferences.put(string, SettingsConversions.dimensionToString((Dimension)((Dimension)object)));
            preferences.put(JAVATYPE_KEY_PREFIX + string, Dimension.class.getName());
            return true;
        }
        if (object instanceof Color) {
            preferences.put(string, SettingsConversions.color2String((Color)((Color)object)));
            preferences.put(JAVATYPE_KEY_PREFIX + string, Color.class.getName());
            return true;
        }
        if (object instanceof String) {
            preferences.put(string, (String)object);
            return true;
        }
        LOG.log(Level.FINE, "Can't save setting '" + string + "' with value '" + object + "' through org.netbeans.editor.Settings; unsupported value conversion!", new Throwable("Stacktrace"));
        return false;
    }

    private static Class typeFromString(String string) {
        if ("methodvalue".equals(string)) {
            return SettingsConversions.class;
        }
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            return classLoader == null ? null : classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.WARNING, null, classNotFoundException);
            return null;
        }
    }

    public static final Object getIndentEngineValue(MimePath mimePath, String string) {
        assert (string.equals("indentEngine")) : "The getIndentEngineValue factory called for '" + string + "'";
        BaseOptions baseOptions = (BaseOptions)((Object)MimeLookup.getLookup((MimePath)mimePath).lookup(BaseOptions.class));
        return baseOptions != null ? baseOptions.getIndentEngine() : null;
    }
}

