/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPDoubleInfo;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPFloatInfo;
import org.netbeans.modules.classfile.CPIntegerInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPLongInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.CPNameAndTypeInfo;
import org.netbeans.modules.classfile.CPStringInfo;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPoolReader;
import org.netbeans.modules.classfile.InvalidClassFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstantPool {
    private static final int CONSTANT_POOL_START = 1;
    static final int CONSTANT_Utf8 = 1;
    static final int CONSTANT_Integer = 3;
    static final int CONSTANT_Float = 4;
    static final int CONSTANT_Long = 5;
    static final int CONSTANT_Double = 6;
    static final int CONSTANT_Class = 7;
    static final int CONSTANT_String = 8;
    static final int CONSTANT_FieldRef = 9;
    static final int CONSTANT_MethodRef = 10;
    static final int CONSTANT_InterfaceMethodRef = 11;
    static final int CONSTANT_NameAndType = 12;
    CPEntry[] cpEntries;
    int constantPoolCount = 0;

    ConstantPool(int n, InputStream inputStream) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("byte stream not specified");
        }
        this.constantPoolCount = n;
        this.cpEntries = new CPEntry[this.constantPoolCount];
        this.load(inputStream);
    }

    ConstantPool() {
        this.constantPoolCount = 1;
        this.cpEntries = new CPEntry[this.constantPoolCount];
    }

    public final CPEntry get(int n) {
        if (n <= 0 || n >= this.cpEntries.length) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return this.cpEntries[n];
    }

    public final CPClassInfo getClass(int n) {
        if (n <= 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return (CPClassInfo)this.get(n);
    }

    public final Collection getAllConstants(Class clazz) {
        return Collections.unmodifiableCollection(this.getAllConstantsImpl(clazz));
    }

    private Collection<CPEntry> getAllConstantsImpl(Class clazz) {
        int n = this.cpEntries.length;
        ArrayList<CPEntry> arrayList = new ArrayList<CPEntry>(n);
        for (int i = 1; i < n; ++i) {
            if (this.cpEntries[i] == null || !this.cpEntries[i].getClass().equals(clazz)) continue;
            arrayList.add(this.cpEntries[i]);
        }
        return arrayList;
    }

    public final Set getAllClassNames() {
        HashSet<ClassName> hashSet = new HashSet<ClassName>();
        Collection<CPEntry> collection = this.getAllConstantsImpl(CPClassInfo.class);
        for (CPClassInfo cPClassInfo : collection) {
            hashSet.add(cPClassInfo.getClassName());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    final String getString(int n) {
        CPUTF8Info cPUTF8Info = (CPUTF8Info)this.cpEntries[n];
        return cPUTF8Info.getName();
    }

    private void load(InputStream inputStream) throws IOException {
        try {
            CPEntry cPEntry;
            int n;
            ConstantPoolReader constantPoolReader = new ConstantPoolReader(inputStream);
            for (n = 1; n < this.constantPoolCount; ++n) {
                this.cpEntries[n] = cPEntry = this.getConstantPoolEntry(constantPoolReader);
                if (!cPEntry.usesTwoSlots()) continue;
                ++n;
            }
            for (n = 1; n < this.constantPoolCount; ++n) {
                cPEntry = this.cpEntries[n];
                if (cPEntry == null) continue;
                cPEntry.resolve(this.cpEntries);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassFormatException(illegalArgumentException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidClassFormatException(indexOutOfBoundsException);
        }
    }

    private CPEntry getConstantPoolEntry(ConstantPoolReader constantPoolReader) throws IOException {
        CPEntry cPEntry;
        byte by = constantPoolReader.readByte();
        switch (by) {
            case 1: {
                cPEntry = new CPUTF8Info(this, constantPoolReader.readRawUTF());
                break;
            }
            case 3: {
                cPEntry = new CPIntegerInfo(this, constantPoolReader.readInt());
                break;
            }
            case 4: {
                cPEntry = new CPFloatInfo(this, constantPoolReader.readFloat());
                break;
            }
            case 5: {
                cPEntry = new CPLongInfo(this, constantPoolReader.readLong());
                break;
            }
            case 6: {
                cPEntry = new CPDoubleInfo(this, constantPoolReader.readDouble());
                break;
            }
            case 7: {
                int n = constantPoolReader.readUnsignedShort();
                cPEntry = new CPClassInfo(this, n);
                break;
            }
            case 8: {
                int n = constantPoolReader.readUnsignedShort();
                cPEntry = new CPStringInfo(this, n);
                break;
            }
            case 9: {
                int n = constantPoolReader.readUnsignedShort();
                int n2 = constantPoolReader.readUnsignedShort();
                cPEntry = new CPFieldInfo(this, n, n2);
                break;
            }
            case 10: {
                int n = constantPoolReader.readUnsignedShort();
                int n3 = constantPoolReader.readUnsignedShort();
                cPEntry = new CPMethodInfo(this, n, n3);
                break;
            }
            case 11: {
                int n = constantPoolReader.readUnsignedShort();
                int n4 = constantPoolReader.readUnsignedShort();
                cPEntry = new CPInterfaceMethodInfo(this, n, n4);
                break;
            }
            case 12: {
                int n = constantPoolReader.readUnsignedShort();
                int n5 = constantPoolReader.readUnsignedShort();
                cPEntry = new CPNameAndTypeInfo(this, n, n5);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid constant pool type: " + by);
            }
        }
        return cPEntry;
    }
}

