/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import mondrian.util.OnceTimeSchedule;
import mondrian.util.Schedule;
import mondrian.util.ScheduleUtil;

public class ScheduleTest
extends TestCase {
    public static final Time time0827 = ScheduleUtil.createTime(8, 27, 0);
    public static final Time time1600 = ScheduleUtil.createTime(16, 0, 0);
    public static final Time time0000 = ScheduleUtil.createTime(0, 0, 0);
    public static final Time time0233 = ScheduleUtil.createTime(2, 33, 0);
    public static final TimeZone gmtTz = TimeZone.getTimeZone("GMT");
    public static final TimeZone pstTz = TimeZone.getTimeZone("America/Los_Angeles");
    public static final TimeZone jstTz = TimeZone.getTimeZone("Asia/Tokyo");
    public static final TimeZone sgtTz = TimeZone.getTimeZone("Asia/Singapore");
    public static final int weekdays = 124;
    private static final String[] daysOfWeek = new String[]{null, "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    public ScheduleTest(String name) {
        super(name);
    }

    static void assertEquals(Calendar c1, Calendar c2) {
        if (c1 == null || c2 == null) {
            ScheduleTest.assertEquals((Object)c1, (Object)c2);
        } else {
            ScheduleTest.assertEquals((Object)c1.getTimeZone(), (Object)c2.getTimeZone());
            ScheduleTest.assertEquals((Object)c1.getTime(), (Object)c2.getTime());
        }
    }

    static void assertEquals(Date expected, Calendar actual) {
        if (expected == null || actual == null) {
            ScheduleTest.assertEquals((Object)expected, (Object)actual);
        } else {
            ScheduleTest.assertEquals((Object)expected, (Object)actual.getTime());
        }
    }

    static void assertEquals(int year, int month, int day, String dow, int hour, int minute, Date actual) {
        ScheduleTest.assertEquals((Object)ScheduleTest.toDate(year, month, day, dow, hour, minute), (Object)actual);
    }

    static void assertEquals(Calendar expected, Date actual) {
        if (expected == null || actual == null) {
            ScheduleTest.assertEquals((Object)expected, (Object)actual);
        } else {
            ScheduleTest.assertEquals((Object)expected.getTime(), (Object)actual);
        }
    }

    static void assertScheduleCount(Schedule schedule, Date d, Date last, int expectedCount) {
        Date next;
        int count = 0;
        while ((next = schedule.nextOccurrence(d, true)) != null) {
            d = next;
            if (++count <= 100) continue;
            break;
        }
        ScheduleTest.assertEquals((Object)last, (Object)d);
        ScheduleTest.assertEquals((String)"schedule count", (int)expectedCount, (int)count);
    }

    static Date toDate(int year, int month, int day, String dow, int hour, int minute) {
        return ScheduleTest.toDate(year, month, day, dow, hour, minute, gmtTz);
    }

    static Date toDate(int year, int month, int day, String dow, int hour, int minute, TimeZone tz) {
        Calendar calendar = ScheduleUtil.createCalendar(year, month, day, hour, minute, 0);
        calendar.setTimeZone(tz);
        ScheduleTest.assertEquals((String)daysOfWeek[calendar.get(7)], (String)dow);
        return calendar.getTime();
    }

    public void testOnceTimeSchedule() {
        Calendar calendar0827 = ScheduleUtil.createCalendar(time0827);
        OnceTimeSchedule onceTimeSchedule = new OnceTimeSchedule(calendar0827);
        Calendar t = onceTimeSchedule.nextOccurrence(null, true);
        ScheduleTest.assertEquals(calendar0827, t);
        Calendar calendar1600 = ScheduleUtil.createCalendar(time1600);
        t = onceTimeSchedule.nextOccurrence(calendar1600, true);
        ScheduleTest.assertEquals((Calendar)null, t);
        t = onceTimeSchedule.nextOccurrence(calendar0827, true);
        ScheduleTest.assertEquals((Calendar)null, t);
        t = onceTimeSchedule.nextOccurrence(calendar0827, false);
        ScheduleTest.assertEquals(calendar0827, t);
        Calendar calendar0000 = ScheduleUtil.createCalendar(time0000);
        t = onceTimeSchedule.nextOccurrence(calendar0000, false);
        ScheduleTest.assertEquals(calendar0827, t);
    }

    public void testOnce() {
        Schedule schedule = Schedule.createOnce(ScheduleTest.toDate(2002, 4, 23, "Tue", 8, 27), gmtTz);
        Date d = schedule.nextOccurrence(null, false);
        ScheduleTest.assertEquals(2002, 4, 23, "Tue", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 23, "Tue", 8, 27), false);
        ScheduleTest.assertEquals(2002, 4, 23, "Tue", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 23, "Tue", 8, 27), true);
        ScheduleTest.assertEquals(null, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 6, 3, "Mon", 16, 0), false);
        ScheduleTest.assertEquals(null, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 20, "Sat", 23, 0), true);
        ScheduleTest.assertEquals(2002, 4, 23, "Tue", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 20, "Sat", 23, 0), false);
        ScheduleTest.assertEquals(2002, 4, 23, "Tue", 8, 27, d);
    }

    public void testDaily() {
        int period = 1;
        Schedule schedule = Schedule.createDaily(ScheduleTest.toDate(2002, 4, 20, "Sat", 8, 27), ScheduleTest.toDate(2002, 6, 3, "Mon", 8, 27), gmtTz, time0827, period);
        Date d = schedule.nextOccurrence(null, false);
        ScheduleTest.assertEquals(2002, 4, 20, "Sat", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 20, "Sat", 8, 27), false);
        ScheduleTest.assertEquals(2002, 4, 20, "Sat", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 20, "Sat", 23, 0), false);
        ScheduleTest.assertEquals(2002, 4, 21, "Sun", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 6, 3, "Mon", 8, 27), false);
        ScheduleTest.assertEquals(null, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 6, 3, "Mon", 16, 0), false);
        ScheduleTest.assertEquals(null, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 6, 4, "Tue", 8, 27), false);
        ScheduleTest.assertEquals(null, d);
    }

    public void testDailyNoUpperLimit() {
        int period = 1;
        Schedule schedule = Schedule.createDaily(ScheduleTest.toDate(2002, 4, 20, "Sat", 8, 27), null, gmtTz, time0827, period);
        Date d = schedule.nextOccurrence(null, false);
        ScheduleTest.assertEquals(2002, 4, 20, "Sat", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 6, 3, "Mon", 16, 0), false);
        ScheduleTest.assertEquals(2002, 6, 4, "Tue", 8, 27, d);
    }

    public void testDailyPeriodic() {
        int period = 10;
        Schedule schedule = Schedule.createDaily(ScheduleTest.toDate(2002, 4, 20, "Sat", 8, 27), ScheduleTest.toDate(2002, 6, 3, "Mon", 8, 27), gmtTz, time0827, period);
        Date d = schedule.nextOccurrence(null, false);
        ScheduleTest.assertEquals(2002, 4, 20, "Sat", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 20, "Sat", 8, 27), true);
        ScheduleTest.assertEquals(2002, 4, 30, "Tue", 8, 27, d);
    }

    public void testWeeklyEmptyBitmapFails() {
        boolean failed = false;
        try {
            Schedule.createWeekly(null, null, gmtTz, time0827, 1, 0);
        }
        catch (Throwable e) {
            failed = true;
        }
        ScheduleTest.assertTrue((boolean)failed);
    }

    public void testWeeklyBadBitmapFails() {
        boolean failed = false;
        try {
            int period = 1;
            Schedule.createWeekly(null, null, gmtTz, time0827, period, 256);
        }
        catch (Throwable e) {
            failed = true;
        }
        ScheduleTest.assertTrue((boolean)failed);
    }

    public void testWeekly() {
        int thuesday = 40;
        int period = 1;
        Schedule schedule = Schedule.createWeekly(ScheduleTest.toDate(2002, 4, 20, "Sat", 8, 27), ScheduleTest.toDate(2002, 6, 5, "Wed", 12, 0), gmtTz, time0827, period, thuesday);
        Date d = schedule.nextOccurrence(null, false);
        ScheduleTest.assertEquals(2002, 4, 23, "Tue", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 23, "Tue", 8, 27), false);
        ScheduleTest.assertEquals(2002, 4, 23, "Tue", 8, 27, d);
        ScheduleTest.assertScheduleCount(schedule, d, ScheduleTest.toDate(2002, 6, 4, "Tue", 8, 27), 12);
    }

    public void testMonthlyByDay() {
        int period = 1;
        int daysOfMonth = 0x201001;
        Schedule schedule = Schedule.createMonthlyByDay(ScheduleTest.toDate(2002, 4, 20, "Sat", 8, 27), ScheduleTest.toDate(2002, 7, 10, "Wed", 12, 0), gmtTz, time0827, period, daysOfMonth);
        Date d = schedule.nextOccurrence(null, false);
        ScheduleTest.assertEquals(2002, 4, 21, "Sun", 8, 27, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 4, 30, "Tue", 8, 27, d);
        d = schedule.nextOccurrence(d, false);
        ScheduleTest.assertEquals(2002, 4, 30, "Tue", 8, 27, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 5, 12, "Sun", 8, 27, d);
        d = schedule.nextOccurrence(d, false);
        ScheduleTest.assertEquals(2002, 5, 12, "Sun", 8, 27, d);
        ScheduleTest.assertScheduleCount(schedule, d, ScheduleTest.toDate(2002, 6, 30, "Sun", 8, 27), 5);
    }

    public void testMonthlyByDayPeriodic() {
        int daysOfMonth = 0x201001;
        int period = 2;
        Schedule schedule = Schedule.createMonthlyByDay(ScheduleTest.toDate(2002, 4, 30, "Tue", 8, 27), ScheduleTest.toDate(2002, 7, 10, "Wed", 12, 0), gmtTz, time0827, period, daysOfMonth);
        Date d = schedule.nextOccurrence(null, true);
        ScheduleTest.assertEquals(2002, 4, 30, "Tue", 8, 27, d);
        d = schedule.nextOccurrence(d, false);
        ScheduleTest.assertEquals(2002, 4, 30, "Tue", 8, 27, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 6, 12, "Wed", 8, 27, d);
        d = schedule.nextOccurrence(d, false);
        ScheduleTest.assertEquals(2002, 6, 12, "Wed", 8, 27, d);
        ScheduleTest.assertScheduleCount(schedule, d, ScheduleTest.toDate(2002, 6, 30, "Sun", 8, 27), 2);
    }

    public void testMonthlyByWeek() {
        int period = 3;
        int daysOfWeek = 34;
        int weeksOfMonth = 5;
        Schedule schedule = Schedule.createMonthlyByWeek(ScheduleTest.toDate(2002, 4, 20, "Sat", 8, 27), ScheduleTest.toDate(2004, 4, 19, "Mon", 12, 0), gmtTz, time0827, period, daysOfWeek, weeksOfMonth);
        Date d = schedule.nextOccurrence(null, false);
        ScheduleTest.assertEquals(2002, 4, 25, "Thu", 8, 27, d);
        d = schedule.nextOccurrence(ScheduleTest.toDate(2002, 4, 23, "Tue", 8, 27), false);
        ScheduleTest.assertEquals(2002, 4, 25, "Thu", 8, 27, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 4, 28, "Sun", 8, 27, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 7, 11, "Thu", 8, 27, d);
        ScheduleTest.assertScheduleCount(schedule, d, ScheduleTest.toDate(2004, 4, 11, "Sun", 8, 27), 29);
    }

    public void testTimeZone() {
        int period = 1;
        int daysOfWeek = 32;
        int weeksOfMonth = 1;
        Schedule schedule = Schedule.createMonthlyByWeek(ScheduleTest.toDate(2002, 3, 7, "Thu", 14, 0), ScheduleTest.toDate(2004, 4, 19, "Mon", 12, 0), jstTz, time0827, period, daysOfWeek, weeksOfMonth);
        Date d = schedule.nextOccurrence(null, true);
        ScheduleTest.assertEquals(2002, 3, 27, "Wed", 23, 27, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 4, 24, "Wed", 23, 27, d);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 7, 24, "Wed", 23, 27, d);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 10, 30, "Wed", 23, 27, d);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2003, 12, 24, "Wed", 23, 27, d);
    }

    public void testTimeZoneChange() {
        int period = 1;
        TimeZone tz = pstTz;
        Schedule schedule = Schedule.createDaily(ScheduleTest.toDate(2002, 4, 3, "Wed", 8, 27, tz), null, tz, time0233, period);
        Date d = schedule.nextOccurrence(null, false);
        ScheduleTest.assertEquals((Object)ScheduleTest.toDate(2002, 4, 4, "Thu", 2, 33, tz), (Object)d);
        d = schedule.nextOccurrence(d, true);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 4, 6, "Sat", 10, 33, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 4, 7, "Sun", 9, 33, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 4, 8, "Mon", 9, 33, d);
        for (int i = 5; i < 206; ++i) {
            d = schedule.nextOccurrence(d, true);
        }
        ScheduleTest.assertEquals(2002, 10, 26, "Sat", 9, 33, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals((Object)ScheduleTest.toDate(2002, 10, 27, "Sun", 2, 33, tz), (Object)d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 10, 28, "Mon", 10, 33, d);
        d = schedule.nextOccurrence(d, true);
        ScheduleTest.assertEquals(2002, 10, 29, "Tue", 10, 33, d);
    }
}

