/*
 * Decompiled with CFR 0.152.
 */
package mondrian.udf;

import mondrian.olap.Evaluator;
import mondrian.olap.Syntax;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.Type;
import mondrian.spi.UserDefinedFunction;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.DistributionFactory;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.log4j.Logger;

public class InverseNormalUdf
implements UserDefinedFunction {
    private static final Logger LOGGER = Logger.getLogger(InverseNormalUdf.class);
    private static DistributionFactory distributionFactory = DistributionFactory.newInstance();
    private static NormalDistribution nd = distributionFactory.createNormalDistribution();

    public String getName() {
        return "InverseNormal";
    }

    public String getDescription() {
        return "Returns inverse normal distribution of its argument";
    }

    public Syntax getSyntax() {
        return Syntax.Function;
    }

    public Type getReturnType(Type[] types) {
        return new NumericType();
    }

    public Type[] getParameterTypes() {
        return new Type[]{new NumericType()};
    }

    public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] args) {
        Object argValue = args[0].evaluateScalar(evaluator);
        LOGGER.debug((Object)("Inverse Normal argument was : " + argValue));
        if (!(argValue instanceof Number)) {
            return null;
        }
        Double d = new Double(((Number)argValue).doubleValue());
        LOGGER.debug((Object)("Inverse Normal argument as Double was : " + d));
        if (d.isNaN()) {
            return null;
        }
        double dbl = d;
        if (dbl < 0.0 || dbl > 1.0) {
            LOGGER.debug((Object)("Invalid value for inverse normal distribution: " + dbl));
            throw new MondrianEvaluationException("Invalid value for inverse normal distribution: " + dbl);
        }
        try {
            Double result = new Double(nd.inverseCumulativeProbability(dbl));
            LOGGER.debug((Object)("Inverse Normal result : " + result));
            return result;
        }
        catch (MathException e) {
            LOGGER.debug((Object)("Exception calculating inverse normal distribution: " + dbl), (Throwable)e);
            throw new MondrianEvaluationException("Exception calculating inverse normal distribution: " + dbl);
        }
    }

    public String[] getReservedWords() {
        return null;
    }
}

