/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.DenseSegmentDataset;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SparseSegmentDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentLoader {
    public void load(List<GroupingSet> groupingSets, RolapAggregationManager.PinSet pinnedSegments, List<StarPredicate> compoundPredicateList) {
        GroupingSetsList groupingSetsList = new GroupingSetsList(groupingSets);
        boolean useGroupingSet = groupingSetsList.useGroupingSets();
        RolapStar.Column[] defaultColumns = groupingSetsList.getDefaultColumns();
        SqlStatement stmt = null;
        try {
            stmt = this.createExecuteSql(groupingSetsList, compoundPredicateList);
            int arity = defaultColumns.length;
            SortedSet<Comparable<?>>[] axisValueSets = this.getDistinctValueWorkspace(arity);
            boolean[] axisContainsNull = new boolean[arity];
            List<Object[]> rows = this.processData(stmt, axisContainsNull, axisValueSets, groupingSetsList);
            boolean sparse = this.setAxisDataAndDecideSparseUse(axisValueSets, axisContainsNull, groupingSetsList, rows);
            SegmentDataset[] nonGroupingDataSets = null;
            HashMap<BitKey, SegmentDataset[]> groupingDataSetsMap = new HashMap<BitKey, SegmentDataset[]>();
            if (useGroupingSet) {
                this.populateDataSetMapOnGroupingColumnsBitKeys(groupingSetsList, sparse, groupingDataSetsMap);
            } else {
                nonGroupingDataSets = this.createDataSets(sparse, groupingSetsList.getDefaultSegments(), groupingSetsList.getDefaultAxes());
            }
            this.loadDataToDataSets(groupingSetsList, rows, groupingDataSetsMap, nonGroupingDataSets, axisContainsNull, sparse);
            this.setDataToSegments(groupingSetsList, nonGroupingDataSets, groupingDataSetsMap, pinnedSegments);
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.setFailOnStillLoadingSegments(groupingSetsList);
        }
    }

    void setFailOnStillLoadingSegments(GroupingSetsList groupingSetsList) {
        for (GroupingSet groupingset : groupingSetsList.getGroupingSets()) {
            for (Segment segment : groupingset.getSegments()) {
                segment.setFailIfStillLoading();
            }
        }
    }

    private void loadDataToDataSets(GroupingSetsList groupingSetsList, List<Object[]> rows, Map<BitKey, SegmentDataset[]> groupingDataSetMap, SegmentDataset[] nonGroupingDataSets, boolean[] axisContainsNull, boolean sparse) {
        int arity = groupingSetsList.getDefaultColumns().length;
        boolean useGroupingSet = groupingSetsList.useGroupingSets();
        Aggregation.Axis[] axes = groupingSetsList.getDefaultAxes();
        int segmentLength = groupingSetsList.getDefaultSegments().length;
        ArrayList<Integer> pos = new ArrayList<Integer>(arity);
        for (Object[] row : rows) {
            Object o;
            int j;
            SegmentDataset[] datasets;
            int groupingBitKeyIndex = arity + segmentLength;
            if (useGroupingSet) {
                BitKey groupingBitKey = (BitKey)row[groupingBitKeyIndex];
                datasets = groupingDataSetMap.get(groupingBitKey);
            } else {
                datasets = nonGroupingDataSets;
            }
            int k = 0;
            for (j = 0; j < arity; ++j) {
                o = row[j];
                if (useGroupingSet && this.isRollupNull(groupingSetsList, row, groupingBitKeyIndex, j)) continue;
                Aggregation.Axis axis = axes[j];
                int offset = axis.getOffset(o);
                pos.add(offset);
                k *= axes[j].getKeys().length;
                k += offset;
            }
            if (sparse) {
                CellKey key = CellKey.Generator.newCellKey(this.toArray(pos));
                for (int j2 = 0; j2 < segmentLength; ++j2) {
                    Object o2 = row[arity + j2];
                    datasets[j2].put(key, o2);
                }
            } else {
                for (j = 0; j < segmentLength; ++j) {
                    o = row[arity + j];
                    ((DenseSegmentDataset)datasets[j]).set(k, o);
                }
            }
            pos.clear();
        }
    }

    private boolean isRollupNull(GroupingSetsList groupingSetsList, Object[] row, int groupingBitKeyIndex, int j) {
        BitKey groupingBitKey = (BitKey)row[groupingBitKeyIndex];
        boolean isGroupingBitSet = groupingBitKey.get(groupingSetsList.findGroupingFunctionIndex(j));
        return row[j].equals(RolapUtil.sqlNullValue) && isGroupingBitSet;
    }

    private int[] toArray(List<Integer> pos) {
        int[] posArr = new int[pos.size()];
        for (int i = 0; i < posArr.length; ++i) {
            posArr[i] = pos.get(i);
        }
        return posArr;
    }

    private boolean setAxisDataAndDecideSparseUse(SortedSet<Comparable<?>>[] axisValueSets, boolean[] axisContainsNull, GroupingSetsList groupingSetsList, List<Object[]> rows) {
        Aggregation.Axis[] axes = groupingSetsList.getDefaultAxes();
        RolapStar.Column[] allColumns = groupingSetsList.getDefaultColumns();
        boolean sparse = false;
        int n = 1;
        for (int i = 0; i < axes.length; ++i) {
            Aggregation.Axis axis = axes[i];
            SortedSet<Comparable<?>> valueSet = axisValueSets[i];
            int size = axis.loadKeys(valueSet, axisContainsNull[i]);
            this.setAxisDataToGroupableList(groupingSetsList, valueSet, axisContainsNull[i], allColumns[i]);
            int previous = n;
            if ((n *= size) >= previous && n >= size) continue;
            n = Integer.MAX_VALUE;
            sparse = true;
        }
        return this.useSparse(sparse, n, rows);
    }

    boolean useSparse(boolean sparse, int n, List<Object[]> rows) {
        sparse = sparse || SegmentLoader.useSparse(n, rows.size());
        return sparse;
    }

    private void setDataToSegments(GroupingSetsList groupingSetsList, SegmentDataset[] detailedDataSet, Map<BitKey, SegmentDataset[]> datasetsMap, RolapAggregationManager.PinSet pinnedSegments) {
        List<GroupingSet> groupingSets = groupingSetsList.getGroupingSets();
        boolean useGroupingSet = groupingSetsList.useGroupingSets();
        for (int i = 0; i < groupingSets.size(); ++i) {
            Segment[] groupedSegments = groupingSets.get(i).getSegments();
            SegmentDataset[] dataSets = useGroupingSet ? datasetsMap.get(groupingSetsList.getRollupColumnsBitKeyList().get(i)) : detailedDataSet;
            for (int j = 0; j < groupedSegments.length; ++j) {
                Segment groupedSegment = groupedSegments[j];
                groupedSegment.setData(dataSets[j], pinnedSegments);
            }
        }
    }

    private void populateDataSetMapOnGroupingColumnsBitKeys(GroupingSetsList groupingSetsList, boolean sparse, Map<BitKey, SegmentDataset[]> datasetsMap) {
        List<GroupingSet> groupingSets = groupingSetsList.getGroupingSets();
        List<BitKey> groupingColumnsBitKeyList = groupingSetsList.getRollupColumnsBitKeyList();
        for (int i = 0; i < groupingSets.size(); ++i) {
            GroupingSet groupingSet = groupingSets.get(i);
            SegmentDataset[] datasets = this.createDataSets(sparse, groupingSet.getSegments(), groupingSet.getAxes());
            datasetsMap.put(groupingColumnsBitKeyList.get(i), datasets);
        }
    }

    private int calcuateMaxDataSize(Aggregation.Axis[] axes) {
        int n = 1;
        for (Aggregation.Axis axis : axes) {
            n *= axis.getKeys().length;
        }
        return n;
    }

    private SegmentDataset[] createDataSets(boolean sparse, Segment[] segments, Aggregation.Axis[] axes) {
        SegmentDataset[] datasets;
        int n;
        int n2 = n = sparse ? 0 : this.calcuateMaxDataSize(axes);
        if (sparse) {
            datasets = new SparseSegmentDataset[segments.length];
            for (int i = 0; i < segments.length; ++i) {
                datasets[i] = new SparseSegmentDataset(segments[i]);
            }
        } else {
            datasets = new DenseSegmentDataset[segments.length];
            for (int i = 0; i < segments.length; ++i) {
                datasets[i] = new DenseSegmentDataset(segments[i], new Object[n]);
            }
        }
        return datasets;
    }

    private void setAxisDataToGroupableList(GroupingSetsList groupingSetsList, SortedSet<Comparable<?>> valueSet, boolean axisContainsNull, RolapStar.Column column) {
        for (GroupingSet groupingSet : groupingSetsList.getRollupGroupingSets()) {
            RolapStar.Column[] columns = groupingSet.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].equals(column)) continue;
                groupingSet.getAxes()[i].loadKeys(valueSet, axisContainsNull);
            }
        }
    }

    SqlStatement createExecuteSql(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
        RolapStar star = groupingSetsList.getStar();
        String sql = AggregationManager.instance().generateSql(groupingSetsList, compoundPredicateList);
        return RolapUtil.executeQuery(star.getDataSource(), sql, "Segment.load", "Error while loading segment");
    }

    List<Object[]> processData(SqlStatement stmt, boolean[] axisContainsNull, SortedSet<Comparable<?>>[] axisValueSets, GroupingSetsList groupingSetsList) throws SQLException {
        Segment[] segments = groupingSetsList.getDefaultSegments();
        int measureCount = segments.length;
        List<Object[]> rawData = this.loadData(stmt, groupingSetsList);
        ArrayList<Object[]> processedRows = new ArrayList<Object[]>(rawData.size());
        int arity = axisValueSets.length;
        int groupingColumnStartIndex = arity + measureCount;
        for (Object[] row : rawData) {
            Object o;
            Object[] processedRow = groupingSetsList.useGroupingSets() ? new Object[row.length - groupingSetsList.getRollupColumns().size() + 1] : new Object[row.length];
            int columnIndex = 0;
            int axisIndex = 0;
            while (axisIndex < arity) {
                o = row[columnIndex];
                if (o == null) {
                    o = RolapUtil.sqlNullValue;
                    if (!groupingSetsList.useGroupingSets() || !this.isAggregateNull(row, groupingColumnStartIndex, groupingSetsList, axisIndex)) {
                        axisContainsNull[axisIndex] = true;
                    }
                } else {
                    axisValueSets[axisIndex].add(Aggregation.Axis.wrap(o));
                }
                processedRow[columnIndex] = o;
                ++axisIndex;
                ++columnIndex;
            }
            int i = 0;
            while (i < measureCount) {
                o = row[columnIndex];
                if (o == null) {
                    o = Util.nullValue;
                } else if (segments[i].measure.getDatatype().isNumeric() && !(o instanceof Double)) {
                    o = o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : (o instanceof byte[] ? Double.valueOf(Double.parseDouble(new String((byte[])o))) : Double.valueOf(Double.parseDouble(o.toString())));
                }
                processedRow[columnIndex] = o;
                ++i;
                ++columnIndex;
            }
            if (groupingSetsList.useGroupingSets()) {
                processedRow[columnIndex] = this.getRollupBitKey(groupingSetsList.getRollupColumns().size(), row, columnIndex);
            }
            processedRows.add(processedRow);
        }
        return processedRows;
    }

    BitKey getRollupBitKey(int arity, Object[] row, int k) {
        BitKey groupingBitKey = BitKey.Factory.makeBitKey(arity);
        for (int i = 0; i < arity; ++i) {
            Object o = row[k + i];
            if (!SegmentLoader.isOne(o)) continue;
            groupingBitKey.set(i);
        }
        return groupingBitKey;
    }

    private static boolean isOne(Object o) {
        return ((Number)o).intValue() == 1;
    }

    private boolean isAggregateNull(Object[] row, int groupingColumnStartIndex, GroupingSetsList groupingSetsList, int axisIndex) {
        int groupingFunctionIndex = groupingSetsList.findGroupingFunctionIndex(axisIndex);
        if (groupingFunctionIndex == -1) {
            return false;
        }
        return SegmentLoader.isOne(row[groupingColumnStartIndex + groupingFunctionIndex]);
    }

    List<Object[]> loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
        int arity = groupingSetsList.getDefaultColumns().length;
        int measureCount = groupingSetsList.getDefaultSegments().length;
        int groupingFunctionsCount = groupingSetsList.getRollupColumns().size();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ResultSet resultSet = stmt.getResultSet();
        while (resultSet.next()) {
            ++stmt.rowCount;
            Object[] row = groupingSetsList.useGroupingSets() ? new Object[arity + measureCount + groupingFunctionsCount] : new Object[arity + measureCount];
            for (int i = 0; i < row.length; ++i) {
                row[i] = resultSet.getObject(i + 1);
            }
            rows.add(row);
        }
        return rows;
    }

    List<RolapStar.Column[]> getGroupingColumnsList(RolapStar.Column[] detailedBatchColumns, List<GroupingSet> aggBatchDetails) {
        ArrayList<RolapStar.Column[]> groupingColumns = new ArrayList<RolapStar.Column[]>();
        if (aggBatchDetails.isEmpty()) {
            return groupingColumns;
        }
        groupingColumns.add(detailedBatchColumns);
        for (GroupingSet aggBatchDetail : aggBatchDetails) {
            groupingColumns.add(aggBatchDetail.getSegments()[0].aggregation.getColumns());
        }
        return groupingColumns;
    }

    SortedSet<Comparable<?>>[] getDistinctValueWorkspace(int arity) {
        SortedSet[] axisValueSets = new SortedSet[arity];
        for (int i = 0; i < axisValueSets.length; ++i) {
            if (Util.PreJdk15) {
                TreeSet<Object> set;
                assert (!Comparable.class.isAssignableFrom(Boolean.class));
                axisValueSets[i] = set = new TreeSet<Object>(new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof Boolean) {
                            boolean b1 = (Boolean)o1;
                            if (o2 instanceof Boolean) {
                                boolean b2 = (Boolean)o2;
                                return b1 == b2 ? 0 : (b1 ? 1 : -1);
                            }
                            return -1;
                        }
                        return ((Comparable)o1).compareTo(o2);
                    }
                });
                continue;
            }
            assert (Comparable.class.isAssignableFrom(Boolean.class));
            axisValueSets[i] = new TreeSet();
        }
        return axisValueSets;
    }

    private static boolean useSparse(double possibleCount, double actualCount) {
        boolean sparse;
        int countThreshold;
        MondrianProperties properties = MondrianProperties.instance();
        double densityThreshold = properties.SparseSegmentDensityThreshold.get();
        if (densityThreshold < 0.0) {
            densityThreshold = 0.0;
        }
        if (densityThreshold > 1.0) {
            densityThreshold = 1.0;
        }
        if ((countThreshold = properties.SparseSegmentCountThreshold.get()) < 0) {
            countThreshold = 0;
        }
        boolean bl = sparse = (possibleCount - (double)countThreshold) * densityThreshold > actualCount;
        if (possibleCount < (double)countThreshold) assert (!sparse) : "Should never use sparse if count is less than threshold, possibleCount=" + possibleCount + ", actualCount=" + actualCount + ", countThreshold=" + countThreshold + ", densityThreshold=" + densityThreshold;
        if (possibleCount == actualCount) assert (!sparse) : "Should never use sparse if result is 100% dense: possibleCount=" + possibleCount + ", actualCount=" + actualCount + ", countThreshold=" + countThreshold + ", densityThreshold=" + densityThreshold;
        return sparse;
    }
}

