/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.diff.builtin.ExportPatch;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class SingleDiffPanel
extends JPanel
implements PropertyChangeListener {
    private FileObject base;
    private FileObject modified;
    private final FileObject type;
    private DiffController controller;
    private Action nextAction;
    private Action prevAction;
    private JToolBar actionsToolbar;
    private JButton bExport;
    private JButton bNext;
    private JButton bOptions;
    private JButton bPrevious;
    private JButton bRefresh;
    private JButton bSwap;
    private JPanel controllerPanel;
    private JToolBar.Separator jSeparator1;

    public SingleDiffPanel(FileObject fileObject, FileObject fileObject2, FileObject fileObject3) throws IOException {
        this.base = fileObject;
        this.modified = fileObject2;
        this.type = fileObject3;
        this.initComponents();
        this.initMyComponents();
        this.refreshComponents();
    }

    private void initMyComponents() throws IOException {
        this.actionsToolbar.add(Box.createHorizontalGlue(), 0);
        this.actionsToolbar.add(Box.createHorizontalGlue());
        this.nextAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleDiffPanel.this.onNext();
            }
        };
        this.nextAction.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/diff-next.png")));
        this.bNext.setAction(this.nextAction);
        this.prevAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleDiffPanel.this.onPrev();
            }
        };
        this.prevAction.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/diff-prev.png")));
        this.bPrevious.setAction(this.prevAction);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
        this.refreshController();
    }

    private void refreshController() throws IOException {
        if (this.controller != null) {
            this.controller.removePropertyChangeListener(this);
            this.addPropertyChangeListener(this);
        }
        DiffStreamSource diffStreamSource = new DiffStreamSource(this.base, this.type, false);
        DiffStreamSource diffStreamSource2 = new DiffStreamSource(this.modified, this.type, true);
        this.controller = DiffController.create(diffStreamSource, diffStreamSource2);
        this.controller.addPropertyChangeListener(this);
        this.controllerPanel.removeAll();
        JComponent jComponent = this.controller.getJComponent();
        this.controllerPanel.add(jComponent);
        this.setName(jComponent.getName());
        this.revalidate();
        this.repaint();
    }

    private void onPrev() {
        int n = this.controller.getDifferenceIndex();
        if (n > 0) {
            this.controller.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n - 1);
        }
    }

    private void onNext() {
        int n = this.controller.getDifferenceIndex();
        if (n < this.controller.getDifferenceCount() - 1) {
            this.controller.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n + 1);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refreshComponents();
    }

    private void refreshComponents() {
        this.nextAction.setEnabled(this.controller.getDifferenceIndex() < this.controller.getDifferenceCount() - 1);
        this.prevAction.setEnabled(this.controller.getDifferenceIndex() > 0);
    }

    private void initComponents() {
        this.actionsToolbar = new JToolBar();
        this.bNext = new JButton();
        this.bPrevious = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.bRefresh = new JButton();
        this.bSwap = new JButton();
        this.bExport = new JButton();
        this.bOptions = new JButton();
        this.controllerPanel = new JPanel();
        this.actionsToolbar.setFloatable(false);
        this.actionsToolbar.setRollover(true);
        this.bNext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/diff/builtin/visualizer/editable/diff-next.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bNext, (String)NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bNext.text"));
        this.bNext.setToolTipText(NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bNext.toolTipText"));
        this.bNext.setFocusable(false);
        this.bNext.setHorizontalTextPosition(0);
        this.bNext.setVerticalTextPosition(3);
        this.actionsToolbar.add(this.bNext);
        this.bPrevious.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/diff/builtin/visualizer/editable/diff-prev.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bPrevious, (String)NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bPrevious.text"));
        this.bPrevious.setToolTipText(NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bPrevious.toolTipText"));
        this.bPrevious.setFocusable(false);
        this.bPrevious.setHorizontalTextPosition(0);
        this.bPrevious.setVerticalTextPosition(3);
        this.actionsToolbar.add(this.bPrevious);
        this.actionsToolbar.add(this.jSeparator1);
        this.bRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/diff/builtin/visualizer/editable/diff-refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bRefresh, (String)NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bRefresh.text"));
        this.bRefresh.setToolTipText(NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bRefresh.toolTipText"));
        this.bRefresh.setFocusable(false);
        this.bRefresh.setHorizontalTextPosition(0);
        this.bRefresh.setVerticalTextPosition(3);
        this.bRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleDiffPanel.this.bRefreshActionPerformed(actionEvent);
            }
        });
        this.actionsToolbar.add(this.bRefresh);
        Mnemonics.setLocalizedText((AbstractButton)this.bSwap, (String)NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bSwap.text"));
        this.bSwap.setFocusable(false);
        this.bSwap.setHorizontalTextPosition(0);
        this.bSwap.setVerticalTextPosition(3);
        this.bSwap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleDiffPanel.this.bSwapActionPerformed(actionEvent);
            }
        });
        this.actionsToolbar.add(this.bSwap);
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bExport.text"));
        this.bExport.setFocusable(false);
        this.bExport.setHorizontalTextPosition(0);
        this.bExport.setVerticalTextPosition(3);
        this.bExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleDiffPanel.this.bExportActionPerformed(actionEvent);
            }
        });
        this.actionsToolbar.add(this.bExport);
        Mnemonics.setLocalizedText((AbstractButton)this.bOptions, (String)NbBundle.getMessage(SingleDiffPanel.class, (String)"SingleDiffPanel.bOptions.text"));
        this.bOptions.setFocusable(false);
        this.bOptions.setHorizontalTextPosition(0);
        this.bOptions.setVerticalTextPosition(3);
        this.bOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleDiffPanel.this.bOptionsActionPerformed(actionEvent);
            }
        });
        this.actionsToolbar.add(this.bOptions);
        this.controllerPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.controllerPanel, -1, 531, Short.MAX_VALUE).add((Component)this.actionsToolbar, -1, 531, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.actionsToolbar, -2, 25, -2).addPreferredGap(0).add((Component)this.controllerPanel, -1, 371, Short.MAX_VALUE)));
    }

    private void bRefreshActionPerformed(ActionEvent actionEvent) {
        LifecycleManager.getDefault().saveAll();
        try {
            this.refreshController();
        }
        catch (IOException iOException) {
            Logger.getLogger(SingleDiffPanel.class.getName()).log(Level.SEVERE, "", iOException);
        }
    }

    private void bSwapActionPerformed(ActionEvent actionEvent) {
        LifecycleManager.getDefault().saveAll();
        FileObject fileObject = this.base;
        this.base = this.modified;
        this.modified = fileObject;
        try {
            this.refreshController();
        }
        catch (IOException iOException) {
            Logger.getLogger(SingleDiffPanel.class.getName()).log(Level.SEVERE, "", iOException);
        }
    }

    private void bExportActionPerformed(ActionEvent actionEvent) {
        DiffStreamSource diffStreamSource = new DiffStreamSource(this.base, this.type, false);
        DiffStreamSource diffStreamSource2 = new DiffStreamSource(this.modified, this.type, true);
        ExportPatch.exportPatch(new StreamSource[]{diffStreamSource}, new StreamSource[]{diffStreamSource2});
    }

    private void bOptionsActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("Advanced/Diff");
    }

    private static class DiffStreamSource
    extends StreamSource {
        private final FileObject fileObject;
        private final FileObject type;
        private final boolean isRight;

        public DiffStreamSource(FileObject fileObject, FileObject fileObject2, boolean bl) {
            this.fileObject = fileObject;
            this.type = fileObject2;
            this.isRight = bl;
        }

        public boolean isEditable() {
            return this.isRight && this.fileObject.canWrite();
        }

        public Lookup getLookup() {
            return Lookups.fixed((Object[])new Object[]{this.fileObject});
        }

        public String getName() {
            return this.fileObject.getName();
        }

        public String getTitle() {
            return FileUtil.getFileDisplayName((FileObject)this.fileObject);
        }

        public String getMIMEType() {
            if (this.type != null) {
                return this.type.getMIMEType();
            }
            return this.fileObject.getMIMEType();
        }

        public Reader createReader() throws IOException {
            if (this.type != null) {
                return new InputStreamReader(this.fileObject.getInputStream(), FileEncodingQuery.getEncoding((FileObject)this.type));
            }
            return new InputStreamReader(this.fileObject.getInputStream(), FileEncodingQuery.getEncoding((FileObject)this.fileObject));
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            return null;
        }
    }
}

