/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class Highlighting {
    private static Map<Document, WeakReference<Highlighting>> highlightings = new WeakHashMap<Document, WeakReference<Highlighting>>();
    private Document document;
    private EventListenerList listeners;
    private Set<Highlight> items = new HashSet<Highlight>();

    public static Highlighting getHighlighting(Document document) {
        Highlighting highlighting;
        WeakReference<Highlighting> weakReference = highlightings.get(document);
        Highlighting highlighting2 = highlighting = weakReference == null ? null : (Highlighting)weakReference.get();
        if (highlighting == null) {
            highlighting = new Highlighting(document);
            highlightings.put(document, new WeakReference<Highlighting>(highlighting));
        }
        return highlighting;
    }

    private Highlighting(Document document) {
        this.document = document;
    }

    public AttributeSet get(int n, int n2) {
        Highlight highlight = this.getHighlight(n, n2);
        if (highlight == null) {
            return null;
        }
        return highlight.attributeSet;
    }

    private Highlight getHighlight(int n, int n2) {
        for (Highlight highlight : this.items) {
            if (highlight.start.getOffset() != n || highlight.end.getOffset() != n2) continue;
            return highlight;
        }
        return null;
    }

    public Highlight highlight(int n, int n2, AttributeSet attributeSet) {
        try {
            Highlight highlight = new Highlight(this.document.createPosition(n), this.document.createPosition(n2), attributeSet);
            this.items.add(highlight);
            this.fire(n, n2);
            return highlight;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    protected void fire(int n, int n2) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.getListenerList();
        PropertyChangeEvent propertyChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, null, n, n2);
            }
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public class Highlight {
        private Position start;
        private Position end;
        private AttributeSet attributeSet;

        private Highlight(Position position, Position position2, AttributeSet attributeSet) {
            this.start = position;
            this.end = position2;
            this.attributeSet = attributeSet;
        }

        public void remove() {
            Highlighting.this.items.remove(this);
            Highlighting.this.fire(this.start.getOffset(), this.end.getOffset());
        }
    }
}

