/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TokenLength;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultToken<T extends TokenId>
extends AbstractToken<T>
implements CharSequence {
    private static final int INPUT_SOURCE_SUBSEQUENCE_THRESHOLD = 30;
    CharSequence tokenLengthOrCachedText;

    public DefaultToken(T t, int n) {
        super(t);
        assert (n > 0) : "Token length=" + n + " <= 0";
        this.tokenLengthOrCachedText = TokenLength.get(n);
    }

    public DefaultToken(T t) {
        super(t);
        this.tokenLengthOrCachedText = TokenLength.get(0);
    }

    @Override
    public int length() {
        return this.tokenLengthOrCachedText.length();
    }

    @Override
    protected String dumpInfoTokenType() {
        return "DefT";
    }

    @Override
    public synchronized CharSequence text() {
        CharSequence charSequence;
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            if (!this.isRemoved()) {
                int n = this.tokenLengthOrCachedText.length();
                if (n >= 30) {
                    CharSequence charSequence2 = this.tokenList.inputSourceText();
                    int n2 = this.tokenList.tokenOffset(this);
                    charSequence = new InputSourceSubsequence(this, charSequence2, n2, n2 + n, n2, n2 + n);
                } else {
                    charSequence = this;
                }
            } else {
                charSequence = null;
            }
        } else {
            charSequence = this.tokenLengthOrCachedText;
        }
        return charSequence;
    }

    @Override
    public final char charAt(int n) {
        if (n < 0 || n >= this.length()) {
            throw new IndexOutOfBoundsException("index=" + n + ", length=" + this.length());
        }
        if (this.tokenList == null) {
            throw new IndexOutOfBoundsException("index=" + n + ", length=" + this.length() + " but tokenList==null for token " + this.dumpInfo(null, null, false, true, 0));
        }
        int n2 = this.tokenList.tokenOffset(this);
        return this.tokenList.inputSourceText().charAt(n2 + n);
    }

    @Override
    public final synchronized CharSequence subSequence(int n, int n2) {
        CharSequence charSequence;
        int n3 = this.tokenLengthOrCachedText.length();
        CharSequenceUtilities.checkIndexesValid((int)n, (int)n2, (int)n3);
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            CharSequence charSequence2 = this.tokenList.inputSourceText();
            int n4 = this.tokenList.tokenOffset(this);
            charSequence = new InputSourceSubsequence(this, charSequence2, n4 + n, n4 + n2, n4, n4 + n3);
        } else {
            charSequence = this.tokenLengthOrCachedText.subSequence(n, n2);
        }
        return charSequence;
    }

    @Override
    public synchronized String toString() {
        String string;
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            if (!this.isRemoved()) {
                TokenLength tokenLength = (TokenLength)this.tokenLengthOrCachedText;
                CharSequence charSequence = this.tokenList.inputSourceText();
                int n = tokenLength.nextCacheFactor();
                int n2 = charSequence.getClass() == String.class ? 300 : 900;
                int n3 = this.tokenList.tokenOffset(this);
                string = ((Object)charSequence.subSequence(n3, n3 + tokenLength.length())).toString();
                this.tokenLengthOrCachedText = n < n2 ? tokenLength.next(n) : string;
            } else {
                string = "<null>";
            }
        } else {
            string = ((Object)this.tokenLengthOrCachedText).toString();
        }
        return string;
    }

    private static final class InputSourceSubsequence
    implements CharSequence {
        private final DefaultToken token;
        private final CharSequence inputSourceText;
        private final int start;
        private final int end;
        private final int tokenStart;
        private final int tokenEnd;

        public InputSourceSubsequence(DefaultToken defaultToken, CharSequence charSequence, int n, int n2, int n3, int n4) {
            this.token = defaultToken;
            this.inputSourceText = charSequence;
            this.start = n;
            this.end = n2;
            this.tokenStart = n3;
            this.tokenEnd = n4;
        }

        public int length() {
            return this.end - this.start;
        }

        public char charAt(int n) {
            CharSequenceUtilities.checkIndexValid((int)n, (int)this.length());
            return this.inputSourceText.charAt(this.start + n);
        }

        public CharSequence subSequence(int n, int n2) {
            CharSequenceUtilities.checkIndexesValid((CharSequence)this, (int)n, (int)n2);
            return new InputSourceSubsequence(this.token, this.inputSourceText, this.start + n, this.start + n2, this.tokenStart, this.tokenEnd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            DefaultToken defaultToken = this.token;
            synchronized (defaultToken) {
                String string;
                if (this.token.tokenLengthOrCachedText.getClass() == TokenLength.class) {
                    int n;
                    TokenLength tokenLength = (TokenLength)this.token.tokenLengthOrCachedText;
                    int n2 = tokenLength.nextCacheFactor();
                    int n3 = n = this.inputSourceText.getClass() == String.class ? 300 : 900;
                    if (n2 < n) {
                        string = ((Object)this.inputSourceText.subSequence(this.start, this.end)).toString();
                        this.token.tokenLengthOrCachedText = tokenLength.next(n2);
                    } else {
                        String string2 = ((Object)this.inputSourceText.subSequence(this.tokenStart, this.tokenEnd)).toString();
                        this.token.tokenLengthOrCachedText = string2;
                        string = string2.substring(this.start - this.tokenStart, this.end - this.tokenStart);
                    }
                } else {
                    string = ((Object)this.token.tokenLengthOrCachedText.subSequence(this.start - this.tokenStart, this.end - this.tokenStart)).toString();
                }
                return string;
            }
        }
    }
}

