/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.project.uiapi.ActionsFactory;
import org.netbeans.modules.project.uiapi.CategoryChangeSupport;
import org.netbeans.modules.project.uiapi.OpenProjectsTrampoline;
import org.netbeans.modules.project.uiapi.ProjectChooserFactory;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;

public class Utilities {
    private static final Map<ProjectCustomizer.Category, CategoryChangeSupport> CATEGORIES = new HashMap<ProjectCustomizer.Category, CategoryChangeSupport>();

    private Utilities() {
    }

    public static ActionsFactory getActionsFactory() {
        ActionsFactory actionsFactory = (ActionsFactory)Lookup.getDefault().lookup(ActionsFactory.class);
        assert (actionsFactory != null) : "Need to have " + ActionsFactory.class.getName() + " instance in the default lookup";
        return actionsFactory;
    }

    public static ProjectChooserFactory getProjectChooserFactory() {
        ProjectChooserFactory projectChooserFactory = (ProjectChooserFactory)Lookup.getDefault().lookup(ProjectChooserFactory.class);
        assert (projectChooserFactory != null) : "Need to have " + ProjectChooserFactory.class.getName() + " instance in the default lookup";
        return projectChooserFactory;
    }

    public static OpenProjectsTrampoline getOpenProjectsTrampoline() {
        OpenProjectsTrampoline openProjectsTrampoline = (OpenProjectsTrampoline)Lookup.getDefault().lookup(OpenProjectsTrampoline.class);
        assert (openProjectsTrampoline != null) : "Need to have " + OpenProjectsTrampoline.class.getName() + " instance in the default lookup";
        return openProjectsTrampoline;
    }

    public static CategoryChangeSupport getCategoryChangeSupport(ProjectCustomizer.Category category) {
        CategoryChangeSupport categoryChangeSupport = CATEGORIES.get(category);
        return categoryChangeSupport == null ? CategoryChangeSupport.NULL_INSTANCE : categoryChangeSupport;
    }

    public static void putCategoryChangeSupport(ProjectCustomizer.Category category, CategoryChangeSupport categoryChangeSupport) {
        CATEGORIES.put(category, categoryChangeSupport);
    }

    public static void removeCategoryChangeSupport(ProjectCustomizer.Category category) {
        CATEGORIES.remove(category);
    }
}

