/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table;

import com.jaspersoft.ireport.components.table.EditDatasetRunAction;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnEndAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnGroupAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnStartAction;
import com.jaspersoft.ireport.components.table.nodes.TableCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableChildren;
import com.jaspersoft.ireport.components.table.nodes.TableColumnGroupNode;
import com.jaspersoft.ireport.components.table.nodes.TableNullCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableSectionNode;
import com.jaspersoft.ireport.components.table.undo.AddTableCellUndoableEdit;
import com.jaspersoft.ireport.components.table.undo.DeleteTableCellUndoableEdit;
import com.jaspersoft.ireport.components.table.undo.DeleteTableColumnUndoableEdit;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardGroupCell;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableElementNode
extends ElementNode {
    JRDesignDataset currentDataset = null;
    PropertyChangeListener datasetRunChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TableElementNode.this.datasetPropertyChanged(evt);
        }
    };
    StandardTable table = null;

    public TableElementNode(JasperDesign jd, JRDesignElement element, Children children, Index index, Lookup doLkp) {
        super(jd, element, children, index, doLkp);
        this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/table-16.png");
        this.table = (StandardTable)((JRDesignComponentElement)element).getComponent();
        this.updateDatasetRunListeners();
    }

    public String getDisplayName() {
        return I18n.getString((String)"TableElementNode.name");
    }

    public boolean canPaste() {
        return true;
    }

    public Action[] getActions(boolean popup) {
        ArrayList<Object> actions = new ArrayList<Object>();
        Action[] originalActions = super.getActions(popup);
        actions.add(SystemAction.get(EditDatasetRunAction.class));
        actions.add(SystemAction.get(AddTableColumnStartAction.class));
        actions.add(SystemAction.get(AddTableColumnEndAction.class));
        actions.add(SystemAction.get(AddTableColumnGroupAction.class));
        for (int i = 0; i < originalActions.length; ++i) {
            actions.add(originalActions[i]);
        }
        return actions.toArray(new Action[actions.size()]);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.setName("Table");
        set.setDisplayName(I18n.getString((String)"TableElementNode.name"));
        sheet.put(set);
        return sheet;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    public StandardTable getTable() {
        return (StandardTable)((JRDesignComponentElement)this.getElement()).getComponent();
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (dropNode == null || dropNode instanceof TableCellNode || dropNode instanceof TableNullCellNode || dropNode instanceof TableColumnGroupNode || dropNode instanceof TableSectionNode) {
            return null;
        }
        return super.getDropType(t, action, index);
    }

    private void updateDatasetRunListeners() {
        this.table.getEventSupport().removePropertyChangeListener("datasetRun", this.datasetRunChangeListener);
        this.table.getEventSupport().addPropertyChangeListener("datasetRun", this.datasetRunChangeListener);
        JRDesignDataset dataset = null;
        if (this.table.getDatasetRun() != null && this.table.getDatasetRun().getDatasetName() != null) {
            dataset = (JRDesignDataset)this.getJasperDesign().getDatasetMap().get(this.table.getDatasetRun().getDatasetName());
        }
        if (dataset == this.currentDataset) {
            return;
        }
        if (dataset != this.currentDataset) {
            JRDesignGroup group;
            int i;
            List groups;
            if (this.currentDataset != null) {
                this.currentDataset.getEventSupport().removePropertyChangeListener(this.datasetRunChangeListener);
                groups = this.currentDataset.getGroupsList();
                for (i = 0; i < groups.size(); ++i) {
                    group = (JRDesignGroup)groups.get(i);
                    group.getEventSupport().removePropertyChangeListener("name", this.datasetRunChangeListener);
                }
            }
            this.currentDataset = dataset;
            dataset.getEventSupport().addPropertyChangeListener(this.datasetRunChangeListener);
            groups = this.currentDataset.getGroupsList();
            for (i = 0; i < groups.size(); ++i) {
                group = (JRDesignGroup)groups.get(i);
                group.getEventSupport().removePropertyChangeListener("name", this.datasetRunChangeListener);
                group.getEventSupport().addPropertyChangeListener("name", this.datasetRunChangeListener);
            }
        }
    }

    protected void datasetPropertyChanged(PropertyChangeEvent evt) {
        boolean refreshTableStructure = false;
        if (evt.getPropertyName().equals("name")) {
            if (evt.getSource() instanceof JRDesignDataset) {
                ((JRDesignDatasetRun)this.table.getDatasetRun()).setDatasetName(this.currentDataset.getName());
            } else if (evt.getSource() instanceof JRDesignGroup) {
                this.updateColumnGroupName(this.table.getColumns(), (String)evt.getOldValue(), (String)evt.getNewValue());
                System.out.println("updating group:  " + evt.getOldValue() + " " + evt.getNewValue());
                System.out.flush();
                this.table.getEventSupport().firePropertyChange("columns", null, (Object)this.table.getColumns());
                refreshTableStructure = true;
            }
        }
        if (evt.getPropertyName().equals("groups")) {
            AggregatedUndoableEdit edit = this.removeLostColumnSections();
            if (edit != null) {
                IReportManager.getInstance().addUndoableEdit((UndoableEdit)edit);
            }
            refreshTableStructure = true;
        }
        if (evt.getPropertyName().equals("datasetRun")) {
            refreshTableStructure = true;
        }
        if (refreshTableStructure) {
            this.updateDatasetRunListeners();
            ((TableChildren)this.getChildren()).recalculateKeys();
        }
    }

    private void updateColumnGroupName(List<BaseColumn> columns, String oldValue, String newValue) {
        for (BaseColumn col : columns) {
            for (GroupCell header : col.getGroupHeaders()) {
                if (!header.getGroupName().equals(oldValue)) continue;
                ((StandardGroupCell)header).setGroupName(newValue);
            }
            for (GroupCell footer : col.getGroupFooters()) {
                if (!footer.getGroupName().equals(oldValue)) continue;
                ((StandardGroupCell)footer).setGroupName(newValue);
            }
            if (!(col instanceof StandardColumnGroup)) continue;
            this.updateColumnGroupName(((StandardColumnGroup)col).getColumns(), oldValue, newValue);
        }
    }

    private AggregatedUndoableEdit removeLostColumnSections() {
        ArrayList<String> validGroupNames = new ArrayList<String>();
        List groups = this.currentDataset.getGroupsList();
        for (int i = 0; i < groups.size(); ++i) {
            JRGroup group = (JRGroup)groups.get(i);
            validGroupNames.add(group.getName());
        }
        return this.removeGroupCellFrom(this.table.getColumns(), validGroupNames);
    }

    private AggregatedUndoableEdit removeGroupCellFrom(List<BaseColumn> columns, List<String> validGroupNames) {
        AggregatedUndoableEdit edit = null;
        for (int i = columns.size() - 1; i >= 0; --i) {
            AggregatedUndoableEdit ed;
            BaseColumn col = columns.get(i);
            for (GroupCell header : col.getGroupHeaders()) {
                if (header.getCell() == null || validGroupNames.contains(header.getGroupName())) continue;
                ed = this.deleteCell(col, (DesignCell)header.getCell(), (byte)2, header.getGroupName());
                if (edit == null) {
                    edit = ed;
                    break;
                }
                if (ed == null) break;
                edit.concatenate((UndoableEdit)ed);
                break;
            }
            for (GroupCell footer : col.getGroupFooters()) {
                if (footer.getCell() == null || validGroupNames.contains(footer.getGroupName())) continue;
                ed = this.deleteCell(col, (DesignCell)footer.getCell(), (byte)4, footer.getGroupName());
                if (edit == null) {
                    edit = ed;
                    break;
                }
                if (ed == null) break;
                edit.concatenate((UndoableEdit)ed);
                break;
            }
            if (!(col instanceof StandardColumnGroup)) continue;
            AggregatedUndoableEdit ed2 = this.removeGroupCellFrom(((StandardColumnGroup)col).getColumns(), validGroupNames);
            if (edit == null) {
                edit = ed2;
                continue;
            }
            if (ed2 == null) continue;
            edit.concatenate((UndoableEdit)ed2);
        }
        return edit;
    }

    private AggregatedUndoableEdit deleteCell(BaseColumn column, DesignCell cell, byte section, String groupName) {
        AggregatedUndoableEdit edit = null;
        Object parentGroup = TableModelUtils.getColumnParent(this.table, column);
        if (column instanceof StandardColumn) {
            int cells = 0;
            if (((StandardColumn)column).getTableHeader() != null) {
                ++cells;
            }
            if (((StandardColumn)column).getTableFooter() != null) {
                ++cells;
            }
            if (((StandardColumn)column).getColumnHeader() != null) {
                ++cells;
            }
            if (((StandardColumn)column).getColumnFooter() != null) {
                ++cells;
            }
            if (((StandardColumn)column).getDetailCell() != null) {
                ++cells;
            }
            for (GroupCell groupCell : ((StandardColumn)column).getGroupHeaders()) {
                if (groupCell.getCell() == null) continue;
                ++cells;
            }
            for (GroupCell groupCell : ((StandardColumn)column).getGroupFooters()) {
                if (groupCell.getCell() == null) continue;
                ++cells;
            }
            if (cells == 1) {
                if (TableModelUtils.getStandardColumnsCount(this.table.getColumns()) == 1) {
                    DesignCell detailCell = new DesignCell();
                    detailCell.setHeight(Integer.valueOf(30));
                    TableModelUtils.addCell(column, detailCell, (byte)3, null);
                    AddTableCellUndoableEdit aUndo = new AddTableCellUndoableEdit(this.table, this.getJasperDesign(), detailCell, column, 3, null);
                    if (edit == null) {
                        edit = aUndo;
                    } else {
                        edit.concatenate((UndoableEdit)((Object)aUndo));
                    }
                    ++cells;
                }
                if (cells == 2) {
                    TableModelUtils.removeCell(column, section, groupName);
                    DeleteTableCellUndoableEdit edit2 = new DeleteTableCellUndoableEdit(this.table, this.getJasperDesign(), cell, column, section, groupName);
                    if (edit == null) {
                        edit = edit2;
                    } else {
                        edit.concatenate((UndoableEdit)((Object)edit2));
                    }
                } else {
                    int position = TableModelUtils.getColumns(parentGroup).indexOf(column);
                    TableModelUtils.removeColumn(parentGroup, column, position);
                    DeleteTableColumnUndoableEdit edit2 = new DeleteTableColumnUndoableEdit(this.table, this.getJasperDesign(), column, parentGroup, position);
                    if (edit == null) {
                        edit = edit2;
                    } else {
                        edit.concatenate((UndoableEdit)((Object)edit2));
                    }
                    List oldColumns = TableModelUtils.getColumns(parentGroup);
                    while (oldColumns.size() == 0 && parentGroup instanceof StandardColumnGroup) {
                        Object oldParentParent = TableModelUtils.getColumnParent(this.table, (BaseColumn)((StandardColumnGroup)parentGroup));
                        if (oldParentParent == null) continue;
                        if (oldParentParent instanceof StandardTable) {
                            position = ((StandardTable)oldParentParent).getColumns().indexOf((StandardColumnGroup)parentGroup);
                            ((StandardTable)oldParentParent).removeColumn((BaseColumn)((StandardColumnGroup)parentGroup));
                            edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(this.table, this.getJasperDesign(), (BaseColumn)((StandardColumnGroup)parentGroup), oldParentParent, position)));
                            oldColumns = ((StandardTable)oldParentParent).getColumns();
                            parentGroup = oldParentParent;
                            continue;
                        }
                        position = ((StandardColumnGroup)oldParentParent).getColumns().indexOf((StandardColumnGroup)parentGroup);
                        ((StandardColumnGroup)oldParentParent).removeColumn((BaseColumn)((StandardColumnGroup)parentGroup));
                        edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(this.table, this.getJasperDesign(), (BaseColumn)((StandardColumnGroup)parentGroup), oldParentParent, position)));
                        oldColumns = ((StandardColumnGroup)oldParentParent).getColumns();
                        parentGroup = oldParentParent;
                    }
                }
                return edit;
            }
        }
        TableModelUtils.removeCell(column, section, groupName);
        DeleteTableCellUndoableEdit edit2 = new DeleteTableCellUndoableEdit(this.table, this.getJasperDesign(), cell, column, section, groupName);
        if (edit == null) {
            edit = edit2;
        } else {
            edit.concatenate((UndoableEdit)((Object)edit2));
        }
        return edit;
    }
}

