/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CompactMap;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenOrEmbedding;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SnapshotTokenList<T extends TokenId>
implements TokenList<T> {
    private TokenHierarchyOperation<?, T> snapshot;
    private IncTokenList<T> liveTokenList;
    private int liveTokenGapStart = -1;
    private int liveTokenGapEnd;
    private int liveTokenGapStartOffset;
    private int liveTokenOffsetDiff;
    private TokenOrEmbedding<T>[] origTokenOrEmbeddings;
    private int[] origOffsets;
    private int origTokenStartIndex;
    private int origTokenCount;
    private CompactMap<AbstractToken<T>, Token2OffsetEntry<T>> token2offset;

    public int liveTokenGapStart() {
        return this.liveTokenGapStart;
    }

    public int liveTokenGapEnd() {
        return this.liveTokenGapEnd;
    }

    public SnapshotTokenList(TokenHierarchyOperation<?, T> tokenHierarchyOperation) {
        this.snapshot = tokenHierarchyOperation;
        this.token2offset = new CompactMap();
    }

    public TokenHierarchyOperation<?, T> snapshot() {
        return this.snapshot;
    }

    @Override
    public LanguagePath languagePath() {
        return this.liveTokenList.languagePath();
    }

    @Override
    public TokenOrEmbedding<T> tokenOrEmbedding(int n) {
        if (this.liveTokenGapStart == -1 || n < this.liveTokenGapStart) {
            return this.liveTokenList.tokenOrEmbedding(n);
        }
        if ((n -= this.liveTokenGapStart) < this.origTokenCount) {
            return this.origTokenOrEmbeddings[this.origTokenStartIndex + n];
        }
        return this.liveTokenList.tokenOrEmbedding(this.liveTokenGapEnd + n - this.origTokenCount);
    }

    @Override
    public int lookahead(int n) {
        return -1;
    }

    @Override
    public Object state(int n) {
        return null;
    }

    @Override
    public int tokenOffset(int n) {
        int n2;
        if (this.liveTokenGapStart == -1 || n < this.liveTokenGapStart) {
            return this.liveTokenList.tokenOffset(n);
        }
        if ((n -= this.liveTokenGapStart) < this.origTokenCount) {
            return this.origOffsets[this.origTokenStartIndex + n];
        }
        AbstractToken<T> abstractToken = this.liveTokenList.tokenOrEmbeddingUnsync(this.liveTokenGapEnd + (n -= this.origTokenCount)).token();
        if (abstractToken.isFlyweight()) {
            n2 = abstractToken.length();
            while (--n >= 0) {
                abstractToken = this.liveTokenList.tokenOrEmbeddingUnsync(this.liveTokenGapEnd + n).token();
                if (abstractToken.isFlyweight()) {
                    n2 += abstractToken.length();
                    continue;
                }
                n2 += this.tokenOffset(abstractToken, this.liveTokenList);
                break;
            }
            if (n == -1 && (n += this.liveTokenGapStart + this.origTokenCount) >= 0) {
                n2 += this.tokenOffset(n);
            }
        } else {
            n2 = this.tokenOffset(abstractToken, this.liveTokenList);
        }
        return n2;
    }

    @Override
    public int[] tokenIndex(int n) {
        return LexerUtilsConstants.tokenIndexLazyTokenCreation(this, n);
    }

    public <TT extends TokenId> int tokenOffset(AbstractToken<TT> abstractToken, TokenList<TT> tokenList) {
        if (tokenList.getClass() == EmbeddedTokenList.class) {
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)tokenList;
            Object var4_5 = null;
            Token2OffsetEntry token2OffsetEntry = (Token2OffsetEntry)((Object)this.token2offset.get(var4_5));
            if (token2OffsetEntry != null) {
                return token2OffsetEntry.offset();
            }
            int n = embeddedTokenList.tokenOffset(abstractToken);
            TokenList<?> tokenList2 = embeddedTokenList.rootTokenList();
            if (tokenList2 != null && tokenList2.getClass() == IncTokenList.class && n >= this.liveTokenGapStartOffset) {
                n += this.liveTokenOffsetDiff;
            }
            return n;
        }
        Token2OffsetEntry token2OffsetEntry = (Token2OffsetEntry)((Object)this.token2offset.get(abstractToken));
        if (token2OffsetEntry != null) {
            return token2OffsetEntry.offset();
        }
        int n = tokenList.tokenOffset(abstractToken);
        if (tokenList.getClass() == IncTokenList.class && n >= this.liveTokenGapStartOffset) {
            n += this.liveTokenOffsetDiff;
        }
        return n;
    }

    @Override
    public int tokenCount() {
        return this.liveTokenGapStart == -1 ? this.liveTokenList.tokenCount() : this.liveTokenList.tokenCount() - (this.liveTokenGapEnd - this.liveTokenGapStart) + this.origTokenCount;
    }

    @Override
    public int tokenCountCurrent() {
        return this.liveTokenGapStart == -1 ? this.liveTokenList.tokenCountCurrent() : this.liveTokenList.tokenCountCurrent() - (this.liveTokenGapEnd - this.liveTokenGapStart) + this.origTokenCount;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public int tokenOffset(AbstractToken<T> abstractToken) {
        int n = abstractToken.rawOffset();
        return n;
    }

    public char charAt(int n) {
        throw new IllegalStateException("Not expected to be called");
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer<T> embeddingContainer) {
        if (this.liveTokenGapStart == -1 || n < this.liveTokenGapStart) {
            this.liveTokenList.wrapToken(n, embeddingContainer);
        } else if ((n -= this.liveTokenGapStart) < this.origTokenCount) {
            this.origTokenOrEmbeddings[this.origTokenStartIndex + n] = embeddingContainer;
        } else {
            this.liveTokenList.wrapToken(this.liveTokenGapEnd + n - this.origTokenCount, embeddingContainer);
        }
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        AbstractToken<T> abstractToken2;
        if (this.liveTokenGapStart == -1 || n < this.liveTokenGapStart) {
            abstractToken2 = this.liveTokenList.replaceFlyToken(n, abstractToken, n2);
        } else if ((n -= this.liveTokenGapStart) < this.origTokenCount) {
            abstractToken2 = ((TextToken)abstractToken).createCopy(this, n2);
            this.origTokenOrEmbeddings[this.origTokenStartIndex + n] = abstractToken2;
        } else {
            abstractToken2 = this.liveTokenList.replaceFlyToken(this.liveTokenGapEnd + n - this.origTokenCount, abstractToken, n2 - this.liveTokenOffsetDiff);
        }
        return abstractToken2;
    }

    @Override
    public TokenList<?> rootTokenList() {
        return this;
    }

    @Override
    public CharSequence inputSourceText() {
        return this.rootTokenList().inputSourceText();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.snapshot;
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.liveTokenList.inputAttributes();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffset(0);
        }
        return 0;
    }

    @Override
    public int endOffset() {
        int n = this.tokenCount() - 1;
        if (n >= 0) {
            return this.tokenOffset(n) + this.tokenOrEmbedding(n).token().length();
        }
        return 0;
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    public boolean canModifyToken(int n, AbstractToken abstractToken) {
        return this.liveTokenGapStart != -1 && n >= this.liveTokenGapStart && n < this.liveTokenGapEnd && !this.token2offset.containsKey((Object)abstractToken);
    }

    public void update(TokenHierarchyEventInfo tokenHierarchyEventInfo, TokenListChange<T> tokenListChange) {
        AbstractToken abstractToken;
        TokenOrEmbedding tokenOrEmbedding;
        int n;
        int n2;
        int n3;
        int n4;
        RemovedTokenList<T> removedTokenList = tokenListChange.tokenChangeInfo().removedTokenList();
        int n5 = tokenListChange.index();
        int n6 = n5 + removedTokenList.tokenCount();
        if (this.liveTokenGapStart == -1) {
            this.liveTokenGapStart = n5;
            this.liveTokenGapEnd = n5;
            this.liveTokenGapStartOffset = tokenListChange.offset();
            TokenOrEmbedding[] tokenOrEmbeddingArray = new TokenOrEmbedding[removedTokenList.tokenCount()];
            this.origTokenOrEmbeddings = tokenOrEmbeddingArray;
            this.origOffsets = new int[this.origTokenOrEmbeddings.length];
        }
        int n7 = tokenListChange.tokenChangeInfo().addedTokenCount() - removedTokenList.tokenCount();
        if (n5 < this.liveTokenGapStart) {
            TokenOrEmbedding tokenOrEmbedding2;
            n4 = this.liveTokenGapStart - n5;
            this.ensureOrigTokensStartCapacity(n4);
            this.origTokenStartIndex -= n4;
            this.origTokenCount += n4;
            n3 = Math.min(n6, this.liveTokenGapStart);
            this.liveTokenGapStartOffset = n2 = tokenListChange.offset();
            for (n = n5; n < n3; ++n) {
                tokenOrEmbedding2 = removedTokenList.tokenOrEmbedding(n - n5);
                tokenOrEmbedding = tokenOrEmbedding2.token();
                if (!((AbstractToken)tokenOrEmbedding).isFlyweight() && (abstractToken = ((AbstractToken)tokenOrEmbedding).tokenList()) == null) {
                    abstractToken = null;
                    if (!((AbstractToken)tokenOrEmbedding).isFlyweight()) {
                        ((AbstractToken)tokenOrEmbedding).setTokenList(abstractToken);
                    }
                }
                this.origOffsets[this.origTokenStartIndex] = n2;
                this.origTokenOrEmbeddings[this.origTokenStartIndex++] = tokenOrEmbedding2;
                n2 += ((Token)((Object)tokenOrEmbedding)).length();
            }
            while (n < this.liveTokenGapStart) {
                tokenOrEmbedding2 = this.liveTokenList.tokenOrEmbeddingUnsync(n + n7);
                tokenOrEmbedding = tokenOrEmbedding2.token();
                if (!((AbstractToken)tokenOrEmbedding).isFlyweight()) {
                    this.token2offset.putEntry(new Token2OffsetEntry(tokenOrEmbedding, n2));
                }
                this.origOffsets[this.origTokenStartIndex] = n2;
                this.origTokenOrEmbeddings[this.origTokenStartIndex++] = tokenOrEmbedding2;
                n2 += ((Token)((Object)tokenOrEmbedding)).length();
                ++n;
            }
            this.liveTokenGapStart = n5;
        }
        if (n6 > this.liveTokenGapEnd) {
            n4 = n6 - this.liveTokenGapEnd;
            this.ensureOrigTokensEndCapacity(n4);
            this.origTokenCount += n4;
            n3 = this.origTokenStartIndex + this.origTokenCount - 1;
            n = Math.max(n5, this.liveTokenGapEnd);
            n2 = n6;
            int n8 = tokenListChange.removedEndOffset();
            for (n2 = n6 - 1; n2 >= n; --n2) {
                TokenList tokenList;
                tokenOrEmbedding = removedTokenList.tokenOrEmbedding(n2 - n5);
                abstractToken = tokenOrEmbedding.token();
                n8 -= abstractToken.length();
                if (!abstractToken.isFlyweight() && (tokenList = abstractToken.tokenList()) == null) {
                    tokenList = null;
                    if (!abstractToken.isFlyweight()) {
                        abstractToken.setTokenList(tokenList);
                    }
                }
                this.origOffsets[n3] = n8 + this.liveTokenOffsetDiff;
                if (this.liveTokenOffsetDiff != 0) {
                    this.token2offset.putEntry(new Token2OffsetEntry(abstractToken, this.origOffsets[n3]));
                }
                this.origTokenOrEmbeddings[n3--] = tokenOrEmbedding;
            }
            while (n2 >= this.liveTokenGapEnd) {
                tokenOrEmbedding = this.liveTokenList.tokenOrEmbeddingUnsync(n2 + n7);
                abstractToken = tokenOrEmbedding.token();
                n8 -= abstractToken.length();
                if (!abstractToken.isFlyweight()) {
                    this.token2offset.putEntry(new Token2OffsetEntry(abstractToken, n8));
                }
                this.origOffsets[n3] = n8 + this.liveTokenOffsetDiff;
                this.token2offset.putEntry(new Token2OffsetEntry(abstractToken, this.origOffsets[n3]));
                this.origTokenOrEmbeddings[n3--] = tokenOrEmbedding;
                --n2;
            }
            this.liveTokenGapEnd = n6;
        }
        this.liveTokenOffsetDiff += tokenHierarchyEventInfo.removedLength() - tokenHierarchyEventInfo.insertedLength();
        this.liveTokenGapEnd += n7;
    }

    private void ensureOrigTokensStartCapacity(int n) {
        if (n > this.origTokenOrEmbeddings.length - this.origTokenCount) {
            TokenOrEmbedding[] tokenOrEmbeddingArray = new TokenOrEmbedding[this.origTokenOrEmbeddings.length * 3 / 2 + n];
            int[] nArray = new int[tokenOrEmbeddingArray.length];
            int n2 = Math.max(n, (tokenOrEmbeddingArray.length - (this.origTokenCount + n)) / 2);
            System.arraycopy(this.origTokenOrEmbeddings, this.origTokenStartIndex, tokenOrEmbeddingArray, n2, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, nArray, n2, this.origTokenCount);
            this.origTokenOrEmbeddings = tokenOrEmbeddingArray;
            this.origOffsets = nArray;
            this.origTokenStartIndex = n2;
        } else if (n > this.origTokenStartIndex) {
            int n3 = this.origTokenOrEmbeddings.length - this.origTokenCount;
            System.arraycopy(this.origTokenOrEmbeddings, this.origTokenStartIndex, this.origTokenOrEmbeddings, n3, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, this.origOffsets, n3, this.origTokenCount);
            this.origTokenStartIndex = this.origTokenOrEmbeddings.length - this.origTokenCount;
        }
    }

    private void ensureOrigTokensEndCapacity(int n) {
        if (n > this.origTokenOrEmbeddings.length - this.origTokenCount) {
            TokenOrEmbedding[] tokenOrEmbeddingArray = new TokenOrEmbedding[this.origTokenOrEmbeddings.length * 3 / 2 + n];
            int[] nArray = new int[tokenOrEmbeddingArray.length];
            int n2 = (tokenOrEmbeddingArray.length - (this.origTokenCount + n)) / 2;
            System.arraycopy(this.origTokenOrEmbeddings, this.origTokenStartIndex, tokenOrEmbeddingArray, n2, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, nArray, n2, this.origTokenCount);
            this.origTokenOrEmbeddings = tokenOrEmbeddingArray;
            this.origOffsets = nArray;
            this.origTokenStartIndex = n2;
        } else if (n > this.origTokenOrEmbeddings.length - this.origTokenCount - this.origTokenStartIndex) {
            System.arraycopy(this.origTokenOrEmbeddings, this.origTokenStartIndex, this.origTokenOrEmbeddings, 0, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, this.origOffsets, 0, this.origTokenCount);
            this.origTokenStartIndex = 0;
        }
    }

    public String toString() {
        return "liveTokenGapStart=" + this.liveTokenGapStart + ", liveTokenGapEnd=" + this.liveTokenGapEnd + ", liveTokenGapStartOffset=" + this.liveTokenGapStartOffset + ", liveTokenOffsetDiff=" + this.liveTokenOffsetDiff + ",\n origTokenStartIndex=" + this.origTokenStartIndex + ", origTokenCount=" + this.origTokenCount + ", token2offset: " + this.token2offset;
    }

    public int tokenShiftStartOffset() {
        return this.liveTokenGapStartOffset;
    }

    public int tokenShiftEndOffset() {
        return this.liveTokenGapStartOffset + this.liveTokenOffsetDiff;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Token2OffsetEntry<T extends TokenId>
    extends CompactMap.MapEntry<AbstractToken<T>, Token2OffsetEntry<T>> {
        private final AbstractToken<T> token;
        private final int offset;

        Token2OffsetEntry(AbstractToken<T> abstractToken, int n) {
            this.token = abstractToken;
            this.offset = n;
        }

        public AbstractToken<T> getKey() {
            return this.token;
        }

        public Token2OffsetEntry<T> getValue() {
            return this;
        }

        protected int valueHashCode() {
            return this.offset;
        }

        protected boolean valueEquals(Object object) {
            return object instanceof Token2OffsetEntry && ((Token2OffsetEntry)((Object)object)).offset() == this.offset();
        }

        public int offset() {
            return this.offset;
        }

        public Token2OffsetEntry<T> setValue(Token2OffsetEntry<T> token2OffsetEntry) {
            throw new IllegalStateException("Prohibited");
        }

        public String toString() {
            return String.valueOf(this.offset);
        }
    }
}

