/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SchemaParser
extends DefaultHandler {
    private SchemaInfo info = new SchemaInfo();
    private int depth = 0;

    public SchemaInfo parse(String string) {
        if (string == null) {
            return null;
        }
        return this.parse(new InputSource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaInfo parse(InputSource inputSource) {
        Util.THIS.debug("SchemaParser started.");
        try {
            EntityResolver entityResolver;
            this.depth = 0;
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            UserCatalog userCatalog = UserCatalog.getDefault();
            EntityResolver entityResolver2 = entityResolver = userCatalog == null ? null : userCatalog.getEntityResolver();
            if (entityResolver != null) {
                xMLReader.setEntityResolver(entityResolver);
            }
            xMLReader.parse(inputSource);
            SchemaInfo schemaInfo = this.info;
            return schemaInfo;
        }
        catch (SAXException sAXException) {
            Util.THIS.debug("Ignoring ex. thrown while looking for Schema roots:", sAXException);
            if (sAXException.getException() instanceof RuntimeException) {
                Util.THIS.debug("Nested exception:", sAXException.getException());
            }
            SchemaInfo schemaInfo = this.info;
            return schemaInfo;
        }
        catch (IOException iOException) {
            Util.THIS.debug("Ignoring ex. thrown while looking for Schema roots:", iOException);
            SchemaInfo schemaInfo = this.info;
            return schemaInfo;
        }
        finally {
            Util.THIS.debug("SchemaParser stopped.");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        ++this.depth;
        if (this.depth > 2) {
            return;
        }
        if ("element".equals(string2)) {
            String string5 = attributes.getValue("name");
            if (string5 != null) {
                Util.THIS.debug("\telement decl: " + string5);
                this.info.roots.add(string5);
            }
        } else if ("schema".equals(string2) && (string4 = attributes.getValue("targetNamespace")) != null) {
            Util.THIS.debug("\ttarget namespace: " + string4);
            this.info.namespace = string4;
        }
    }

    public void endElement(String string, String string2, String string3) {
        --this.depth;
    }

    public static String getNamespace(FileObject fileObject) {
        SchemaParser schemaParser = new SchemaParser();
        File file = FileUtil.toFile((FileObject)fileObject);
        SchemaInfo schemaInfo = schemaParser.parse(file.toURI().toString());
        if (schemaInfo == null) {
            return null;
        }
        return schemaInfo.namespace;
    }

    public static SchemaInfo getRootElements(FileObject fileObject) {
        SchemaParser schemaParser = new SchemaParser();
        File file = FileUtil.toFile((FileObject)fileObject);
        SchemaInfo schemaInfo = schemaParser.parse(file.toURI().toString());
        if (schemaInfo == null) {
            return null;
        }
        return schemaInfo;
    }

    public static final class SchemaInfo {
        public final Set roots = new TreeSet();
        public String namespace;
    }
}

