/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LSResourceResolverImpl
implements LSResourceResolver {
    public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
        if (string4 == null || string4.trim().length() <= 0) {
            return null;
        }
        URI uRI = null;
        try {
            uRI = new URI(string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        FileObject fileObject = null;
        CatalogModel catalogModel = null;
        try {
            fileObject = this.getFileObject(string5);
            catalogModel = this.getResolver(fileObject);
        }
        catch (CatalogModelException catalogModelException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (catalogModel == null) {
            return null;
        }
        ModelSource modelSource = null;
        try {
            modelSource = Utilities.createModelSource(fileObject, false);
        }
        catch (CatalogModelException catalogModelException) {
            // empty catch block
        }
        ModelSource modelSource2 = null;
        try {
            modelSource2 = catalogModel.getModelSource(uRI, modelSource);
        }
        catch (CatalogModelException catalogModelException) {
            return null;
        }
        if (modelSource2 == null) {
            return null;
        }
        FileObject fileObject2 = (FileObject)modelSource2.getLookup().lookup(FileObject.class);
        if (fileObject2 == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        if (file == null) {
            return null;
        }
        URI uRI2 = file.toURI();
        DOMImplementation dOMImplementation = null;
        try {
            dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
        LSInput lSInput = dOMImplementationLS.createLSInput();
        InputStream inputStream = this.getFileStreamFromDocument(file);
        if (inputStream != null) {
            lSInput.setByteStream(inputStream);
        }
        lSInput.setSystemId(uRI2.toString());
        return lSInput;
    }

    private FileObject getFileObject(String string) throws IOException {
        if (string == null) {
            return null;
        }
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException();
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        if (uRI.isAbsolute() && uRI.getScheme().equalsIgnoreCase("file")) {
            File file = null;
            try {
                file = new File(uRI);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
            file = FileUtil.normalizeFile((File)file);
            FileObject fileObject = null;
            try {
                fileObject = FileUtil.toFileObject((File)file);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
            return fileObject;
        }
        return null;
    }

    private CatalogModel getResolver(FileObject fileObject) throws CatalogModelException {
        if (fileObject != null) {
            return CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(fileObject);
        }
        return null;
    }

    private InputStream getFileStreamFromDocument(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject != null) {
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
            if (dataObject.isModified()) {
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return null;
                }
                StyledDocument styledDocument = null;
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    return null;
                }
                if (styledDocument == null) {
                    return null;
                }
                String string = null;
                try {
                    string = styledDocument.getText(0, styledDocument.getLength());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                if (string == null) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(string.getBytes()));
                return bufferedInputStream;
            }
            return null;
        }
        return null;
    }
}

