/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.properties.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PropertyPanel
extends JPanel {
    private final Element.ItemElem element;
    private JTextField keyText;
    private JTextField valueText;
    private JTextField commentText;

    PropertyPanel() {
        this((Element.ItemElem)null);
    }

    PropertyPanel(Element.ItemElem itemElem) {
        this.element = itemElem;
        this.initComponents();
        this.initInteraction();
        this.initAccessibility();
        if (itemElem != null) {
            this.keyText.setText(itemElem.getKey());
            this.valueText.setText(itemElem.getValue());
            this.commentText.setText(itemElem.getComment());
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.keyText.getKeymap().removeKeyStrokeBinding(keyStroke);
        this.valueText.getKeymap().removeKeyStrokeBinding(keyStroke);
        this.commentText.getKeymap().removeKeyStrokeBinding(keyStroke);
        HelpCtx.setHelpIDString((JComponent)this, (String)"propfiles.adding");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACS_PropertyPanel"));
        AccessibleContext accessibleContext = this.keyText.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_CTL_KeyText"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_CTL_KeyText"));
        accessibleContext = this.valueText.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_CTL_ValueText"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_CTL_ValueText"));
        accessibleContext = this.commentText.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_CTL_CommentText"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_CTL_CommentText"));
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.keyText = new JTextField(25);
        this.valueText = new JTextField(25);
        this.commentText = new JTextField(25);
        jLabel.setLabelFor(this.keyText);
        jLabel2.setLabelFor(this.valueText);
        jLabel3.setLabelFor(this.commentText);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_KeyLabel"));
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_ValueLabel"));
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_CommentLabel"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel).add((Component)jLabel2).add((Component)jLabel3)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.keyText, -1, -2, Short.MAX_VALUE).add((Component)this.valueText, -1, -2, Short.MAX_VALUE).add((Component)this.commentText, -1, -2, Short.MAX_VALUE)).addContainerGap());
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)this.keyText, -2, -2, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.valueText, -2, -2, -2).add((Component)jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.commentText, -2, -2, -2).add((Component)jLabel3)).addContainerGap());
    }

    private void initInteraction() {
        Listener listener = new Listener();
        this.keyText.addActionListener(listener);
        this.valueText.addActionListener(listener);
        this.commentText.addActionListener(listener);
        if (this.element != null) {
            this.keyText.addFocusListener(listener);
            this.valueText.addFocusListener(listener);
            this.commentText.addFocusListener(listener);
        }
    }

    String getKey() {
        return this.keyText.getText();
    }

    String getValue() {
        return this.valueText.getText();
    }

    String getComment() {
        return this.commentText.getText();
    }

    private void workaround11364() {
        JButton jButton;
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null && (jButton = jRootPane.getDefaultButton()) != null) {
            jButton.doClick();
        }
    }

    private final class Listener
    extends FocusAdapter
    implements ActionListener {
        private Listener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.storeText(focusEvent.getSource());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.storeText(actionEvent.getSource());
            PropertyPanel.this.workaround11364();
        }

        private void storeText(Object object) {
            if (PropertyPanel.this.element != null) {
                if (object == PropertyPanel.this.keyText) {
                    PropertyPanel.this.element.getKeyElem().setValue(PropertyPanel.this.keyText.getText());
                } else if (object == PropertyPanel.this.valueText) {
                    PropertyPanel.this.element.getValueElem().setValue(PropertyPanel.this.valueText.getText());
                } else if (object == PropertyPanel.this.commentText) {
                    PropertyPanel.this.element.getCommentElem().setValue(PropertyPanel.this.commentText.getText());
                } else assert (false);
            }
        }
    }
}

