/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.olap4j.query.SelectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    protected final String name;
    protected Map<Axis, QueryAxis> axes = new HashMap<Axis, QueryAxis>();
    protected QueryAxis across;
    protected QueryAxis down;
    protected QueryAxis filter;
    protected QueryAxis unused;
    protected final Cube cube;
    protected Map<String, QueryDimension> dimensionMap = new HashMap<String, QueryDimension>();
    private final OlapConnection connection;
    private final SelectionFactory selectionFactory = new SelectionFactory(this);

    public Query(String name, Cube cube) throws SQLException {
        this.name = name;
        this.cube = cube;
        this.connection = cube.getSchema().getCatalog().getMetaData().getConnection().unwrap(OlapConnection.class);
        this.unused = new QueryAxis(this, null);
        for (Dimension dimension : cube.getDimensions()) {
            QueryDimension queryDimension = new QueryDimension(this, dimension);
            this.unused.getDimensions().add(queryDimension);
            this.dimensionMap.put(queryDimension.getName(), queryDimension);
        }
        this.across = new QueryAxis(this, Axis.COLUMNS);
        this.down = new QueryAxis(this, Axis.ROWS);
        this.filter = new QueryAxis(this, Axis.FILTER);
        this.axes.put(Axis.UNUSED, this.unused);
        this.axes.put(Axis.COLUMNS, this.across);
        this.axes.put(Axis.ROWS, this.down);
        this.axes.put(Axis.FILTER, this.filter);
    }

    public SelectNode getSelect() {
        return new Olap4jNodeConverter().toOlap4j(this);
    }

    public Cube getCube() {
        return this.cube;
    }

    public QueryDimension getDimension(String name) {
        return this.dimensionMap.get(name);
    }

    public void swapAxes() {
        if (this.axes.size() != 4) {
            throw new IllegalArgumentException();
        }
        ArrayList<QueryDimension> tmpAcross = new ArrayList<QueryDimension>();
        tmpAcross.addAll(this.across.getDimensions());
        ArrayList<QueryDimension> tmpDown = new ArrayList<QueryDimension>();
        tmpDown.addAll(this.down.getDimensions());
        this.across.getDimensions().clear();
        this.down.getDimensions().clear();
        this.across.getDimensions().addAll(tmpDown);
        this.down.getDimensions().addAll(tmpAcross);
    }

    public Map<Axis, QueryAxis> getAxes() {
        return this.axes;
    }

    public QueryAxis getunusedAxis() {
        return this.unused;
    }

    public boolean validate() throws OlapException {
        for (Dimension dimension : this.cube.getDimensions()) {
            QueryDimension queryDimension = this.getDimension(dimension.getName());
            if (queryDimension == null) {
                return false;
            }
            Member member = dimension.getDefaultHierarchy().getDefaultMember();
            if (queryDimension.getAxis() == null || queryDimension.getAxis().getLocation() == null) {
                queryDimension.getSelections().clear();
                queryDimension.getSelections().add(queryDimension.createSelection(member));
                continue;
            }
            if (queryDimension.getSelections().size() != 0) continue;
            queryDimension.getSelections().add(queryDimension.createSelection(member));
        }
        return true;
    }

    public CellSet execute() throws OlapException {
        SelectNode mdx = this.getSelect();
        OlapStatement olapStatement = this.connection.createStatement();
        return olapStatement.executeOlapQuery(mdx);
    }

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public SelectionFactory getSelectionFactory() {
        return this.selectionFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Olap4jNodeConverter {
        private Olap4jNodeConverter() {
        }

        public SelectNode toOlap4j(Query query) {
            List<IdentifierNode> list = Collections.emptyList();
            List<ParseTreeNode> withList = Collections.emptyList();
            ArrayList<QueryAxis> axisList = new ArrayList<QueryAxis>();
            axisList.add(query.getAxes().get(Axis.COLUMNS));
            axisList.add(query.getAxes().get(Axis.ROWS));
            AxisNode filterAxis = null;
            if (query.getAxes().containsKey(Axis.FILTER)) {
                QueryAxis axis = query.getAxes().get(Axis.FILTER);
                if (!axis.dimensions.isEmpty()) {
                    filterAxis = this.toOlap4j(axis);
                }
            }
            return new SelectNode(null, withList, this.toOlap4j(axisList), new CubeNode(null, query.getCube()), filterAxis, list);
        }

        private CallNode generateSetCall(ParseTreeNode ... args) {
            return new CallNode(null, "{}", Syntax.Braces, args);
        }

        private CallNode generateListSetCall(List<ParseTreeNode> cnodes) {
            return new CallNode(null, "{}", Syntax.Braces, cnodes);
        }

        private CallNode generateListTupleCall(List<ParseTreeNode> cnodes) {
            return new CallNode(null, "()", Syntax.Parentheses, cnodes);
        }

        protected CallNode getMemberSet(QueryDimension dimension) {
            return new CallNode(null, "{}", Syntax.Braces, this.toOlap4j(dimension));
        }

        protected CallNode crossJoin(QueryDimension dim1, QueryDimension dim2) {
            return new CallNode(null, "CrossJoin", Syntax.Function, this.getMemberSet(dim1), this.getMemberSet(dim2));
        }

        private AxisNode toOlap4j(QueryAxis axis) {
            CallNode callNode = null;
            int numDimensions = axis.getDimensions().size();
            if (axis.getLocation() == Axis.FILTER) {
                ArrayList<ParseTreeNode> members = new ArrayList<ParseTreeNode>();
                for (int dimNo = 0; dimNo < numDimensions; ++dimNo) {
                    QueryDimension dimension = axis.getDimensions().get(dimNo);
                    if (dimension.getSelections().size() != 1) continue;
                    members.addAll(this.toOlap4j(dimension));
                }
                callNode = this.generateListTupleCall(members);
            } else if (numDimensions == 1) {
                QueryDimension dimension = axis.getDimensions().get(0);
                List<ParseTreeNode> members = this.toOlap4j(dimension);
                callNode = this.generateListSetCall(members);
            } else if (numDimensions == 2) {
                callNode = this.crossJoin(axis.getDimensions().get(0), axis.getDimensions().get(1));
            } else {
                List<QueryDimension> dims = axis.getDimensions();
                callNode = this.getMemberSet(dims.get(dims.size() - 1));
                for (int i = dims.size() - 2; i >= 0; --i) {
                    CallNode memberSet = this.getMemberSet(dims.get(i));
                    callNode = new CallNode(null, "CrossJoin", Syntax.Function, memberSet, callNode);
                }
            }
            return new AxisNode(null, axis.isNonEmpty(), axis.getLocation(), new ArrayList<IdentifierNode>(), callNode);
        }

        private List<ParseTreeNode> toOlap4j(QueryDimension dimension) {
            ArrayList<ParseTreeNode> members = new ArrayList<ParseTreeNode>();
            for (Selection selection : dimension.getSelections()) {
                members.add(this.toOlap4j(selection));
            }
            return members;
        }

        private ParseTreeNode toOlap4j(Selection selection) {
            try {
                return this.toOlap4j(selection.getMember(), selection.getOperator());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private ParseTreeNode toOlap4j(Member member, Selection.Operator oper) {
            ParseTreeNode node = null;
            try {
                switch (oper) {
                    case MEMBER: {
                        node = new MemberNode(null, member);
                        break;
                    }
                    case SIBLINGS: {
                        node = new CallNode(null, "Siblings", Syntax.Property, new MemberNode(null, member));
                        break;
                    }
                    case CHILDREN: {
                        node = new CallNode(null, "Children", Syntax.Property, new MemberNode(null, member));
                        break;
                    }
                    case INCLUDE_CHILDREN: {
                        node = this.generateSetCall(new MemberNode(null, member), this.toOlap4j(member, Selection.Operator.CHILDREN));
                        break;
                    }
                    case DESCENDANTS: {
                        node = new CallNode(null, "Descendants", Syntax.Function, new MemberNode(null, member));
                        break;
                    }
                    case ANCESTORS: {
                        node = new CallNode(null, "Ascendants", Syntax.Function, new MemberNode(null, member));
                        break;
                    }
                    default: {
                        System.out.println("NOT IMPLEMENTED: " + (Object)((Object)oper));
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return node;
        }

        private List<AxisNode> toOlap4j(List<QueryAxis> axes) {
            ArrayList<AxisNode> axisList = new ArrayList<AxisNode>();
            for (QueryAxis axis : axes) {
                axisList.add(this.toOlap4j(axis));
            }
            return axisList;
        }
    }
}

