/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.Util;
import mondrian.test.DiffRepository;
import mondrian.test.TestContext;
import mondrian.tui.MockHttpServletRequest;
import mondrian.tui.MockHttpServletResponse;
import mondrian.tui.XmlUtil;
import mondrian.tui.XmlaSupport;
import mondrian.xmla.XmlaBaseTestCase;
import mondrian.xmla.XmlaRequestCallback;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaExcel2000Test
extends XmlaBaseTestCase {
    private static final boolean DEBUG = false;

    public XmlaExcel2000Test() {
    }

    public XmlaExcel2000Test(String name) {
        super(name);
    }

    protected String getOutFileName(String nos) {
        return "excel_2000_" + nos + "_out.xml";
    }

    @Override
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(XmlaExcel2000Test.class);
    }

    @Override
    protected Class<? extends XmlaRequestCallback> getServletCallbackClass() {
        return Callback.class;
    }

    protected String generateExpectedString(String nos, Properties props) throws Exception {
        String expectedFileName = this.getOutFileName(nos);
        String expectedStr = this.fileToString(expectedFileName);
        if (props != null) {
            String sessionId = this.getSessionId(XmlaBaseTestCase.Action.QUERY);
            if (sessionId != null) {
                props.put("session.id", sessionId);
            }
            expectedStr = Util.replaceProperties(expectedStr, Util.toMap(props));
        }
        return expectedStr;
    }

    public void test01() throws Exception {
        this.helperTest("01", false);
    }

    public void test02() throws Exception {
        this.helperTest("02", false);
    }

    public void test03() throws Exception {
        this.helperTest("03", true);
    }

    public void test04() throws Exception {
        this.helperTest("04", true);
    }

    public void test05() throws Exception {
        this.helperTest("05", true);
    }

    public void test06() throws Exception {
        this.helperTest("06", true);
    }

    public void test07() throws Exception {
        this.helperTest("07", false);
    }

    public void test08() throws Exception {
        this.helperTest("08", true);
    }

    public void test09() throws Exception {
        this.helperTest("09", true);
    }

    public void test10() throws Exception {
        this.helperTest("10", true);
    }

    public void test11() throws Exception {
        this.helperTest("11", true);
    }

    public void test12() throws Exception {
        this.helperTest("12", true);
    }

    public void test13() throws Exception {
        this.helperTest("13", true);
    }

    public void test14() throws Exception {
        this.helperTest("14", true);
    }

    public void test15() throws Exception {
        this.helperTest("15", true);
    }

    public void test16() throws Exception {
        this.helperTest("16", true);
    }

    public void test17() throws Exception {
        this.helperTest("17", true);
    }

    public void test18() throws Exception {
        this.helperTest("18", true);
    }

    protected void helperTest(String nos, boolean doSessionId) throws Exception {
        if (doSessionId) {
            Util.discard((Object)this.getSessionId(XmlaBaseTestCase.Action.CREATE));
        }
        Properties props = new Properties();
        this.doTest(nos, props);
    }

    public void testExpect01() throws Exception {
        this.helperTestExpect("01", false);
    }

    public void testExpect02() throws Exception {
        this.helperTestExpect("02", false);
    }

    public void testExpect03() throws Exception {
        this.helperTestExpect("03", true);
    }

    public void testExpect04() throws Exception {
        this.helperTestExpect("04", true);
    }

    public void testExpect05() throws Exception {
        this.helperTestExpect("05", true);
    }

    public void testExpect06() throws Exception {
        this.helperTestExpect("06", true);
    }

    protected void helperTestExpect(String nos, boolean doSessionId) throws Exception {
        if (doSessionId) {
            Util.discard((Object)this.getSessionId(XmlaBaseTestCase.Action.CREATE));
        }
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setMethod("POST");
        req.setContentType("text/xml");
        req.setHeader("Expect", "100-continue");
        Properties props = new Properties();
        this.doTest(req, nos, props);
    }

    public void doTest(MockHttpServletRequest req, String nos, Properties props) throws Exception {
        String requestText = this.generateRequestString(nos, props);
        MockHttpServletResponse res = new MockHttpServletResponse();
        res.setCharacterEncoding("UTF-8");
        Servlet servlet = this.getServlet(this.getTestContext());
        servlet.service((ServletRequest)req, (ServletResponse)res);
        int statusCode = res.getStatusCode();
        if (statusCode == 200) {
            byte[] bytes = res.toByteArray();
            String expectedStr = this.generateExpectedString(nos, props);
            Document expectedDoc = XmlUtil.parseString(expectedStr);
            this.validate(bytes, expectedDoc);
        } else if (statusCode == 100) {
            req.clearHeader("Expect");
            req.setBodyContent(requestText);
            servlet.service((ServletRequest)req, (ServletResponse)res);
            statusCode = res.getStatusCode();
            if (statusCode == 200) {
                byte[] bytes = res.toByteArray();
                String expectedStr = this.generateExpectedString(nos, props);
                Document expectedDoc = XmlUtil.parseString(expectedStr);
                this.validate(bytes, expectedDoc);
            } else {
                XmlaExcel2000Test.fail((String)("Bad status code: " + statusCode));
            }
        } else {
            XmlaExcel2000Test.fail((String)("Bad status code: " + statusCode));
        }
    }

    public void doTest(String nos, Properties props) throws Exception {
        String requestText = this.generateRequestString(nos, props);
        Document reqDoc = XmlUtil.parseString(requestText);
        Servlet servlet = this.getServlet(this.getTestContext());
        byte[] bytes = XmlaSupport.processSoapXmla(reqDoc, servlet);
        String expectedStr = this.generateExpectedString(nos, props);
        Document expectedDoc = XmlUtil.parseString(expectedStr);
        this.validate(bytes, expectedDoc);
    }

    protected void validate(byte[] bytes, Document expectedDoc) throws Exception {
        if (!XmlUtil.supportsValidation() || XmlaSupport.validateSoapXmlaUsingXpath(bytes)) {
            // empty if block
        }
        Document gotDoc = XmlUtil.parse(bytes);
        String gotStr = XmlUtil.toString(this.replaceLastSchemaUpdateDate(gotDoc), true);
        String expectedStr = XmlUtil.toString(this.replaceLastSchemaUpdateDate(expectedDoc), true);
        gotStr = Util.maskVersion(gotStr);
        gotStr = TestContext.instance().upgradeActual(gotStr);
        XMLAssert.assertXMLEqual((String)expectedStr, (String)gotStr);
    }

    @Override
    protected String getSessionId(XmlaBaseTestCase.Action action) {
        return XmlaExcel2000Test.getSessionId("XmlaExcel2000Test", action);
    }

    protected String generateRequestString(String nos, Properties props) throws Exception {
        String reqFileName = "excel_2000_" + nos + "_in.xml";
        String requestText = this.fileToString(reqFileName);
        if (props != null) {
            String sessionId = this.getSessionId(XmlaBaseTestCase.Action.QUERY);
            if (sessionId != null) {
                props.put("session.id", sessionId);
            }
            requestText = Util.replaceProperties(requestText, Util.toMap(props));
        }
        return requestText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Callback
    implements XmlaRequestCallback {
        static final String MY_SESSION_ID = "my_session_id";

        Callback() {
        }

        @Override
        public void init(ServletConfig servletConfig) throws ServletException {
        }

        @Override
        public boolean processHttpHeader(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws Exception {
            String expect = request.getHeader("Expect");
            if (expect != null && expect.equalsIgnoreCase("100-continue")) {
                XmlaRequestCallback.Helper.generatedExpectResponse(request, response, context);
                return false;
            }
            return true;
        }

        @Override
        public void preAction(HttpServletRequest request, Element[] requestSoapParts, Map<String, Object> context) throws Exception {
        }

        private void setSessionId(Map<String, Object> context) {
            context.put(MY_SESSION_ID, XmlaBaseTestCase.getSessionId("XmlaExcel2000Test", XmlaBaseTestCase.Action.CREATE));
        }

        @Override
        public String generateSessionId(Map<String, Object> context) {
            this.setSessionId(context);
            return (String)context.get(MY_SESSION_ID);
        }

        @Override
        public void postAction(HttpServletRequest request, HttpServletResponse response, byte[][] responseSoapParts, Map<String, Object> context) throws Exception {
        }
    }
}

