/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.util.Properties;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Schema;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.test.DiffRepository;
import mondrian.test.TestContext;
import mondrian.tui.XmlUtil;
import mondrian.xmla.Enumeration;
import mondrian.xmla.XmlaBaseTestCase;
import mondrian.xmla.XmlaRequestCallback;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaBasicTest
extends XmlaBaseTestCase {
    public static final String FORMAT_TABLULAR = "Tabular";
    public static final String UNIQUE_NAME_ELEMENT = "unique.name.element";
    public static final String UNIQUE_NAME_PROP = "unique.name";
    public static final String RESTRICTION_NAME_PROP = "restriction.name";
    public static final String RESTRICTION_VALUE_PROP = "restriction.value";
    public static final String CONTENT_PROP = "content";
    public static final String CONTENT_NONE = Enumeration.Content.None.name();
    public static final String CONTENT_DATA = Enumeration.Content.Data.name();
    public static final String CONTENT_SCHEMA = Enumeration.Content.Schema.name();
    public static final String CONTENT_SCHEMADATA = Enumeration.Content.SchemaData.name();

    public XmlaBasicTest() {
    }

    public XmlaBasicTest(String name) {
        super(name);
    }

    @Override
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(XmlaBasicTest.class);
    }

    @Override
    protected Class<? extends XmlaRequestCallback> getServletCallbackClass() {
        return null;
    }

    protected String extractSoapResponse(Document responseDoc, Enumeration.Content content) {
        Document partialDoc = null;
        switch (content) {
            case None: {
                break;
            }
            case Schema: {
                break;
            }
            case Data: {
                break;
            }
            case SchemaData: {
                partialDoc = responseDoc;
            }
        }
        String responseText = XmlUtil.toString(responseDoc, false);
        return responseText;
    }

    public void testDDatasource() throws Exception {
        String requestType = "DISCOVER_DATASOURCES";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testDEnumerators() throws Exception {
        String requestType = "DISCOVER_ENUMERATORS";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testDKeywords() throws Exception {
        String requestType = "DISCOVER_KEYWORDS";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testDLiterals() throws Exception {
        String requestType = "DISCOVER_LITERALS";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testDProperties() throws Exception {
        String requestType = "DISCOVER_PROPERTIES";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testDSchemaRowsets() throws Exception {
        String requestType = "DISCOVER_SCHEMA_ROWSETS";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testDBCatalogs() throws Exception {
        String requestType = "DBSCHEMA_CATALOGS";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testDBSchemata() throws Exception {
        String requestType = "DBSCHEMA_SCHEMATA";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void _testDBColumns() throws Exception {
        String requestType = "DBSCHEMA_COLUMNS";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void _testDBProviderTypes() throws Exception {
        String requestType = "DBSCHEMA_PROVIDER_TYPES";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void _testDBTablesInfo() throws Exception {
        String requestType = "DBSCHEMA_TABLES_INFO";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testDBTables() throws Exception {
        String requestType = "DBSCHEMA_TABLES";
        this.doTestRT(requestType, TestContext.instance());
    }

    public void testMDActions() throws Exception {
        String requestType = "MDSCHEMA_ACTIONS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("data.source.info", "MondrianFoodMart");
        props.setProperty("catalog", "FoodMart");
        props.setProperty("format", FORMAT_TABLULAR);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDCubes() throws Exception {
        String requestType = "MDSCHEMA_CUBES";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("data.source.info", "MondrianFoodMart");
        props.setProperty("catalog", "FoodMart");
        props.setProperty("format", FORMAT_TABLULAR);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDSets() throws Exception {
        String requestType = "MDSCHEMA_SETS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("data.source.info", "MondrianFoodMart");
        props.setProperty("catalog", "FoodMart");
        props.setProperty("format", FORMAT_TABLULAR);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDimensions() throws Exception {
        String requestType = "MDSCHEMA_DIMENSIONS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("data.source.info", "MondrianFoodMart");
        props.setProperty("catalog", "FoodMart");
        props.setProperty("format", FORMAT_TABLULAR);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDFunction() throws Exception {
        String requestType = "MDSCHEMA_FUNCTIONS";
        String restrictionName = "FUNCTION_NAME";
        String restrictionValue = "Item";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty(RESTRICTION_NAME_PROP, restrictionName);
        props.setProperty(RESTRICTION_VALUE_PROP, restrictionValue);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDFunctions() throws Exception {
        if (Util.PreJdk15 || Util.Retrowoven) {
            return;
        }
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        String requestType = "MDSCHEMA_FUNCTIONS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDFunctionsJdk14() throws Exception {
        if (!Util.PreJdk15 && !Util.Retrowoven) {
            return;
        }
        String requestType = "MDSCHEMA_FUNCTIONS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDHierarchies() throws Exception {
        String requestType = "MDSCHEMA_HIERARCHIES";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDLevels() throws Exception {
        String requestType = "MDSCHEMA_LEVELS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty(UNIQUE_NAME_PROP, "[Customers]");
        props.setProperty(UNIQUE_NAME_ELEMENT, "DIMENSION_UNIQUE_NAME");
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDLevelsAccessControlled() throws Exception {
        String requestType = "MDSCHEMA_LEVELS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty(UNIQUE_NAME_PROP, "[Customers]");
        props.setProperty(UNIQUE_NAME_ELEMENT, "DIMENSION_UNIQUE_NAME");
        props.setProperty("data.source.info", "MondrianFoodMart");
        TestContext testContext = TestContext.instance().withRole("California manager");
        this.doTest(requestType, props, testContext);
    }

    public void testMDMeasures() throws Exception {
        String requestType = "MDSCHEMA_MEASURES";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty(UNIQUE_NAME_PROP, "[Customers]");
        props.setProperty(UNIQUE_NAME_ELEMENT, "MEASURE_UNIQUE_NAME");
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDMembers() throws Exception {
        String requestType = "MDSCHEMA_MEMBERS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty(UNIQUE_NAME_PROP, "[Gender]");
        props.setProperty(UNIQUE_NAME_ELEMENT, "HIERARCHY_UNIQUE_NAME");
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDMembersMulti() throws Exception {
        String requestType = "MDSCHEMA_MEMBERS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDMembersTreeop() throws Exception {
        String requestType = "MDSCHEMA_MEMBERS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testMDProperties() throws Exception {
        String requestType = "MDSCHEMA_PROPERTIES";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testApproxRowCountOverridesCountCallsToDatabase() throws Exception {
        String requestType = "MDSCHEMA_LEVELS";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty(UNIQUE_NAME_PROP, "[Marital Status]");
        props.setProperty(UNIQUE_NAME_ELEMENT, "DIMENSION_UNIQUE_NAME");
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testApproxRowCountInHierarchyOverridesCountCallsToDatabase() throws Exception {
        String requestType = "MDSCHEMA_HIERARCHIES";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty(UNIQUE_NAME_PROP, "[Marital Status]");
        props.setProperty(UNIQUE_NAME_ELEMENT, "DIMENSION_UNIQUE_NAME");
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testDrillThroughMaxRows() throws Exception {
        if (!MondrianProperties.instance().EnableTotalCount.booleanValue()) {
            return;
        }
        String requestType = "EXECUTE";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testDrillThrough() throws Exception {
        if (!MondrianProperties.instance().EnableTotalCount.booleanValue()) {
            return;
        }
        String requestType = "EXECUTE";
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("catalog", "FoodMart");
        props.setProperty("catalog.name", "FoodMart");
        props.setProperty("cube.name", "Sales");
        props.setProperty("format", FORMAT_TABLULAR);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, TestContext.instance());
    }

    @Override
    protected String filter(String testCaseName, String filename, String content) {
        if (testCaseName.startsWith("testDrillThrough") && filename.equals("${response}")) {
            Dialect dialect = TestContext.instance().getDialect();
            switch (dialect.getDatabaseProduct()) {
                case ORACLE: {
                    content = Util.replace(content, " type=\"xsd:double\"", " type=\"xsd:decimal\"");
                    content = Util.replace(content, " type=\"xsd:integer\"", " type=\"xsd:decimal\"");
                    break;
                }
                case POSTGRESQL: {
                    content = Util.replace(content, " sql:field=\"Store Sqft\" type=\"xsd:double\"", " sql:field=\"Store Sqft\" type=\"xsd:integer\"");
                    content = Util.replace(content, " sql:field=\"Unit Sales\" type=\"xsd:double\"", " sql:field=\"Unit Sales\" type=\"xsd:decimal\"");
                    break;
                }
                case MYSQL: 
                case INFOBRIGHT: 
                case DERBY: 
                case TERADATA: 
                case NETEZZA: {
                    content = Util.replace(content, " sql:field=\"Store Sqft\" type=\"xsd:double\"", " sql:field=\"Store Sqft\" type=\"xsd:integer\"");
                    content = Util.replace(content, " sql:field=\"Unit Sales\" type=\"xsd:double\"", " sql:field=\"Unit Sales\" type=\"xsd:string\"");
                    break;
                }
            }
        }
        return content;
    }

    public void testExecuteSlicer() throws Exception {
        String requestType = "EXECUTE";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testExecuteWithoutCellProperties() throws Exception {
        String requestType = "EXECUTE";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testExecuteWithCellProperties() throws Exception {
        String requestType = "EXECUTE";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testExecuteWithMemberKeyDimensionPropertyForMemberWithoutKey() throws Exception {
        String requestType = "EXECUTE";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testExecuteWithMemberKeyDimensionPropertyForMemberWithKey() throws Exception {
        String requestType = "EXECUTE";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testExecuteWithMemberKeyDimensionPropertyForAllMember() throws Exception {
        String requestType = "EXECUTE";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testExecuteWithKeyDimensionProperty() throws Exception {
        String requestType = "EXECUTE";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testExecuteWithDimensionProperties() throws Exception {
        String requestType = "EXECUTE";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTest(requestType, props, TestContext.instance());
    }

    public void testExecuteCrossjoin() throws Exception {
        String requestType = "EXECUTE";
        String query = "SELECT CrossJoin({[Product].[All Products].children}, {[Customers].[All Customers].children}) ON columns FROM Sales";
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope\n    xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <soapenv:Body>\n        <Execute xmlns=\"urn:schemas-microsoft-com:xml-analysis\">\n        <Command>\n        <Statement>\n" + query + "\n" + "         </Statement>\n" + "        </Command>\n" + "        <Properties>\n" + "          <PropertyList>\n" + "            <Catalog>${catalog}</Catalog>\n" + "            <DataSourceInfo>${data.source.info}</DataSourceInfo>\n" + "            <Format>${format}</Format>\n" + "            <AxisFormat>TupleFormat</AxisFormat>\n" + "          </PropertyList>\n" + "        </Properties>\n" + "</Execute>\n" + "</soapenv:Body>\n" + "</soapenv:Envelope>";
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTestInline(requestType, request, "${response}", props, TestContext.instance());
    }

    public void testExecuteCrossjoinRole() throws Exception {
        String requestType = "EXECUTE";
        String query = "SELECT CrossJoin({[Product].[All Products].children}, {[Customers].[All Customers].children}) ON columns FROM Sales";
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soapenv:Envelope\n    xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"\n    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <soapenv:Body>\n        <Execute xmlns=\"urn:schemas-microsoft-com:xml-analysis\">\n        <Command>\n        <Statement>\n" + query + "\n" + "         </Statement>\n" + "        </Command>\n" + "        <Properties>\n" + "          <PropertyList>\n" + "            <Catalog>${catalog}</Catalog>\n" + "            <DataSourceInfo>${data.source.info}</DataSourceInfo>\n" + "            <Format>${format}</Format>\n" + "            <AxisFormat>TupleFormat</AxisFormat>\n" + "          </PropertyList>\n" + "        </Properties>\n" + "</Execute>\n" + "</soapenv:Body>\n" + "</soapenv:Envelope>";
        class RR
        implements Role {
            public Access getAccess(Cube cube) {
                return Access.ALL;
            }

            public Access getAccess(NamedSet set) {
                return Access.ALL;
            }

            public boolean canAccess(OlapElement olapElement) {
                return true;
            }

            public Access getAccess(Schema schema) {
                return Access.ALL;
            }

            public Access getAccess(Dimension dimension) {
                return Access.ALL;
            }

            public Access getAccess(Hierarchy hierarchy) {
                String mname = "[Customers]";
                if (hierarchy.getUniqueName().equals(mname)) {
                    return Access.CUSTOM;
                }
                return Access.ALL;
            }

            public Role.HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
                String hname = "[Customers]";
                if (hierarchy.getUniqueName().equals(hname)) {
                    return new Role.HierarchyAccess(){

                        public Access getAccess(Member member) {
                            String mname = "[Customers].[All Customers].[Mexico]";
                            if (member.getUniqueName().equals(mname)) {
                                return Access.NONE;
                            }
                            return Access.ALL;
                        }

                        public int getTopLevelDepth() {
                            return 0;
                        }

                        public int getBottomLevelDepth() {
                            return 4;
                        }

                        public Role.RollupPolicy getRollupPolicy() {
                            return Role.RollupPolicy.FULL;
                        }

                        public boolean hasInaccessibleDescendants(Member member) {
                            return false;
                        }
                    };
                }
                return RoleImpl.createAllAccess(hierarchy);
            }

            public Access getAccess(Level level) {
                return Access.ALL;
            }

            public Access getAccess(Member member) {
                String mname = "[Customers].[All Customers]";
                if (member.getUniqueName().equals(mname)) {
                    return Access.ALL;
                }
                return Access.ALL;
            }
        }
        RR role = new RR();
        Properties props = this.getDefaultRequestProperties(requestType);
        this.doTestInline(requestType, request, "${response}", props, TestContext.instance(), role);
    }

    public void doTestRT(String requestType, TestContext testContext) throws Exception {
        Properties props = new Properties();
        props.setProperty("request.type", requestType);
        props.setProperty("data.source.info", "MondrianFoodMart");
        this.doTest(requestType, props, testContext);
    }

    @Override
    protected String getSessionId(XmlaBaseTestCase.Action action) {
        throw new UnsupportedOperationException();
    }
}

