/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.nio.charset.Charset;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SpecialSearchGroup;
import org.openide.LifecycleManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SearchTask
implements Runnable,
Cancellable {
    private final SearchScope searchScope;
    private final List<SearchType> customizedSearchTypes;
    private final BasicSearchCriteria basicSearchCriteria;
    private ResultModel resultModel;
    private SpecialSearchGroup searchGroup;
    private boolean notifyWhenFinished = true;
    private volatile boolean interrupted = false;
    private volatile boolean finished = false;
    private final String replaceString;

    public SearchTask(SearchScope searchScope, BasicSearchCriteria basicSearchCriteria, List<SearchType> list) {
        this.searchScope = searchScope;
        this.basicSearchCriteria = basicSearchCriteria;
        this.customizedSearchTypes = list;
        this.replaceString = basicSearchCriteria != null ? basicSearchCriteria.getReplaceExpr() : null;
    }

    private boolean isSearchAndReplace() {
        return this.replaceString != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isSearchAndReplace()) {
            LifecycleManager.getDefault().saveAll();
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"), (Cancellable)this);
        progressHandle.start();
        this.ensureResultModelExists();
        if (this.searchGroup == null) {
            return;
        }
        this.searchGroup.setListeningSearchTask(this);
        try {
            this.searchGroup.search();
        }
        catch (RuntimeException runtimeException) {
            this.resultModel.searchException(runtimeException);
            runtimeException.printStackTrace();
        }
        finally {
            this.searchGroup.setListeningSearchTask(null);
            this.finished = true;
            progressHandle.finish();
        }
    }

    SearchTask createNewGeneration() {
        return new SearchTask(this.searchScope, this.basicSearchCriteria, this.customizedSearchTypes);
    }

    ResultModel getResultModel() {
        this.ensureResultModelExists();
        return this.resultModel;
    }

    private void ensureResultModelExists() {
        if (this.resultModel == null) {
            this.searchGroup = new SpecialSearchGroup(this.basicSearchCriteria, this.customizedSearchTypes, this.searchScope);
            this.resultModel = new ResultModel(this.searchGroup, this.replaceString);
        }
    }

    void matchingObjectFound(Object object, Charset charset) {
        boolean bl = this.resultModel.objectFound(object, charset);
        if (!bl) {
            this.searchGroup.stopSearch();
        }
    }

    void stop(boolean bl) {
        if (!bl) {
            this.notifyWhenFinished = bl;
        }
        this.stop();
    }

    void stop() {
        if (!this.finished) {
            this.interrupted = true;
        }
        if (this.searchGroup != null) {
            this.searchGroup.stopSearch();
        }
    }

    public boolean cancel() {
        this.stop();
        return true;
    }

    boolean notifyWhenFinished() {
        return this.notifyWhenFinished;
    }

    boolean wasInterrupted() {
        return this.interrupted;
    }
}

