/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.dnd;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.outline.OutlineTopComponent;
import com.jaspersoft.ireport.designer.palette.PaletteItem;
import com.jaspersoft.ireport.designer.palette.PaletteUtils;
import com.jaspersoft.ireport.designer.palette.actions.CreateDetailTextFieldsForFieldsAction;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

class DesignerDropTargetListener
implements DropTargetListener {
    DesignerDropTargetListener() {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.acceptDataFlavor(dtde)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(3);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this.dragEnter(dtde);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        if (dtde.isDataFlavorSupported(PaletteUtils.PALETTE_ITEM_DATA_FLAVOR)) {
            PaletteItem paletteItem = null;
            try {
                paletteItem = (PaletteItem)dtde.getTransferable().getTransferData(PaletteUtils.PALETTE_ITEM_DATA_FLAVOR);
                paletteItem.drop(dtde);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
            }
        } else if (dtde.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                PaletteItem paletteItem;
                MultiTransferObject mto = (MultiTransferObject)dtde.getTransferable().getTransferData(ExTransferable.multiFlavor);
                ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>();
                int count = mto.getCount();
                for (int i = 0; i < count; ++i) {
                    paletteItem = null;
                    paletteItem = (PaletteItem)mto.getTransferData(i, PaletteUtils.PALETTE_ITEM_DATA_FLAVOR);
                    fields.add((JRDesignField)paletteItem.getData());
                }
                if (fields.size() > 0) {
                    Properties properties = new Properties();
                    properties.setProperty("action", CreateDetailTextFieldsForFieldsAction.class.getName());
                    paletteItem = new PaletteItem(properties);
                    paletteItem.setData(fields);
                    paletteItem.drop(dtde);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean acceptDataFlavor(DropTargetDragEvent dtde) {
        if (!this.isInDocument(dtde.getLocation())) {
            return false;
        }
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor dataFlavor = flavors[i];
            if (dataFlavor.match(PaletteUtils.PALETTE_ITEM_DATA_FLAVOR)) {
                return true;
            }
            if (!dataFlavor.match(ExTransferable.multiFlavor)) continue;
            try {
                MultiTransferObject mto = (MultiTransferObject)dtde.getTransferable().getTransferData(ExTransferable.multiFlavor);
                if (!mto.areDataFlavorsSupported(new DataFlavor[]{PaletteUtils.PALETTE_ITEM_DATA_FLAVOR})) continue;
                if (!this.isInDetailBand(dtde.getLocation())) {
                    return false;
                }
                int count = mto.getCount();
                for (int k = 0; k < count; ++k) {
                    try {
                        PaletteItem paletteItem = null;
                        paletteItem = (PaletteItem)mto.getTransferData(k, PaletteUtils.PALETTE_ITEM_DATA_FLAVOR);
                        if (paletteItem.getData() instanceof JRDesignField) continue;
                        return false;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    catch (UnsupportedFlavorException ex) {
                        ex.printStackTrace();
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean isInDocument(Point location) {
        AbstractReportObjectScene scene = OutlineTopComponent.getDefault().getCurrentJrxmlVisualView().getReportDesignerPanel().getActiveScene();
        if (scene != null && scene instanceof AbstractReportObjectScene) {
            return scene.acceptDropAt(location);
        }
        return false;
    }

    private boolean isInDetailBand(Point location) {
        Point p;
        JasperDesign jd;
        JRDesignBand band;
        AbstractReportObjectScene scene = OutlineTopComponent.getDefault().getCurrentJrxmlVisualView().getReportDesignerPanel().getActiveScene();
        return scene != null && scene instanceof ReportObjectScene && (band = ModelUtils.getBandAt(jd = ((ReportObjectScene)scene).getJasperDesign(), p = scene.convertViewToScene(location))) != null && band.getOrigin().getBandTypeValue().equals((Object)BandTypeEnum.DETAIL);
    }
}

