/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.borders;

import com.jaspersoft.ireport.designer.utils.Java2DUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.Widget;

public final class SimpleLineBorder
implements Border {
    private Widget widget = null;
    public static Color COLOR_1 = new Color(192, 192, 192, 128);
    public static final Insets INSETS = new Insets(0, 0, 0, 0);

    public Insets getInsets() {
        return INSETS;
    }

    public SimpleLineBorder() {
    }

    public SimpleLineBorder(Widget w) {
        this.widget = w;
    }

    public void paint(Graphics2D gr, Rectangle bounds) {
        Stroke oldStroke = gr.getStroke();
        Stroke bs = new BasicStroke(1.0f);
        if (this.getWidget() != null && this.getWidget().getScene() != null) {
            double zoom = this.getWidget().getScene().getZoomFactor();
            bs = Java2DUtils.getInvertedZoomedStroke(bs, zoom);
        }
        gr.setStroke(bs);
        gr.setPaint(COLOR_1);
        Rectangle2D.Double r = new Rectangle2D.Double((double)(bounds.x + SimpleLineBorder.INSETS.left) + 0.5, (double)(bounds.y + SimpleLineBorder.INSETS.top) + 0.5, (double)(bounds.width - SimpleLineBorder.INSETS.left - SimpleLineBorder.INSETS.right) - 1.0, (double)(bounds.height - SimpleLineBorder.INSETS.top - SimpleLineBorder.INSETS.bottom) - 1.0);
        gr.draw(r);
        gr.setStroke(oldStroke);
    }

    public boolean isOpaque() {
        return false;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public void setWidget(Widget widget) {
        this.widget = widget;
    }
}

