/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.visitor.ChildVisitor;
import org.netbeans.modules.xml.xdm.visitor.HashNamespaceResolver;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathFinder
extends ChildVisitor {
    private boolean done = false;
    private Node currentParent = null;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Map<String, String> prefixes = new HashMap<String, String>();
    private List<XPathSegment> tokens;
    private StringBuffer fixedUpXpath = new StringBuffer();
    public static final String SEP = "/";
    public static final String AT = "@";
    public static final String COLON = ":";
    public static final String BRACKET0 = "[";
    public static final String BRACKET1 = "]";
    public static final String XPNS = "xpns";
    private int countNamespaceSuffix = 0;

    public static String getXpath(Document document, Node node) {
        if (!(node instanceof Element) && !(node instanceof Attribute)) {
            throw new IllegalArgumentException("Can only get XPath expression for Element or Attribute");
        }
        List<Node> list = new PathFromRootVisitor().findPath(document, node);
        StringBuffer stringBuffer = new StringBuffer(128);
        Element element = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            Node node2 = list.get(i);
            boolean bl = node2 instanceof Element;
            boolean bl2 = node2 instanceof Attribute;
            if (!bl && !bl2) continue;
            stringBuffer.append(SEP);
            int n = bl ? XPathFinder.xpathIndexOf(element, (Element)node2) : -1;
            String string = node2.getPrefix();
            String string2 = node2.lookupNamespaceURI(string);
            if (bl2) {
                stringBuffer.append(AT);
            }
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append(':');
            }
            stringBuffer.append(node2.getLocalName());
            if (bl && n > 0) {
                stringBuffer.append(BRACKET0);
                stringBuffer.append(String.valueOf(n));
                stringBuffer.append(BRACKET1);
            }
            if (bl2) break;
            element = (Element)node2;
        }
        return stringBuffer.toString();
    }

    public Node findNode(Document document, String string) {
        List<Node> list = this.findNodes(document, string);
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<Node> findNodes(Document document, String string) {
        if (document == null || document.getDocumentElement() == null) {
            return Collections.emptyList();
        }
        this.init(document, string);
        if (!this.isReadyForEvaluation()) {
            return new ArrayList<Node>();
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(this.getNamespaceContext());
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPath.evaluate(this.getFixedUpXpath(), document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException.getCause().getLocalizedMessage());
        }
        assert (nodeList != null);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add((Node)nodeList.item(i));
        }
        return arrayList;
    }

    private static int xpathIndexOf(Node node, Element element) {
        assert (element != null);
        if (!(node instanceof Element) && !(node instanceof Document)) {
            return -1;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            if (string != null && !string.equals(element2.getNamespaceURI()) || string == null && element2.getNamespaceURI() != null) continue;
            if (string2.equals(element2.getLocalName())) {
                ++n;
            }
            if (element2.getId() != element.getId()) continue;
            return n;
        }
        return -1;
    }

    private void init(Document document, String string) {
        this.currentParent = document;
        this.initTokens(string);
        ((Element)document.getDocumentElement()).accept(this);
    }

    private void initTokens(String string) {
        this.tokens = new ArrayList<XPathSegment>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEP);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.tokens.add(new XPathSegment(string2));
        }
    }

    @Override
    protected void visitNode(Node node) {
        if (this.tokens.size() == 0) {
            this.done = true;
            return;
        }
        XPathSegment xPathSegment = this.tokens.get(0);
        if (!xPathSegment.checkTypeAndName(node, this.currentParent)) {
            return;
        }
        String string = node.getNamespaceURI();
        if (string != null) {
            String string2 = xPathSegment.getPrefix();
            if (string2.length() > 0) {
                String string3 = node.lookupNamespaceURI(string2);
                if (string3 == null) {
                    string3 = this.namespaces.get(string2);
                }
                if (string3 != null && !string.equals(string3)) {
                    return;
                }
                xPathSegment.addToXpath(this.fixedUpXpath);
            } else {
                string2 = this.prefixes.get(string);
                if (string2 == null) {
                    string2 = XPNS + String.valueOf(this.countNamespaceSuffix++);
                }
                xPathSegment.addToXpath(this.fixedUpXpath, string2);
            }
            this.prefixes.put(string, string2);
            this.namespaces.put(string2, string);
        } else {
            xPathSegment.addToXpath(this.fixedUpXpath);
        }
        this.tokens.remove(0);
        this.currentParent = node;
        super.visitNode(node);
    }

    public boolean isReadyForEvaluation() {
        return this.done;
    }

    public NamespaceContext getNamespaceContext() {
        return new HashNamespaceResolver(this.namespaces, this.prefixes);
    }

    private String getFixedUpXpath() {
        return this.fixedUpXpath.toString();
    }

    private static class XPathSegment {
        private final String token;
        private String prefix;
        private String localPart;
        int index = -1;
        private String remaining;
        private boolean isAttribute;
        private boolean hasConditions;

        XPathSegment(String string) {
            this.token = string;
            this.parse();
        }

        private void parse() {
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer(this.token, ":[");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                arrayList.add(string);
            }
            if (arrayList.size() == 1) {
                this.prefix = "";
                this.localPart = (String)arrayList.get(0);
                this.remaining = "";
            } else if (arrayList.size() == 3) {
                this.prefix = (String)arrayList.get(0);
                this.localPart = (String)arrayList.get(1);
                this.remaining = (String)arrayList.get(2);
            } else if (arrayList.size() == 2) {
                string = (String)arrayList.get(0);
                if (this.token.charAt(string.length()) == ':') {
                    this.prefix = string;
                    this.localPart = (String)arrayList.get(1);
                    this.remaining = "";
                } else {
                    this.localPart = (String)arrayList.get(0);
                    this.remaining = (String)arrayList.get(1);
                    this.prefix = "";
                }
            }
            if (this.prefix != null && this.prefix.startsWith(XPathFinder.AT)) {
                this.isAttribute = true;
                this.prefix = this.prefix.substring(1);
            } else if (this.localPart.startsWith(XPathFinder.AT)) {
                this.isAttribute = true;
                this.localPart = this.localPart.substring(1);
            }
            if (!this.remaining.equals("")) {
                string = this.remaining.substring(0, this.remaining.length() - 1);
                try {
                    this.index = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.hasConditions = true;
                }
                this.remaining = XPathFinder.BRACKET0 + this.remaining;
            }
        }

        public boolean checkTypeAndName(Node node, Node node2) {
            if (node instanceof Element) {
                if (this.isAttribute()) {
                    return false;
                }
                if (this.hasPlainIndex() && this.getIndex() != XPathFinder.xpathIndexOf(node2, (Element)node)) {
                    return false;
                }
            } else if (node instanceof Attribute) {
                if (!this.isAttribute()) {
                    return false;
                }
            } else {
                return false;
            }
            return node.getLocalName().equals(this.getLocalPart());
        }

        public void addToXpath(StringBuffer stringBuffer, String string) {
            stringBuffer.append(XPathFinder.SEP);
            if (this.isAttribute()) {
                stringBuffer.append(XPathFinder.AT);
            }
            stringBuffer.append(string);
            stringBuffer.append(XPathFinder.COLON);
            stringBuffer.append(this.localPart);
            if (this.hasConditions() && !string.startsWith(XPathFinder.XPNS)) {
                String string2 = XPathFinder.AT + string + XPathFinder.COLON;
                stringBuffer.append(this.remaining.replaceAll(XPathFinder.AT, string2));
            } else {
                stringBuffer.append(this.remaining);
            }
        }

        public void addToXpath(StringBuffer stringBuffer) {
            stringBuffer.append(XPathFinder.SEP);
            stringBuffer.append(this.token);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        public boolean hasPlainIndex() {
            return this.index > -1;
        }

        public boolean hasConditions() {
            return this.hasConditions;
        }

        public int getIndex() {
            return this.index;
        }

        public String getRemaining() {
            return this.remaining;
        }

        public String getToken() {
            return this.token;
        }

        public boolean isAttribute() {
            return this.isAttribute;
        }

        public String toString() {
            return this.token;
        }
    }
}

