/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.xml.spi.dom.NodeListImpl;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.diff.Add;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.DefaultElementIdentity;
import org.netbeans.modules.xml.xdm.diff.Delete;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffFinder {
    private ElementIdentity eID;
    private ChildInfo cInfo1;
    private ChildInfo cInfo2;
    private Document oldDoc;
    private Document newDoc;

    protected DiffFinder() {
    }

    public DiffFinder(ElementIdentity elementIdentity) {
        this.eID = elementIdentity;
    }

    public List<Difference> findDiff(Document document, Document document2) {
        this.oldDoc = document;
        this.newDoc = document2;
        List<Difference> list = new ArrayList<Difference>();
        List<Change.Type> list2 = this.checkChange(document, document2, 0, 0);
        if (list2.size() > 0) {
            this.markChange(new ArrayList<Node>(), document, document2, 0, 0, list2, new ArrayList<Node>(), list);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        arrayList.add(this.oldDoc);
        arrayList2.add(this.newDoc);
        this.compareChildren(arrayList, arrayList2, list);
        if (list.size() > 0) {
            list = this.findOptimized(list);
        }
        return list;
    }

    protected void compareChildren(List<Node> list, List<Node> list2, List<Difference> list3) {
        Node node = list.get(0);
        Node node2 = list2.get(0);
        NodeList nodeList = node.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList == NodeListImpl.EMPTY && nodeList2 == NodeListImpl.EMPTY) {
            return;
        }
        this.cInfo1 = new ChildInfo(node);
        this.cInfo2 = new ChildInfo(node2);
        List<Node> list4 = this.getChildList(node2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        if (nodeList != null) {
            Node node3;
            Object object;
            Object object2;
            Object object3;
            int n;
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                object3 = (Node)nodeList.item(n);
                object2 = null;
                if (object3 instanceof org.netbeans.modules.xml.xdm.nodes.Element) {
                    object2 = this.findMatch((org.netbeans.modules.xml.xdm.nodes.Element)object3, list4, node);
                } else if (object3 instanceof Text) {
                    object2 = this.findMatch((Text)object3, list4);
                }
                if (object2 == null) {
                    object = this.copy(list);
                    List<Node> list5 = this.copy(list2);
                    this.markDelete((List<Node>)object, (Node)object3, n, this.cInfo1.getSiblingBefore((Node)object3), list5, list3);
                    continue;
                }
                this.cInfo2.addMatchNode((Node)object2, (Node)object3);
                arrayList2.add((Node)object2);
                list4.remove(object2);
                object = new int[]{n, this.cInfo2.getIndex((Node)object2)};
                arrayList.add(object);
            }
            for (n = 0; n < list4.size(); ++n) {
                object3 = list4.get(n);
                object2 = new SiblingInfo((Node)object3, nodeList2, arrayList2);
                object = null;
                if (((SiblingInfo)object2).getNode() != null) {
                    object = this.cInfo2.getMatchNode(((SiblingInfo)object2).getNode());
                }
                int n3 = this.cInfo2.getIndex((Node)object3);
                this.markAdd(this.copy(list), (Node)object3, n3, ((SiblingInfo)object2).getPosition(), (Node)object, this.copy(list2), list3);
            }
            Collections.sort(arrayList, new PairComparator());
            for (n = 0; n < arrayList.size(); ++n) {
                int n4;
                int n5;
                object3 = (int[])arrayList.get(n);
                Object object4 = object3[0];
                Object object5 = object3[1];
                Node node4 = (Node)node.getChildNodes().item((int)object4);
                List<Change.Type> list6 = this.checkChange(node4, node3 = (Node)node2.getChildNodes().item((int)object5), n5 = this.cInfo1.getPosition(node4), n4 = this.cInfo2.getPosition(node3));
                if (list6.size() <= 0) continue;
                this.markChange(this.copy(list), node4, node3, (int)object4, (int)object5, list6, this.copy(list2), list3);
            }
            this.cInfo1 = null;
            this.cInfo2 = null;
            for (n = 0; n < arrayList.size(); ++n) {
                object3 = (int[])arrayList.get(n);
                Object object6 = object3[0];
                Object object7 = object3[1];
                Node node5 = (Node)node.getChildNodes().item((int)object6);
                node3 = (Node)node2.getChildNodes().item((int)object7);
                if (!(node5 instanceof org.netbeans.modules.xml.xdm.nodes.Element)) continue;
                list.add(0, node5);
                list2.add(0, node3);
                this.compareChildren(list, list2, list3);
                list.remove(0);
                list2.remove(0);
            }
        }
    }

    private List<Node> copy(List<Node> list) {
        return new ArrayList<Node>(list);
    }

    public static NodeInfo.NodeType getNodeType(Node node) throws DOMException {
        NodeInfo.NodeType nodeType = NodeInfo.NodeType.ELEMENT;
        if (node instanceof Text) {
            nodeType = DiffFinder.isWhiteSpaceOnly((Text)node) ? NodeInfo.NodeType.WHITE_SPACE : NodeInfo.NodeType.TEXT;
        } else if (node instanceof Attribute) {
            nodeType = NodeInfo.NodeType.ATTRIBUTE;
        }
        return nodeType;
    }

    protected List<Change.Type> checkChange(Node node, Node node2, int n, int n2) {
        List<Change.Type> list = this.checkChange(node, node2);
        if (n != n2) {
            list.add(Change.Type.POSITION);
        }
        return list;
    }

    protected List<Change.Type> checkChange(Node node, Node node2) {
        ArrayList<Change.Type> arrayList = new ArrayList<Change.Type>();
        if (!this.checkTokensEqual(node, node2)) {
            arrayList.add(Change.Type.TOKEN);
        }
        if (node instanceof org.netbeans.modules.xml.xdm.nodes.Element && node2 instanceof org.netbeans.modules.xml.xdm.nodes.Element) {
            if (!this.checkAttributesEqual((org.netbeans.modules.xml.xdm.nodes.Element)node, (org.netbeans.modules.xml.xdm.nodes.Element)node2)) {
                arrayList.add(Change.Type.ATTRIBUTE);
            }
        } else if (!node.getClass().isAssignableFrom(node2.getClass()) || !node2.getClass().isAssignableFrom(node.getClass())) {
            arrayList.add(Change.Type.UNKNOWN);
        }
        return arrayList;
    }

    protected boolean checkTokensEqual(Node node, Node node2) {
        if (node instanceof NodeImpl && node2 instanceof NodeImpl) {
            List<Token> list = ((NodeImpl)node).getTokens();
            List<Token> list2 = ((NodeImpl)node2).getTokens();
            return this.compareTokenEquals(list, list2);
        }
        return false;
    }

    protected boolean checkAttributesEqual(org.netbeans.modules.xml.xdm.nodes.Element element, org.netbeans.modules.xml.xdm.nodes.Element element2) {
        if (element == null || element2 == null) {
            return false;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        NamedNodeMap namedNodeMap2 = element2.getAttributes();
        if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
            return false;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            List<Token> list;
            Node node = (Node)namedNodeMap2.getNamedItem(namedNodeMap.item(i).getNodeName());
            if (node == null) {
                return false;
            }
            if (namedNodeMap2.item(i) != node) {
                return false;
            }
            List<Token> list2 = ((NodeImpl)namedNodeMap.item(i)).getTokens();
            boolean bl = this.compareTokenEquals(list2, list = ((NodeImpl)node).getTokens());
            if (bl) continue;
            return false;
        }
        return true;
    }

    protected boolean compareTokenEquals(List<Token> list, List<Token> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Token token = list.get(i);
            Token token2 = list2.get(i);
            if (token.getValue().intern() == token2.getValue().intern()) continue;
            return false;
        }
        return true;
    }

    protected Node findMatch(org.netbeans.modules.xml.xdm.nodes.Element element, List<Node> list, org.w3c.dom.Node node) {
        for (Node node2 : list) {
            if (!(node2 instanceof org.netbeans.modules.xml.xdm.nodes.Element) || !((DefaultElementIdentity)this.eID).compareElement(element, (org.netbeans.modules.xml.xdm.nodes.Element)node2, node, this.oldDoc, this.newDoc)) continue;
            return node2;
        }
        return null;
    }

    protected Node findMatch(Text text, List<Node> list) {
        for (Node node : list) {
            if (!(node instanceof Text) || !this.compareText(text, (Text)node)) continue;
            return node;
        }
        return null;
    }

    protected Difference createAddEvent(List<Node> list, Node node, int n, List<Node> list2) {
        assert (node != null) : "add node null";
        return new Add(DiffFinder.getNodeType(node), list, list2, node, n);
    }

    protected Difference createDeleteEvent(List<Node> list, Node node, int n, List<Node> list2) {
        assert (node != null) : "delete node null";
        return new Delete(DiffFinder.getNodeType(node), list, list2, node, n);
    }

    protected Difference createChangeEvent(List<Node> list, Node node, Node node2, int n, int n2, List<Change.Type> list2, List<Node> list3) {
        assert (node != null && node2 != null) : "change nodes null";
        if (node instanceof org.netbeans.modules.xml.xdm.nodes.Element) assert (node.getLocalName().equals(node2.getLocalName()));
        Change change = new Change(DiffFinder.getNodeType(node), list, list3, node, node2, n, n2, list2);
        if (change.getNewNodeInfo().getNewAncestors().size() > 0) assert (change.getNewNodeInfo().getNode().getId() != change.getNewNodeInfo().getNewAncestors().get(0).getId());
        return change;
    }

    protected void markAdd(List<Node> list, Node node, int n, int n2, Node node2, List<Node> list2, List<Difference> list3) {
        list3.add(this.createAddEvent(list, node, n, list2));
    }

    protected void markDelete(List<Node> list, Node node, int n, Node node2, List<Node> list2, List<Difference> list3) {
        list3.add(this.createDeleteEvent(list, node, n, list2));
    }

    protected void markChange(List<Node> list, Node node, Node node2, int n, int n2, List<Change.Type> list2, List<Node> list3, List<Difference> list4) {
        list4.add(this.createChangeEvent(list, node, node2, n, n2, list2, list3));
    }

    public static List<Difference> filterWhitespace(List<Difference> list) {
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        for (Difference difference : list) {
            NodeInfo.NodeType nodeType = difference.getNodeType();
            if (difference.getNodeType() == NodeInfo.NodeType.WHITE_SPACE) continue;
            arrayList.add(difference);
        }
        return arrayList;
    }

    public static List<Node> getPathToRoot(Node node) {
        assert (node.getOwnerDocument() != null);
        List<Node> list = new PathFromRootVisitor().findPath(node.getOwnerDocument(), (org.w3c.dom.Node)node);
        return list;
    }

    public List<Difference> findOptimized(List<Difference> list) {
        Cloneable cloneable;
        Object object;
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        HashMap<Object, Cloneable> hashMap = new HashMap<Object, Cloneable>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Difference object2 : list) {
            object = object2.getOldNodeInfo().getParent();
            cloneable = (ArrayList<Difference>)hashMap.get(object);
            if (cloneable == null) {
                arrayList2.add(object);
                cloneable = new ArrayList<Difference>();
                hashMap.put(object, cloneable);
            }
            cloneable.add(object2);
        }
        for (Node node : arrayList2) {
            Difference difference;
            int n;
            object = (List)hashMap.get(node);
            Collections.sort(object, new PairComparator2());
            cloneable = new HashMap();
            for (n = 0; n < object.size(); ++n) {
                difference = (Difference)object.get(n);
                this.modifyPositionFromIndex(n + 1, (List<Difference>)object, difference, (HashMap<Difference, Integer>)cloneable);
            }
            for (n = 0; n < object.size(); ++n) {
                difference = (Difference)object.get(n);
                Integer n2 = (Integer)((HashMap)cloneable).get(difference);
                int n3 = n2 != null ? n2.intValue() : difference.getOldNodeInfo().getPosition();
                int n4 = difference.getNewNodeInfo().getPosition();
                if (difference instanceof Change && ((Change)difference).isPositionChanged()) {
                    if (n3 == n4 && n3 != -1) {
                        ((Change)difference).setPositionChanged(false);
                    }
                    if (!((Change)difference).isValid()) continue;
                    arrayList.add(difference);
                    continue;
                }
                arrayList.add(difference);
            }
        }
        return arrayList;
    }

    protected void modifyPositionFromIndex(int n, List<Difference> list, Difference difference, HashMap<Difference, Integer> hashMap) {
        Integer n2 = hashMap.get(difference);
        int n3 = n2 != null ? n2.intValue() : difference.getOldNodeInfo().getPosition();
        int n4 = difference.getNewNodeInfo().getPosition();
        for (int i = n; i < list.size(); ++i) {
            Difference difference2 = list.get(i);
            Integer n5 = hashMap.get(difference2);
            int n6 = n5 != null ? n5.intValue() : difference2.getOldNodeInfo().getPosition();
            int n7 = difference2.getNewNodeInfo().getPosition();
            if (difference instanceof Add && n3 == -1 && n4 >= 0 && n4 <= n6) {
                hashMap.put(difference2, n6 + 1);
                continue;
            }
            if (difference instanceof Delete && n3 >= 0 && n4 == -1 && n3 <= n6) {
                hashMap.put(difference2, n6 - 1);
                continue;
            }
            if (!(difference instanceof Change) || n3 == n4) continue;
            if (n3 > n6 && n4 <= n6) {
                hashMap.put(difference2, n6 + 1);
                continue;
            }
            if (n4 <= n6 || n3 > n6) continue;
            hashMap.put(difference2, n6 - 1);
        }
    }

    public static boolean isPossibleWhiteSpace(String string) {
        return string.length() > 0 && Character.isWhitespace(string.charAt(0)) && Character.isWhitespace(string.charAt(string.length() - 1));
    }

    public static boolean isWhiteSpaceOnly(Text text) {
        String string = "";
        string = text.getTokens().size() == 1 ? text.getTokens().get(0).getValue() : text.getNodeValue();
        return DiffFinder.isPossibleWhiteSpace(string) && string.trim().length() == 0;
    }

    protected boolean compareText(Text text, Text text2) {
        if (DiffFinder.isWhiteSpaceOnly(text) && DiffFinder.isWhiteSpaceOnly(text2)) {
            return this.compareWhiteSpaces(text, text2);
        }
        return this.compareTextByValue(text, text2);
    }

    protected boolean compareWhiteSpaces(Text text, Text text2) {
        Node node = this.cInfo1.getSiblingBefore(text);
        Node node2 = this.cInfo2.getSiblingBefore(text2);
        boolean bl = false;
        if (node == null && node2 == null) {
            bl = true;
        } else if (node instanceof org.netbeans.modules.xml.xdm.nodes.Element && node2 instanceof org.netbeans.modules.xml.xdm.nodes.Element) {
            if (this.cInfo2.getMatchNode(node2) == node || this.eID.compareElement((Element)((org.netbeans.modules.xml.xdm.nodes.Element)node), (Element)((org.netbeans.modules.xml.xdm.nodes.Element)node2), (org.w3c.dom.Document)this.oldDoc, (org.w3c.dom.Document)this.newDoc)) {
                bl = true;
            }
        } else if (node instanceof Text && node2 instanceof Text && node.getNodeValue().intern() == node2.getNodeValue().intern()) {
            bl = true;
        }
        if (bl) {
            return this.compareTextByValue(text, text2);
        }
        return false;
    }

    protected boolean compareTextByValue(Text text, Text text2) {
        return text.getNodeValue().intern() == text2.getNodeValue().intern();
    }

    protected List<Node> getChildList(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = (Node)nodeList.item(i);
            arrayList.add(node2);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SiblingInfo {
        Node siblingBefore;
        int relativePos = 0;

        public SiblingInfo(Node node, NodeList nodeList, List<Node> list) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = (Node)nodeList.item(i);
                if (node2 != node) continue;
                if (i - 1 >= 0) {
                    for (int j = i - 1; j >= 0; --j) {
                        if (!(nodeList.item(j) instanceof org.netbeans.modules.xml.xdm.nodes.Element) || !list.contains(nodeList.item(j))) continue;
                        this.siblingBefore = (Node)nodeList.item(j);
                        this.relativePos = i - j;
                        break;
                    }
                }
                if (this.siblingBefore != null) break;
            }
        }

        public Node getNode() {
            return this.siblingBefore;
        }

        public int getPosition() {
            return this.relativePos;
        }
    }

    static class ChildInfo {
        HashMap<Node, int[]> posMap;
        HashMap<Node, Node> siblingBeforeMap;
        HashMap<Node, Node> compareNodeMap;

        public ChildInfo(Node node) {
            NodeList nodeList = node.getChildNodes();
            this.compareNodeMap = new HashMap();
            this.siblingBeforeMap = new HashMap(nodeList.getLength());
            this.posMap = new HashMap(nodeList.getLength());
            HashMap<Class, Integer> hashMap = new HashMap<Class, Integer>(7);
            Node node2 = null;
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node3 = (Node)nodeList.item(n);
                this.siblingBeforeMap.put(node3, node2);
                node2 = node3;
                Class clazz = this.getBucket(node3);
                Integer n2 = (Integer)hashMap.get(clazz);
                if (n2 == null) {
                    hashMap.put(clazz, -1);
                }
                int n3 = (Integer)hashMap.get(clazz) + 1;
                hashMap.put(clazz, n3);
                int[] nArray = new int[]{n++, n3};
                this.posMap.put(node3, nArray);
            }
        }

        private Class getBucket(Node node) {
            return node instanceof Text ? Text.class : node.getClass();
        }

        public Node getSiblingBefore(Node node) {
            return this.siblingBeforeMap.get(node);
        }

        public int getIndex(Node node) {
            return this.posMap.get(node)[0];
        }

        public int getPosition(Node node) {
            return this.posMap.get(node)[1];
        }

        public Node getMatchNode(Node node) {
            return this.compareNodeMap.get(node);
        }

        public void addMatchNode(Node node, Node node2) {
            this.compareNodeMap.put(node, node2);
        }

        public void clear() {
            this.compareNodeMap.clear();
            this.siblingBeforeMap.clear();
            this.posMap.clear();
        }
    }

    public class PairComparator2
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            Difference difference = (Difference)object;
            Difference difference2 = (Difference)object2;
            int n2 = difference.getNewNodeInfo().getPosition();
            if (n2 < (n = difference2.getNewNodeInfo().getPosition())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    }

    public class PairComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int[] nArray = (int[])object;
            int n = nArray[1];
            int[] nArray2 = (int[])object2;
            int n2 = nArray2[1];
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            return 0;
        }
    }
}

