/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.resolver.apps.resolver;
import org.netbeans.modules.xml.retriever.catalog.CatalogAttribute;
import org.netbeans.modules.xml.retriever.catalog.CatalogElement;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogEntryImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapper;
import org.netbeans.modules.xml.xam.Model;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogFileWrapperDOMImpl
implements EntityResolver,
CatalogFileWrapper,
DocumentListener {
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private org.w3c.dom.Document catDoc = null;
    private Element catalog = null;
    private boolean isItMyOwnEvent = false;
    public static Document backendCatalogSwingDocument = null;
    private static final Logger logger = Logger.getLogger(CatalogFileWrapperDOMImpl.class.getName());
    private Model.State currentStateOfCatalog = null;
    public static boolean TEST_ENVIRONMENT = false;
    private FileObject backendCatalogFileObj = null;
    boolean rawFileSaveStrategy = false;
    SaveCookie saveCookie = null;
    static WeakHashMap<FileObject, CatalogFileWrapper> fo2wrapMap = new WeakHashMap();

    private CatalogFileWrapperDOMImpl(FileObject fileObject, boolean bl) throws IOException {
        this.rawFileSaveStrategy = bl;
        this.backendCatalogFileObj = fileObject;
        assert (fileObject != null);
    }

    private synchronized void bootstrap() {
        try {
            backendCatalogSwingDocument = this.getDocument(this.backendCatalogFileObj);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        assert (this.backendCatalogFileObj != null);
        try {
            this.sync();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        if (this.currentStateOfCatalog == Model.State.NOT_WELL_FORMED) {
            throw new IllegalStateException("Catalog File Not wellformed");
        }
    }

    private synchronized void tearDown() {
        backendCatalogSwingDocument = null;
        this.catalog = null;
        this.catDoc = null;
    }

    public static synchronized CatalogFileWrapper getInstance(FileObject fileObject, boolean bl) throws IOException {
        CatalogFileWrapper catalogFileWrapper = fo2wrapMap.get(fileObject);
        if (catalogFileWrapper == null && (catalogFileWrapper = new CatalogFileWrapperDOMImpl(fileObject, bl)) != null) {
            fo2wrapMap.put(fileObject, catalogFileWrapper);
            return catalogFileWrapper;
        }
        return catalogFileWrapper;
    }

    public static synchronized CatalogFileWrapper getInstance(FileObject fileObject) throws IOException {
        return CatalogFileWrapperDOMImpl.getInstance(fileObject, false);
    }

    @Override
    public synchronized void cleanInstance() {
    }

    private Document getDocument(FileObject fileObject) throws IOException {
        logger.finer("ENTER FileObject " + fileObject.toString());
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        StyledDocument styledDocument = editorCookie.openDocument();
        logger.finer("RETURN");
        return styledDocument;
    }

    private boolean shouldParse(String string) {
        return string != null && string.toLowerCase().indexOf("catalog") != -1;
    }

    @Override
    public List<CatalogEntry> getSystems() {
        return this.getEntriesByTagName(CatalogElement.system, CatalogAttribute.systemId, CatalogAttribute.uri);
    }

    @Override
    public void setSystem(int n, CatalogEntry catalogEntry) throws IOException {
        this.setEntryInCatalogFile(n, catalogEntry, CatalogAttribute.systemId, CatalogAttribute.uri);
    }

    @Override
    public void deleteSystem(int n) throws IOException {
        this.deleteEntryFromCatalogFile(n, CatalogElement.system);
    }

    @Override
    public void addSystem(CatalogEntry catalogEntry) throws IOException {
        this.addEntryToCatFile(catalogEntry, CatalogAttribute.systemId, CatalogAttribute.uri);
    }

    @Override
    public List<CatalogEntry> getDelegateSystems() {
        return this.getEntriesByTagName(CatalogElement.delegateSystem, CatalogAttribute.systemIdStartString, CatalogAttribute.catalog);
    }

    @Override
    public void setDelegateSystem(int n, CatalogEntry catalogEntry) throws IOException {
        this.setEntryInCatalogFile(n, catalogEntry, CatalogAttribute.systemIdStartString, CatalogAttribute.catalog);
    }

    @Override
    public void deleteDelegateSystem(int n) throws IOException {
        this.deleteEntryFromCatalogFile(n, CatalogElement.delegateSystem);
    }

    @Override
    public void addDelegateSystem(CatalogEntry catalogEntry) throws IOException {
        this.addEntryToCatFile(catalogEntry, CatalogAttribute.systemIdStartString, CatalogAttribute.catalog);
    }

    @Override
    public List<CatalogEntry> getRewriteSystems() {
        return this.getEntriesByTagName(CatalogElement.rewriteSystem, CatalogAttribute.systemIdStartString, CatalogAttribute.rewritePrefix);
    }

    @Override
    public void setRewriteSystem(int n, CatalogEntry catalogEntry) throws IOException {
        this.setEntryInCatalogFile(n, catalogEntry, CatalogAttribute.systemIdStartString, CatalogAttribute.rewritePrefix);
    }

    @Override
    public void deleteRewriteSystem(int n) throws IOException {
        this.deleteEntryFromCatalogFile(n, CatalogElement.rewriteSystem);
    }

    @Override
    public void addRewriteSystem(CatalogEntry catalogEntry) throws IOException {
        this.addEntryToCatFile(catalogEntry, CatalogAttribute.systemIdStartString, CatalogAttribute.rewritePrefix);
    }

    private void initCatFile() throws IOException {
        logger.finer("ENTER");
        NodeList nodeList = this.catDoc.getElementsByTagName(CatalogElement.catalog.toString());
        if (nodeList.getLength() <= 0) {
            this.catalog = this.catDoc.createElement(CatalogElement.catalog.toString());
            this.catalog.setAttribute(CatalogAttribute.prefer.toString(), "system");
            this.catalog.setAttribute(CatalogAttribute.xmlns.toString(), "urn:oasis:names:tc:entity:xmlns:xml:catalog");
            this.catDoc.appendChild(this.catalog);
            this.flush();
        } else {
            this.catalog = (Element)nodeList.item(0);
        }
        logger.finer("RETURN");
    }

    private List<CatalogEntry> getEntriesByTagName(CatalogElement catalogElement, CatalogAttribute catalogAttribute, CatalogAttribute catalogAttribute2) {
        this.bootstrap();
        Object[] objectArray = new Object[]{catalogElement.toString(), catalogAttribute.toString(), catalogAttribute2.toString()};
        logger.entering("CatalogModelWrapperDOMImpl", "getEntriesByTagName", objectArray);
        NodeList nodeList = this.catalog.getElementsByTagName(catalogElement.toString());
        int n = nodeList.getLength();
        if (n < 1) {
            return null;
        }
        ArrayList<CatalogEntry> arrayList = new ArrayList<CatalogEntry>(nodeList.getLength());
        for (int i = 0; i < n; ++i) {
            String string = "";
            String string2 = "";
            Element element = (Element)nodeList.item(i);
            string = element.getAttribute(catalogAttribute.toString());
            string2 = element.getAttribute(catalogAttribute2.toString());
            String[] stringArray = new String[]{catalogAttribute.toString(), catalogAttribute2.toString()};
            HashMap<String, String> hashMap = this.getOtherAttributes(element, stringArray);
            CatalogEntryImpl catalogEntryImpl = hashMap != null ? new CatalogEntryImpl(catalogElement, string, string2, hashMap) : new CatalogEntryImpl(catalogElement, string, string2);
            arrayList.add(catalogEntryImpl);
        }
        logger.exiting("CatalogModelWrapperDOMImpl", "getEntriesByTagName", arrayList);
        this.tearDown();
        return arrayList;
    }

    private void addEntryToCatFile(CatalogEntry catalogEntry, CatalogAttribute catalogAttribute, CatalogAttribute catalogAttribute2) throws IOException {
        HashMap<String, String> hashMap;
        this.bootstrap();
        Element element = this.catDoc.createElement(catalogEntry.getEntryType().toString());
        if (catalogAttribute2 != null) {
            element.setAttribute(catalogAttribute2.toString(), catalogEntry.getTarget());
        }
        if (catalogAttribute != null) {
            element.setAttribute(catalogAttribute.toString(), catalogEntry.getSource());
        }
        if ((hashMap = catalogEntry.getExtraAttributeMap()) != null) {
            this.addOtherAttributesToElement(element, hashMap);
        }
        this.catalog.appendChild(element);
        this.flush();
        logger.exiting(this.toString(), "addEntryToCatFile");
        this.tearDown();
    }

    private void setEntryInCatalogFile(int n, CatalogEntry catalogEntry, CatalogAttribute catalogAttribute, CatalogAttribute catalogAttribute2) throws IOException {
        NodeList nodeList;
        int n2;
        this.bootstrap();
        Object[] objectArray = new Object[]{n, catalogEntry.toString(), catalogAttribute.toString(), catalogAttribute2.toString()};
        logger.entering("CatalogModelWrapperDOMImpl", "setEntryInCatalogFile", objectArray);
        Element element = this.catDoc.createElement(catalogEntry.getEntryType().toString());
        element.setAttribute(catalogAttribute2.toString(), catalogEntry.getTarget());
        element.setAttribute(catalogAttribute.toString(), catalogEntry.getSource());
        HashMap<String, String> hashMap = catalogEntry.getExtraAttributeMap();
        if (hashMap != null) {
            this.addOtherAttributesToElement(element, hashMap);
        }
        if (n >= (n2 = (nodeList = this.catalog.getElementsByTagName(catalogEntry.getEntryType().toString())).getLength()) || n < 0) {
            throw new IndexOutOfBoundsException("Error: Catalog entry does not exists");
        }
        Node node = nodeList.item(n);
        this.catalog.replaceChild(element, node);
        this.flush();
        logger.exiting(this.toString(), "setEntryInCatalogFile");
        this.tearDown();
    }

    private void deleteEntryFromCatalogFile(int n, CatalogElement catalogElement) throws IOException {
        logger.entering(this.toString(), "deleteEntryFromCatalogFile");
        this.bootstrap();
        NodeList nodeList = this.catalog.getElementsByTagName(catalogElement.toString());
        int n2 = nodeList.getLength();
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("Error: Catalog entry does not exists");
        }
        Node node = nodeList.item(n);
        this.catalog.removeChild(node);
        this.flush();
        logger.exiting(this.toString(), "deleteEntryFromCatalogFile");
        this.tearDown();
    }

    private void addOtherAttributesToElement(Element element, HashMap<String, String> hashMap) {
        if (hashMap == null) {
            return;
        }
        Set<String> set = hashMap.keySet();
        if (set == null) {
            return;
        }
        for (String string : set) {
            String string2 = hashMap.get(string);
            if (string2 == null) continue;
            element.setAttribute(string, string2);
        }
    }

    private HashMap<String, String> getOtherAttributes(Element element, String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string = namedNodeMap.item(i).getNodeName();
            boolean bl = false;
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            String string3 = namedNodeMap.item(i).getNodeValue();
            if (string == null || string3 == null) continue;
            hashMap.put(string, string3);
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        return hashMap;
    }

    public synchronized void sync() throws IOException {
        logger.finer("ENTER");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.assignStateAndFirePropChangeEvent(Model.State.NOT_WELL_FORMED);
            throw new IOException(parserConfigurationException.getMessage());
        }
        String string = null;
        try {
            string = backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            this.assignStateAndFirePropChangeEvent(Model.State.NOT_WELL_FORMED);
            throw new IOException(badLocationException.getMessage());
        }
        logger.finer("Trying to sync this data to model:" + string);
        if (this.shouldParse(string)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            try {
                this.catDoc = documentBuilder.parse(byteArrayInputStream);
                logger.finer("Just synced this data :" + string);
            }
            catch (SAXException sAXException) {
                this.assignStateAndFirePropChangeEvent(Model.State.NOT_WELL_FORMED);
                throw new IOException(sAXException.getMessage());
            }
        } else {
            this.catDoc = documentBuilder.newDocument();
        }
        if (this.catDoc == null) {
            this.assignStateAndFirePropChangeEvent(Model.State.NOT_WELL_FORMED);
            throw new IllegalStateException("Catalog File Not wellformed");
        }
        this.assignStateAndFirePropChangeEvent(Model.State.VALID);
        this.initCatFile();
        logger.finer("RETURN");
    }

    private void assignStateAndFirePropChangeEvent(Model.State state) {
        Model.State state2 = this.currentStateOfCatalog;
        this.currentStateOfCatalog = state;
        this.pcs.firePropertyChange("CatalogWraperObject", state2, state);
    }

    public boolean isValidState() {
        return this.currentStateOfCatalog == Model.State.VALID;
    }

    public synchronized void flush() throws IOException {
        logger.finer("ENTER");
        this.isItMyOwnEvent = true;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.catDoc);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
            String string = new String(byteArrayOutputStream.toByteArray());
            String string2 = backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength());
            if (string.equals(string2)) {
                this.isItMyOwnEvent = false;
                return;
            }
            backendCatalogSwingDocument.remove(0, backendCatalogSwingDocument.getLength());
            backendCatalogSwingDocument.insertString(0, string, null);
            logger.finer("Just Flushed this data :" + backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength()));
            this.save(string, string2);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        finally {
            this.isItMyOwnEvent = false;
        }
        logger.finer("RETURN");
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        logger.entering("CatalogModelWrapperDOMImpl", "insertUpdate", this.isItMyOwnEvent);
        if (!this.isItMyOwnEvent) {
            try {
                this.sync();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    void showStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.showStackTrace();
        logger.entering("CatalogModelWrapperDOMImpl", "removeUpdate", this.isItMyOwnEvent);
        this.insertUpdate(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        logger.entering("CatalogModelWrapperDOMImpl", "changedUpdate", this.isItMyOwnEvent);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public InputStream getCatalogAsStream() throws IOException {
        try {
            String string = backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            logger.finer("In getCatalogAsStream gona return:" + string);
            return byteArrayInputStream;
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        logger.finest("ENTRY PublicID:" + string + " SystemID:" + string2);
        InputSource inputSource = new InputSource();
        InputStreamReader inputStreamReader = new InputStreamReader(resolver.class.getResourceAsStream("/org/apache/xml/resolver/etc/catalog.dtd"));
        inputSource.setCharacterStream(inputStreamReader);
        if (string2 != null && string2.equals("urn:oasis:names:tc:entity:xmlns:xml:catalog")) {
            logger.finest("RETURN the DTD");
            return inputSource;
        }
        if (string != null && string.equals("urn:oasis:names:tc:entity:xmlns:xml:catalog")) {
            logger.finest("RETURN the DTD");
            return inputSource;
        }
        logger.finest("RETURN null");
        return null;
    }

    private void save(String string, String string2) {
        if (TEST_ENVIRONMENT) {
            this.saveByRawStreamByFile(string, string2);
        } else {
            this.saveBySaveCookie();
        }
    }

    boolean saveBySaveCookie() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.backendCatalogFileObj);
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            assert (saveCookie != null);
            saveCookie.save();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveByRawStreamByFO(String string, String string2) {
        OutputStream outputStream = null;
        FileLock fileLock = null;
        boolean bl = true;
        try {
            fileLock = this.backendCatalogFileObj.lock();
            outputStream = this.backendCatalogFileObj.getOutputStream(fileLock);
            outputStream.write(string.getBytes());
            outputStream.flush();
            outputStream.close();
            fileLock.releaseLock();
            outputStream = null;
            return (boolean)outputStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
            return bl;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveByRawStreamByFile(String string, String string2) {
        OutputStream outputStream = null;
        try {
            File file = FileUtil.toFile((FileObject)this.backendCatalogFileObj);
            outputStream = new FileOutputStream(file);
            outputStream.write(string.getBytes());
            outputStream.flush();
            outputStream.close();
            outputStream = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                    return false;
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    void saveByDocumentEditorCookie() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.backendCatalogFileObj);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            editorCookie.saveDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean unsuccessfulSave(String string, String string2) {
        try {
            if (backendCatalogSwingDocument.getText(0, backendCatalogSwingDocument.getLength()).length() != string.length()) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public Model.State getCatalogState() {
        this.bootstrap();
        this.tearDown();
        return this.currentStateOfCatalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.backendCatalogFileObj);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            backendCatalogSwingDocument.removeDocumentListener(this);
            editorCookie.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void addNextCatalog(CatalogEntry catalogEntry) throws IOException {
        this.addEntryToCatFile(catalogEntry, CatalogAttribute.catalog, null);
    }

    @Override
    public void deleteNextCatalog(int n) throws IOException {
        this.deleteEntryFromCatalogFile(n, CatalogElement.nextCatalog);
    }

    @Override
    public List<CatalogEntry> getNextCatalogs() {
        return this.getEntriesByTagName(CatalogElement.nextCatalog, CatalogAttribute.catalog, CatalogAttribute.catalog);
    }
}

