/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.design.JRDesignSubreportReturnValue;
import net.sf.jasperreports.engine.design.JRDesignVariable;

public class JRSubreportReturnValueDialog
extends JDialog {
    private JRDesignSubreportReturnValue subreportReturnValue = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxCalculationType;
    private JComboBox jComboBoxSubreportVariable;
    private JComboBox jComboBoxVariable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JTextField jTextFieldNameIncrementerFactoryClass;
    private int dialogResult;

    public JRSubreportReturnValueDialog(Dialog parent) {
        super(parent);
        this.initAll();
    }

    public JRSubreportReturnValueDialog(Frame parent) {
        super(parent);
        this.initAll();
    }

    public void initAll() {
        this.setModal(true);
        this.initComponents();
        this.setTypes();
        this.updateVariables();
        this.jComboBoxSubreportVariable.setSelectedItem("");
        this.setSize(380, 260);
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRSubreportReturnValueDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setTypes() {
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(0), I18n.getString("JRSubreportReturnValueDialog.ComboBox.Nothing")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(1), I18n.getString("JRSubreportReturnValueDialog.ComboBox.Count")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(10), I18n.getString("JRSubreportReturnValueDialog.ComboBox.DistinctCount")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(2), I18n.getString("JRSubreportReturnValueDialog.ComboBox.Sum")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(3), I18n.getString("JRSubreportReturnValueDialog.ComboBox.Average")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(4), I18n.getString("JRSubreportReturnValueDialog.ComboBox.Lowest")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(5), I18n.getString("JRSubreportReturnValueDialog.ComboBox.Highest")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(6), I18n.getString("JRSubreportReturnValueDialog.ComboBox.StandardDeviation")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(7), I18n.getString("JRSubreportReturnValueDialog.ComboBox.Variance")));
        this.jComboBoxCalculationType.addItem(new Tag(new Byte(9), I18n.getString("JRSubreportReturnValueDialog.ComboBox.First")));
    }

    public void updateVariables() {
        this.jComboBoxSubreportVariable.removeAllItems();
        this.jComboBoxVariable.removeAllItems();
        try {
            List variables = IReportManager.getInstance().getActiveReport().getVariablesList();
            for (int i = 0; i < variables.size(); ++i) {
                JRDesignVariable var = (JRDesignVariable)variables.get(i);
                if (var.isSystemDefined()) {
                    this.jComboBoxSubreportVariable.addItem(var.getName());
                    continue;
                }
                this.jComboBoxVariable.addItem(var.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxCalculationType = new JComboBox();
        this.jComboBoxVariable = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jTextFieldNameIncrementerFactoryClass = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboBoxSubreportVariable = new JComboBox();
        ResourceBundle bundle = ResourceBundle.getBundle("com/jaspersoft/ireport/locale/Bundle");
        this.setTitle(bundle.getString("JRSubreportReturnValueDialog.Title.AddModVariable"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRSubreportReturnValueDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("JRSubreportReturnValueDialog.Label.SubreportVariable"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("JRSubreportReturnValueDialog.Label.CalculationType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel5.setText(bundle.getString("JRSubreportReturnValueDialog.Label.LocalDestinationVariable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxCalculationType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxVariable, gridBagConstraints);
        this.jLabel8.setText(bundle.getString("JRSubreportReturnValueDialog.Label.CustomIncrementerFactoryClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldNameIncrementerFactoryClass, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText(bundle.getString("Global.Button.Ok"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRSubreportReturnValueDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText(bundle.getString("Global.Button.Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRSubreportReturnValueDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jComboBoxSubreportVariable.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jComboBoxSubreportVariable, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if ((this.jComboBoxSubreportVariable.getSelectedItem() + "").trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRSubreportReturnValueDialog.Message.Warning"), I18n.getString("JRSubreportReturnValueDialog.Message.Error"), 2);
            return;
        }
        this.subreportReturnValue = new JRDesignSubreportReturnValue();
        this.subreportReturnValue.setSubreportVariable(this.jComboBoxSubreportVariable.getSelectedItem() + "");
        if (this.jComboBoxVariable.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRSubreportReturnValueDialog.Message.Warning2"), I18n.getString("JRSubreportReturnValueDialog.Message.Error2"), 2);
            return;
        }
        this.subreportReturnValue.setToVariable(this.jComboBoxVariable.getSelectedItem() + "");
        Object t = this.jComboBoxCalculationType.getSelectedItem();
        if (t != null && t instanceof Tag) {
            this.subreportReturnValue.setCalculation(((Byte)((Tag)t).getValue()).byteValue());
        }
        if (this.jTextFieldNameIncrementerFactoryClass.getText().length() == 0) {
            this.subreportReturnValue.setIncrementerFactoryClassName(null);
        } else {
            this.subreportReturnValue.setIncrementerFactoryClassName(this.jTextFieldNameIncrementerFactoryClass.getText());
        }
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRDesignSubreportReturnValue getSubreportReturnValue() {
        return this.subreportReturnValue;
    }

    public void setSubreportReturnValue(JRDesignSubreportReturnValue tmpSubreportReturnValue) {
        this.jComboBoxSubreportVariable.setSelectedItem(new String(tmpSubreportReturnValue.getSubreportVariable()));
        for (int i = 0; i < this.jComboBoxVariable.getItemCount(); ++i) {
            Object var = this.jComboBoxVariable.getItemAt(i);
            if (!(var + "").equals(tmpSubreportReturnValue.getToVariable())) continue;
            this.jComboBoxVariable.setSelectedIndex(i);
            break;
        }
        Misc.setComboboxSelectedTagValue(this.jComboBoxCalculationType, tmpSubreportReturnValue.getCalculation());
        this.jTextFieldNameIncrementerFactoryClass.setText(tmpSubreportReturnValue.getIncrementerFactoryClassName());
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

