/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.tools.AggregationFunctionDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.Exceptions;

public class CreateTextFieldFromFieldAction
extends CreateTextFieldAction {
    public JRDesignElement createReportElement(JasperDesign jasperDesign) {
        JRDesignTextField element = (JRDesignTextField)super.createReportElement(jasperDesign);
        JRDesignField field = (JRDesignField)this.getPaletteItem().getData();
        ((JRDesignExpression)element.getExpression()).setText("$F{" + field.getName() + "}");
        CreateTextFieldFromFieldAction.setMatchingClassExpression((JRDesignExpression)element.getExpression(), field.getValueClassName(), true);
        return element;
    }

    public boolean isNumeric(String type) {
        return type != null && (type.equals("java.lang.Byte") || type.equals("java.lang.Short") || type.equals("java.lang.Integer") || type.equals("java.lang.Long") || type.equals("java.lang.Float") || type.equals("java.lang.Double") || type.equals("java.lang.Number") || type.equals("java.math.BigDecimal"));
    }

    public void drop(DropTargetDropEvent dtde) {
        JRDesignTextField element = (JRDesignTextField)this.createReportElement(this.getJasperDesign());
        if (element == null) {
            return;
        }
        this.dropFieldElementAt(this.getScene(), this.getJasperDesign(), element, dtde.getLocation());
    }

    public void dropFieldElementAt(Scene theScene, JasperDesign jasperDesign, JRDesignTextField element, Point location) {
        JRDesignField newField = (JRDesignField)this.getPaletteItem().getData();
        if (theScene instanceof ReportObjectScene) {
            Point p = theScene.convertViewToScene(location);
            JRDesignBand b = ModelUtils.getBandAt(jasperDesign, p);
            int yLocation = ModelUtils.getBandLocation((JRBand)b, jasperDesign);
            Point pLocationInBand = new Point(p.x - jasperDesign.getLeftMargin(), p.y - yLocation);
            if (b != null && (b.getOrigin().getBandType() == 7 || b.getOrigin().getBandType() == 5 || b.getOrigin().getBandType() == 8 || b.getOrigin().getBandType() == 4 || b.getOrigin().getBandType() == 9 || b.getOrigin().getBandType() == 3 || b.getOrigin().getBandType() == 2 || b.getOrigin().getBandType() == 11)) {
                AggregationFunctionDialog dialog = new AggregationFunctionDialog(Misc.getMainFrame(), true);
                dialog.setFunctionSet(this.isNumeric(newField.getValueClassName()) ? AggregationFunctionDialog.NUMERIC_SET : AggregationFunctionDialog.STRING_SET);
                dialog.setDefaultSelection(AggregationFunctionDialog.DEFAULT_AS_VALUE);
                dialog.setVisible(true);
                Byte aggFunc = dialog.getSelectedFunction();
                if (aggFunc != null) {
                    JRDesignVariable var = new JRDesignVariable();
                    var.setName(newField.getName());
                    var.setCalculation(aggFunc.byteValue());
                    var.setExpression((JRExpression)Misc.createExpression(newField.getValueClassName(), "$F{" + newField.getName() + "}"));
                    if (aggFunc.equals((byte)1) || aggFunc.equals((byte)10)) {
                        var.setValueClassName("java.lang.Integer");
                        element.setPattern(null);
                    } else {
                        var.setValueClassName(newField.getValueClassName());
                    }
                    if (b.getOrigin().getBandType() == 11 || b.getOrigin().getBandType() == 2) {
                        var.setResetType((byte)1);
                    } else if (b.getOrigin().getBandType() == 7 || b.getOrigin().getBandType() == 5) {
                        var.setResetType((byte)4);
                        var.setResetGroup((JRGroup)jasperDesign.getGroupsMap().get(b.getOrigin().getGroupName()));
                    } else if (b.getOrigin().getBandType() == 8 || b.getOrigin().getBandType() == 4) {
                        var.setResetType((byte)3);
                    } else if (b.getOrigin().getBandType() == 3 || b.getOrigin().getBandType() == 9) {
                        var.setResetType((byte)2);
                    }
                    try {
                        int i = 1;
                        while (jasperDesign.getVariablesMap().containsKey(var.getName() + "_" + i)) {
                            ++i;
                        }
                        var.setName(var.getName() + "_" + i);
                        jasperDesign.addVariable(var);
                    }
                    catch (JRException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    JRDesignExpression exp = new JRDesignExpression();
                    exp.setText("$V{" + var.getName() + "}");
                    element.setExpression((JRExpression)exp);
                    CreateTextFieldFromFieldAction.setMatchingClassExpression((JRDesignExpression)element.getExpression(), var.getValueClassName(), true);
                    if (b.getOrigin().getBandType() == 5) {
                        element.setEvaluationTime((byte)5);
                        element.setEvaluationGroup((JRGroup)jasperDesign.getGroupsMap().get(b.getOrigin().getGroupName()));
                    } else if (b.getOrigin().getBandType() == 4) {
                        element.setEvaluationTime((byte)4);
                    } else if (b.getOrigin().getBandType() == 3) {
                        element.setEvaluationTime((byte)3);
                    } else if (b.getOrigin().getBandType() == 2) {
                        element.setEvaluationTime((byte)2);
                    }
                }
            }
        }
        CreateTextFieldAction.dropElementAt(theScene, jasperDesign, (JRDesignElement)element, location);
    }
}

