/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import java.awt.Component;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

class ExcelColumnEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected JTextField textField = new JTextField();
    protected Object oldValue;
    static final String digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public ExcelColumnEditor() {
        this.textField.setEditable(true);
        this.textField.setHorizontalAlignment(4);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(value.toString());
        this.oldValue = value;
        return this.textField;
    }

    public Object getCellEditorValue() {
        String name = this.oldValue.getClass().getName();
        Number returnValue = null;
        String val = this.textField.getText();
        if (val.matches("[A-Z]*")) {
            int theReturnValue = 0;
            int esp = 0;
            for (int i = val.length() - 1; i >= 0; --i) {
                int digitVal = digits.indexOf(val.charAt(i));
                if (esp > 0) {
                    ++digitVal;
                }
                theReturnValue += digitVal * (int)Math.pow(26.0, esp);
                ++esp;
            }
            return new Integer(theReturnValue);
        }
        try {
            if (name.equals("java.lang.Integer")) {
                returnValue = new Integer(this.textField.getText());
            } else if (name.equals("java.lang.Double")) {
                returnValue = new Double(this.textField.getText());
            } else if (name.equals("java.lang.Float")) {
                returnValue = new Float(this.textField.getText());
            } else if (name.equals("java.lang.Long")) {
                returnValue = new Long(this.textField.getText());
            } else if (name.equals("java.lang.Short")) {
                returnValue = new Short(this.textField.getText());
            } else if (name.equals("java.lang.Byte")) {
                returnValue = new Byte(this.textField.getText());
            } else if (name.equals("java.math.BigDecimal")) {
                returnValue = new BigDecimal(this.textField.getText());
            } else if (name.equals("java.math.BigInteger")) {
                returnValue = new BigInteger(this.textField.getText());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return returnValue;
    }
}

