/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.background;

import com.jaspersoft.ireport.addons.background.BackgroundImageLayer;
import com.jaspersoft.ireport.addons.background.BackgroundImageUtilities;
import com.jaspersoft.ireport.addons.background.BackgroundImageWidget;
import com.jaspersoft.ireport.addons.background.ShowBackgroundImageAction;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportDesignerPanel;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public class TransformBackgroundImageAction
extends CallableSystemAction
implements Presenter.Menu,
Presenter.Popup,
LookupListener {
    private final Lookup lkp = Utilities.actionsGlobalContext();
    private final Lookup.Result<? extends ReportDesignerPanel> result = this.lkp.lookupResult(ReportDesignerPanel.class);
    JCheckBoxMenuItem menu = null;

    public TransformBackgroundImageAction() {
        this.result.addLookupListener((LookupListener)this);
        this.result.allItems();
    }

    public JMenuItem getMenuPresenter() {
        return this.getMenu();
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenu();
    }

    public void performAction() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
                ReportObjectScene scene = view.getReportDesignerPanel().getScene();
                BackgroundImageLayer layer = BackgroundImageUtilities.getBackgroundImageLayer(view, false);
                JasperDesign jd = view.getModel().getJasperDesign();
                if (layer != null) {
                    List widgets = layer.getChildren();
                    for (Widget w : widgets) {
                        if (!(w instanceof BackgroundImageWidget)) continue;
                        ((BackgroundImageWidget)w).setTransforming(TransformBackgroundImageAction.this.getMenu().isSelected());
                        break;
                    }
                }
            }
        });
    }

    protected boolean enable() {
        this.getMenu().setSelected(false);
        this.getMenu().setEnabled(false);
        if (IReportManager.getInstance().getActiveVisualView() != null) {
            BackgroundImageLayer layer = BackgroundImageUtilities.getBackgroundImageLayer(IReportManager.getInstance().getActiveVisualView(), false);
            boolean b = false;
            if (layer != null && layer.getChildren().size() > 0) {
                List widgets = layer.getChildren();
                for (Widget w : widgets) {
                    if (!(w instanceof BackgroundImageWidget)) continue;
                    this.getMenu().setEnabled(((BackgroundImageWidget)w).isVisible());
                    b = ((BackgroundImageWidget)w).isTransforming();
                    break;
                }
            }
            this.getMenu().setSelected(b);
            this.getMenu().updateUI();
            return this.getMenu().isEnabled();
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(ShowBackgroundImageAction.class, (String)"CTL_TransformBackgroundImageAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected JCheckBoxMenuItem getMenu() {
        if (this.menu == null) {
            this.menu = new JCheckBoxMenuItem(this.getName());
            this.menu.addActionListener((ActionListener)((Object)this));
            this.menu.setSelected(false);
            this.menu.setEnabled(false);
        }
        return this.menu;
    }

    public void resultChanged(LookupEvent le) {
        this.enable();
    }

    protected boolean asynchronous() {
        return false;
    }
}

