/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class StopManager {
    private static final StopManager DEFAULT = new StopManager();
    private static final Logger LOGGER = Logger.getLogger(StopManager.class.getName());
    private final PropertyChangeListener listener = new StopPropertyChangeListener();
    private final AtomicBoolean isStopping = new AtomicBoolean(false);
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private volatile DatabaseServer server;

    private StopManager() {
    }

    public static StopManager getDefault() {
        return DEFAULT;
    }

    public PropertyChangeListener getStopListener() {
        return this.listener;
    }

    public boolean isStopRequested() {
        return this.stopRequested.get();
    }

    private void disconnectConnections() {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        String string = this.server.getURL();
        for (DatabaseConnection databaseConnection : databaseConnectionArray) {
            if (!MySQLOptions.getDriverClass().equals(databaseConnection.getDriverClass()) || !databaseConnection.getDatabaseURL().contains(string)) continue;
            ConnectionManager.getDefault().disconnect(databaseConnection);
        }
    }

    public void stop(final DatabaseServer databaseServer) {
        this.server = databaseServer;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    boolean bl = StopManager.this.isStopping.getAndSet(true);
                    if (bl) {
                        LOGGER.log(Level.FINE, "Server is already stopping");
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StopManager.class, (String)"MSG_StoppingMySQL"));
                    databaseServer.stop();
                    StopManager.this.disconnectAndWaitForStop();
                }
                catch (DatabaseException databaseException) {
                    Utils.displayError(Utils.getMessage("MSG_UnableToStopServer", new Object[0]), (Exception)((Object)databaseException));
                }
                finally {
                    StopManager.this.isStopping.set(false);
                }
            }
        });
    }

    private void disconnectAndWaitForStop() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(StopManager.class, (String)"MSG_WaitingForServerToStop"));
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                try {
                    boolean bl;
                    do {
                        if (!StopManager.this.waitForStop()) continue;
                        StopManager.this.stopRequested.set(false);
                        return;
                    } while (bl = StopManager.this.displayServerRunning());
                }
                finally {
                    progressHandle.finish();
                }
            }
        });
    }

    private boolean displayServerRunning() {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(StopManager.class, (String)"StopManager.CancelButton"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StopManager.class, (String)"StopManager.CancelButtonA11yDesc"));
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(StopManager.class, (String)"StopManager.KeepWaitingButton"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StopManager.class, (String)"StopManager.KeepWaitingButtonA11yDesc"));
        JButton jButton3 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)NbBundle.getMessage(StopManager.class, (String)"StopManager.PropsButton"));
        jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StopManager.class, (String)"StopManager.PropsButtonA11yDesc"));
        String string = NbBundle.getMessage(StopManager.class, (String)"MSG_ServerStillRunning");
        final NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(StopManager.class, (String)"StopManager.ServerStillRunningTitle"), 1, 3, new Object[]{jButton2, jButton3, jButton}, NotifyDescriptor.CANCEL_OPTION);
        Object object = Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                return DialogDisplayer.getDefault().notify(notifyDescriptor);
            }
        });
        if (jButton.equals(object)) {
            this.stopRequested.set(false);
            return false;
        }
        if (jButton2.equals(object)) {
            return true;
        }
        this.displayAdminProperties(this.server);
        return false;
    }

    private void displayAdminProperties(final DatabaseServer databaseServer) {
        Mutex.EVENT.postReadRequest(new Runnable(){

            public void run() {
                PropertiesDialog propertiesDialog = new PropertiesDialog(databaseServer);
                propertiesDialog.displayDialog(PropertiesDialog.Tab.ADMIN);
            }
        });
    }

    private boolean waitForStop() {
        for (int i = 0; i <= 10; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.INFO, "Interrupted waiting for server to stop", interruptedException);
                Thread.currentThread().interrupt();
                return true;
            }
            try {
                this.server.reconnect();
                continue;
            }
            catch (DatabaseException databaseException) {
                this.server.disconnect();
                this.disconnectConnections();
                return true;
            }
            catch (TimeoutException timeoutException) {
                LOGGER.log(Level.INFO, timeoutException.getMessage(), timeoutException);
                this.server.disconnect();
                this.disconnectConnections();
                return true;
            }
        }
        return false;
    }

    private class StopPropertyChangeListener
    implements PropertyChangeListener {
        private StopPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DatabaseServer databaseServer = (DatabaseServer)propertyChangeEvent.getSource();
            if (("stop-args".equals(propertyChangeEvent.getPropertyName()) || "stop-path".equals(propertyChangeEvent.getPropertyName())) && StopManager.this.stopRequested.get()) {
                StopManager.this.stop(databaseServer);
            }
        }
    }
}

