/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXDialog
extends JDialog {
    public static final String EXECUTE_ACTION_COMMAND = "execute";
    public static final String CLOSE_ACTION_COMMAND = "close";
    public static final String UIPREFIX = "XDialog.";
    protected JComponent content;

    public JXDialog(JComponent content) {
        this.setContent(content);
    }

    public JXDialog(Frame frame, JComponent content) {
        super(frame);
        this.setContent(content);
    }

    public JXDialog(Dialog dialog, JComponent content) {
        super(dialog);
        this.setContent(content);
    }

    private void setContent(JComponent content) {
        Action contentExecuteAction;
        if (this.content != null) {
            throw new IllegalStateException("content must not be set more than once");
        }
        this.initActions();
        Action contentCloseAction = content.getActionMap().get(CLOSE_ACTION_COMMAND);
        if (contentCloseAction != null) {
            this.putAction(CLOSE_ACTION_COMMAND, contentCloseAction);
        }
        if ((contentExecuteAction = content.getActionMap().get(EXECUTE_ACTION_COMMAND)) != null) {
            this.putAction(EXECUTE_ACTION_COMMAND, contentExecuteAction);
        }
        this.content = content;
        this.build();
        this.setTitle(content.getName());
    }

    private void build() {
        Box contentBox = new Box(3);
        contentBox.add(this.content);
        JComponent buttonPanel = this.createButtonPanel();
        contentBox.add(buttonPanel);
        contentBox.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.add(contentBox);
    }

    public void setVisible(boolean visible) {
        if (this.content == null) {
            throw new IllegalStateException("content must be built before showing the dialog");
        }
        super.setVisible(visible);
    }

    public void doClose() {
        this.dispose();
    }

    private void initActions() {
        Action defaultAction = this.createCloseAction();
        this.putAction(CLOSE_ACTION_COMMAND, defaultAction);
        this.putAction(EXECUTE_ACTION_COMMAND, defaultAction);
    }

    private Action createCloseAction() {
        String actionName = this.getUIString(CLOSE_ACTION_COMMAND);
        BoundAction action = new BoundAction(actionName, CLOSE_ACTION_COMMAND);
        action.registerCallback(this, "doClose");
        return action;
    }

    protected JComponent createButtonPanel() {
        JPanel panel = new JPanel(new BasicOptionPaneUI.ButtonAreaLayout(true, 6)){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        panel.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
        Action findAction = this.getAction(EXECUTE_ACTION_COMMAND);
        Action closeAction = this.getAction(CLOSE_ACTION_COMMAND);
        JButton findButton = new JButton(findAction);
        panel.add(findButton);
        if (findAction != closeAction) {
            panel.add(new JButton(closeAction));
        }
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(enterKey, EXECUTE_ACTION_COMMAND);
        inputMap.put(escapeKey, CLOSE_ACTION_COMMAND);
        this.getRootPane().setDefaultButton(findButton);
        return panel;
    }

    private void putAction(Object key, Action action) {
        this.getRootPane().getActionMap().put(key, action);
    }

    private Action getAction(Object key) {
        return this.getRootPane().getActionMap().get(key);
    }

    private String getUIString(String key) {
        String text = UIManager.getString(UIPREFIX + key);
        return text != null ? text : key;
    }

    static {
        LookAndFeelAddons.getAddon();
    }
}

