/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.wizards;

import com.jaspersoft.ireport.JrxmlDataObject;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ui.ResourceChooser;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardDescriptor;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardPanel2;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ReportUnitVisualPanel2
extends JPanel {
    private ReportUnitWizardPanel2 wizardPanel = null;
    private String currentOpenedFile = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonBrowse;
    private JButton jButtonGetCurrentReport;
    private JButton jButtonPickJrxml;
    private JLabel jLabelResourceFile;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonLocal1;
    private JRadioButton jRadioButtonRepo1;
    private JTextField jTextFieldFile;
    private JTextField jTextFieldFileRepo;

    public ReportUnitWizardPanel2 getWizardPanel() {
        return this.wizardPanel;
    }

    public void setWizardPanel(ReportUnitWizardPanel2 wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    public JServer getServer() {
        return this.getWizardPanel().getWizardDescriptor().getServer();
    }

    public String getParentFolder() {
        return this.getWizardPanel().getWizardDescriptor().getParentFolder();
    }

    public ReportUnitVisualPanel2(ReportUnitWizardPanel2 wizardPanel) {
        JrxmlDataObject dobject;
        this.initComponents();
        this.wizardPanel = wizardPanel;
        DocumentListener dl = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                if (ReportUnitVisualPanel2.this.getWizardPanel() != null) {
                    ReportUnitVisualPanel2.this.getWizardPanel().fireChangeEvent();
                }
            }

            public void insertUpdate(DocumentEvent evt) {
                if (ReportUnitVisualPanel2.this.getWizardPanel() != null) {
                    ReportUnitVisualPanel2.this.getWizardPanel().fireChangeEvent();
                }
            }

            public void removeUpdate(DocumentEvent evt) {
                if (ReportUnitVisualPanel2.this.getWizardPanel() != null) {
                    ReportUnitVisualPanel2.this.getWizardPanel().fireChangeEvent();
                }
            }
        };
        this.jTextFieldFile.getDocument().addDocumentListener(dl);
        this.jTextFieldFileRepo.getDocument().addDocumentListener(dl);
        this.jButtonGetCurrentReport.setEnabled(false);
        JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
        if (view != null && view.getLookup() != null && (dobject = (JrxmlDataObject)view.getLookup().lookup(JrxmlDataObject.class)) != null) {
            this.jButtonGetCurrentReport.setEnabled(true);
        }
    }

    public String getName() {
        return JasperServerManager.getString("newReportUnitWizard.step.jrxml", "Main JRXML");
    }

    void validateForm() throws Exception {
        File resourceFile;
        if (this.jRadioButtonRepo1.isSelected() && this.jTextFieldFileRepo.getText().trim().length() == 0) {
            throw new Exception("Please select a valid JRXML resource from the repository.");
        }
        if (this.jRadioButtonLocal1.isSelected() && this.jTextFieldFile.getText().trim().length() == 0 && !(resourceFile = new File(this.jTextFieldFile.getText())).exists()) {
            throw new Exception(JasperServerManager.getFormattedString("newReportUnitWizard.message.fileNotFound", "{0}\n\nFile not found!", new Object[]{this.jTextFieldFile.getText()}));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabelResourceFile = new JLabel();
        this.jRadioButtonRepo1 = new JRadioButton();
        this.jTextFieldFileRepo = new JTextField();
        this.jButtonPickJrxml = new JButton();
        this.jRadioButtonLocal1 = new JRadioButton();
        this.jTextFieldFile = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jButtonGetCurrentReport = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabelResourceFile, (String)"Locate the main JRXML file");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 4, 20, 4);
        this.jPanel1.add((Component)this.jLabelResourceFile, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonRepo1);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonRepo1, (String)"From the repository");
        this.jRadioButtonRepo1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonRepo1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonRepo1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel2.this.jRadioButtonRepo1jRadioButtonRepoActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel1.add((Component)this.jRadioButtonRepo1, gridBagConstraints);
        this.jTextFieldFileRepo.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel1.add((Component)this.jTextFieldFileRepo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonPickJrxml, (String)"Browse");
        this.jButtonPickJrxml.setEnabled(false);
        this.jButtonPickJrxml.setMinimumSize(new Dimension(73, 21));
        this.jButtonPickJrxml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel2.this.jButtonPickJrxmljButton1ActionPerformed12(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        this.jPanel1.add((Component)this.jButtonPickJrxml, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButtonLocal1);
        this.jRadioButtonLocal1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonLocal1, (String)"Locally Defined");
        this.jRadioButtonLocal1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonLocal1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonLocal1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel2.this.jRadioButtonLocal1jRadioButtonLocalActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 4);
        this.jPanel1.add((Component)this.jRadioButtonLocal1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel1.add((Component)this.jTextFieldFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowse, (String)"Browse");
        this.jButtonBrowse.setMinimumSize(new Dimension(73, 21));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel2.this.jButtonBrowseActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        this.jPanel1.add((Component)this.jButtonBrowse, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonGetCurrentReport, (String)"Get source from current opened report");
        this.jButtonGetCurrentReport.setMinimumSize(null);
        this.jButtonGetCurrentReport.setPreferredSize(null);
        this.jButtonGetCurrentReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportUnitVisualPanel2.this.jButtonGetCurrentReportjButton1ActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 30, 2, 0);
        this.jPanel1.add((Component)this.jButtonGetCurrentReport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jRadioButtonRepo1jRadioButtonRepoActionPerformed1(ActionEvent evt) {
        this.updateJrxmlFromType();
    }

    private void jButtonPickJrxmljButton1ActionPerformed12(ActionEvent evt) {
        ResourceChooser rc = new ResourceChooser();
        rc.setServer(this.getServer());
        if (rc.showDialog(this, null) == 0) {
            ResourceDescriptor rd = rc.getSelectedDescriptor();
            if (rd == null || rd.getUriString() == null) {
                this.jTextFieldFileRepo.setText("");
            } else {
                if (!rd.getWsType().equals("jrxml")) {
                    JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getString("newReportUnitWizard.chooseJRXML", "Please choose a JRXML resource"), "", 2);
                    return;
                }
                this.jTextFieldFileRepo.setText(rd.getUriString());
            }
            if (this.wizardPanel != null) {
                this.wizardPanel.fireChangeEvent();
            }
        }
    }

    private void jRadioButtonLocal1jRadioButtonLocalActionPerformed1(ActionEvent evt) {
        this.updateJrxmlFromType();
    }

    private void jButtonBrowseActionPerformed1(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(JasperServerManager.getString("newReportUnitWizard.pickAFile", "Pick a file..."));
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".xml") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
            }

            public String getDescription() {
                return "JasperReports XML *.xml, *.jrxml";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            this.jTextFieldFile.setText(jfc.getSelectedFile() + "");
            if (this.wizardPanel != null) {
                this.wizardPanel.fireChangeEvent();
            }
        }
    }

    private void jButtonGetCurrentReportjButton1ActionPerformed11(ActionEvent evt) {
        JrxmlDataObject dobject;
        JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
        if (view != null && view.getLookup() != null && (dobject = (JrxmlDataObject)view.getLookup().lookup(JrxmlDataObject.class)) != null) {
            this.jTextFieldFile.setText(FileUtil.toFile((FileObject)dobject.getPrimaryFile()) + "");
            this.currentOpenedFile = this.jTextFieldFile.getText();
        }
    }

    void storeSettings(ReportUnitWizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("jrxml_is_local", this.jRadioButtonLocal1.isSelected() + "");
        wizardDescriptor.putProperty("jrxml_file", this.jRadioButtonRepo1.isSelected() ? this.jTextFieldFileRepo.getText() : this.jTextFieldFile.getText());
        if (!this.jRadioButtonRepo1.isSelected() && this.currentOpenedFile != null && this.currentOpenedFile.equals(this.jTextFieldFile.getText())) {
            wizardDescriptor.putProperty("currentlyOpenedFileSelected", "true");
        } else {
            wizardDescriptor.putProperty("currentlyOpenedFileSelected", "false");
        }
    }

    public void updateJrxmlFromType() {
        this.jTextFieldFileRepo.setEnabled(this.jRadioButtonRepo1.isSelected());
        this.jButtonPickJrxml.setEnabled(this.jRadioButtonRepo1.isSelected());
        this.jTextFieldFile.setEnabled(this.jRadioButtonLocal1.isSelected());
        this.jButtonBrowse.setEnabled(this.jRadioButtonLocal1.isSelected());
        this.jButtonGetCurrentReport.setEnabled(this.jRadioButtonLocal1.isSelected());
        if (this.wizardPanel != null) {
            this.wizardPanel.fireChangeEvent();
        }
    }
}

