/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.CreateDomain;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlassfishInstanceProvider
implements ServerInstanceProvider {
    static final String DIR_GLASSFISH_INSTANCES = "/GlassFish/Instances";
    static final String INSTANCE_FO_ATTR = "InstanceFOPath";
    private static GlassfishInstanceProvider singleton;
    private final Map<String, GlassfishInstance> instanceMap = Collections.synchronizedMap(new HashMap());
    private final ChangeSupport support = new ChangeSupport((Object)this);

    private GlassfishInstanceProvider() {
        try {
            this.registerDefaultInstance();
            this.loadServerInstances();
        }
        catch (Exception exception) {
            Logger.getLogger("glassfish").log(Level.INFO, null, exception);
        }
    }

    public static synchronized boolean initialized() {
        return singleton != null;
    }

    public static synchronized GlassfishInstanceProvider getDefault() {
        if (singleton == null) {
            singleton = new GlassfishInstanceProvider();
        }
        return singleton;
    }

    public static Logger getLogger() {
        return Logger.getLogger("glassfish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerInstance(GlassfishInstance glassfishInstance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                this.instanceMap.put(glassfishInstance.getDeployerUri(), glassfishInstance);
                this.writeInstanceToFile(glassfishInstance);
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish").log(Level.INFO, null, iOException);
            }
        }
        this.support.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerInstance(GlassfishInstance glassfishInstance) {
        boolean bl = false;
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            if (this.instanceMap.remove(glassfishInstance.getDeployerUri()) != null) {
                bl = true;
                this.removeInstanceFromFile(glassfishInstance.getDeployerUri());
            }
        }
        if (bl) {
            this.support.fireChange();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookupFor(ServerInstance serverInstance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                if (!glassfishInstance.getCommonInstance().equals(serverInstance)) continue;
                return glassfishInstance.getLookup();
            }
            return null;
        }
    }

    public ServerInstanceImplementation getInternalInstance(String string) {
        return this.instanceMap.get(string);
    }

    public <T> T getInstanceByCapability(String string, Class<T> clazz) {
        Object object = null;
        GlassfishInstance glassfishInstance = this.instanceMap.get(string);
        if (glassfishInstance != null) {
            object = glassfishInstance.getLookup().lookup(clazz);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getInstancesByCapability(Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                Object object = glassfishInstance.getLookup().lookup(clazz);
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInstance> getInstances() {
        ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                arrayList.add(glassfishInstance.getCommonInstance());
            }
        }
        return arrayList;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.support.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.support.removeChangeListener(changeListener);
    }

    public boolean hasServer(String string) {
        return this.getInstance(string) != null;
    }

    public ServerInstance getInstance(String string) {
        GlassfishInstance glassfishInstance = this.instanceMap.get(string);
        return glassfishInstance == null ? null : glassfishInstance.getCommonInstance();
    }

    Collection<GlassfishInstance> getInternalInstances() {
        return this.instanceMap.values();
    }

    private void loadServerInstances() {
        FileObject[] fileObjectArray;
        FileObject fileObject = this.getRepositoryDir(DIR_GLASSFISH_INSTANCES, false);
        if (fileObject != null && (fileObjectArray = fileObject.getChildren()) != null && fileObjectArray.length > 0) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                try {
                    GlassfishInstance glassfishInstance = this.readInstanceFromFile(fileObjectArray[i]);
                    if (glassfishInstance != null) {
                        this.instanceMap.put(glassfishInstance.getDeployerUri(), glassfishInstance);
                        continue;
                    }
                    Logger.getLogger("glassfish").finer("Unable to create glassfish instance for " + fileObjectArray[i].getPath());
                    continue;
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish").log(Level.INFO, null, iOException);
                }
            }
        }
    }

    private GlassfishInstance readInstanceFromFile(FileObject fileObject) throws IOException {
        GlassfishInstance glassfishInstance = null;
        String string = GlassfishInstanceProvider.getStringAttribute(fileObject, "installfolder");
        String string2 = GlassfishInstanceProvider.getStringAttribute(fileObject, "homefolder");
        if (string == null) {
            string = string2;
        }
        if (GlassfishInstanceProvider.isValidHomeFolder(string) && GlassfishInstanceProvider.isValidGlassfishFolder(string2)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration enumeration = fileObject.getAttributes();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = GlassfishInstanceProvider.getStringAttribute(fileObject, string3);
                hashMap.put(string3, string4);
            }
            hashMap.put(INSTANCE_FO_ATTR, fileObject.getName());
            glassfishInstance = GlassfishInstance.create(hashMap);
        } else {
            Logger.getLogger("glassfish").finer("GlassFish folder " + fileObject.getPath() + " is not a valid V3 install.");
            fileObject.delete();
        }
        return glassfishInstance;
    }

    private void writeInstanceToFile(GlassfishInstance glassfishInstance) throws IOException {
        String string = glassfishInstance.getGlassfishRoot();
        if (string == null) {
            GlassfishInstanceProvider.getLogger().log(Level.SEVERE, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"MSG_NullServerFolder"));
            return;
        }
        String string2 = glassfishInstance.getDeployerUri();
        FileObject fileObject = this.getRepositoryDir(DIR_GLASSFISH_INSTANCES, true);
        FileObject[] fileObjectArray = fileObject.getChildren();
        FileObject fileObject2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!string2.equals(fileObjectArray[i].getAttribute("url"))) continue;
            fileObject2 = fileObjectArray[i];
        }
        if (fileObject2 == null) {
            String string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"instance", null);
            fileObject2 = fileObject.createData(string3);
        }
        CommonServerSupport commonServerSupport = glassfishInstance.getCommonSupport();
        Map<String, String> map = commonServerSupport.getInstanceProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string4 = entry.getKey();
            if (GlassfishInstanceProvider.filterKey(string4)) continue;
            fileObject2.setAttribute(string4, (Object)entry.getValue());
        }
        commonServerSupport.setProperty(INSTANCE_FO_ATTR, fileObject2.getName());
        commonServerSupport.setFileObject(fileObject2);
    }

    private static boolean filterKey(String string) {
        return INSTANCE_FO_ATTR.equals(string);
    }

    private void removeInstanceFromFile(String string) {
        FileObject fileObject = this.getInstanceFileObject(string);
        if (fileObject != null && fileObject.isValid()) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
            }
        }
    }

    private FileObject getInstanceFileObject(String string) {
        FileObject fileObject = this.getRepositoryDir(DIR_GLASSFISH_INSTANCES, false);
        if (fileObject != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string2 = GlassfishInstanceProvider.getStringAttribute(fileObjectArray[i], "url");
                if (string2 == null || !string2.equals(string)) continue;
                return fileObjectArray[i];
            }
        }
        return null;
    }

    private FileObject getRepositoryDir(String string, boolean bl) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject == null && bl) {
            try {
                fileObject = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)string);
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
            }
        }
        return fileObject;
    }

    private static boolean isValidHomeFolder(String string) {
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            bl = file.exists();
        }
        return bl;
    }

    private static boolean isValidGlassfishFolder(String string) {
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            bl = file.exists();
        }
        return bl;
    }

    private static String getStringAttribute(FileObject fileObject, String string) {
        return GlassfishInstanceProvider.getStringAttribute(fileObject, string, null);
    }

    private static String getStringAttribute(FileObject fileObject, String string, String string2) {
        String string3 = string2;
        Object object = fileObject.getAttribute(string);
        if (object instanceof String) {
            string3 = (String)object;
        }
        return string3;
    }

    private static int getIntAttribute(FileObject fileObject, String string, int n) {
        int n2 = n;
        String string2 = GlassfishInstanceProvider.getStringAttribute(fileObject, string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger("glassfish").log(Level.FINER, numberFormatException.getLocalizedMessage(), numberFormatException);
            }
        }
        return n2;
    }

    private void registerDefaultInstance() {
        boolean bl;
        boolean bl2 = bl = !NbPreferences.forModule(this.getClass()).getBoolean("first_run", false);
        if (bl) {
            try {
                String string = System.getProperty("org.glassfish.v3.installRoot");
                if (null != string) {
                    File file = new File(string);
                    if (GlassfishInstanceProvider.isValidHomeFolder(string) && file.exists()) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("installfolder", file.getCanonicalPath());
                        hashMap.put("homefolder", file.getCanonicalPath() + File.separator + "glassfish");
                        if (file.canWrite()) {
                            hashMap.put("displayName", NbBundle.getMessage(this.getClass(), (String)"DEFAULT_DOMAIN_NAME"));
                            hashMap.put("httpportnumber", Integer.toString(8080));
                            hashMap.put("adminPort", Integer.toString(4848));
                            GlassfishInstance glassfishInstance = GlassfishInstance.create(hashMap);
                            this.addServerInstance(glassfishInstance);
                            NbPreferences.forModule(this.getClass()).putBoolean("first_run", true);
                        } else {
                            hashMap.put("displayName", NbBundle.getMessage(this.getClass(), (String)"PERSONAL_DOMAIN_NAME"));
                            String string2 = System.getProperty("netbeans.user");
                            String string3 = "GlassfishV3Domain";
                            hashMap.put("domainsfolder", string2);
                            hashMap.put("domainname", string3);
                            CreateDomain createDomain = new CreateDomain("anonymous", "", new File(file, "glassfish"), hashMap);
                            createDomain.start();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }
}

