/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRTemplateGraphicElement
extends JRTemplateElement
implements JRCommonGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected JRPen linePen = null;
    private FillEnum fillValue = null;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private Byte pen;
    private Byte fill;

    protected JRTemplateGraphicElement(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
    }

    protected JRTemplateGraphicElement(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRGraphicElement graphicElement) {
        super(origin, defaultStyleProvider);
        this.setGraphicElement(graphicElement);
    }

    protected void setGraphicElement(JRGraphicElement graphicElement) {
        super.setElement(graphicElement);
        this.copyLinePen(graphicElement.getLinePen());
        this.setFill(graphicElement.getOwnFillValue());
    }

    public void copyLinePen(JRPen pen) {
        this.linePen = pen.clone(this);
    }

    public JRPen getLinePen() {
        return this.linePen;
    }

    public byte getPen() {
        return JRPenUtil.getPenFromLinePen(this.linePen);
    }

    public Byte getOwnPen() {
        return JRPenUtil.getOwnPenFromLinePen(this.linePen);
    }

    public void setPen(byte pen) {
        this.setPen(new Byte(pen));
    }

    public void setPen(Byte pen) {
        JRPenUtil.setLinePenFromPen(pen, this.linePen);
    }

    public byte getFill() {
        return this.getFillValue().getValue();
    }

    public Byte getOwnFill() {
        return this.getOwnFillValue().getValueByte();
    }

    public void setFill(byte fill) {
        this.setFill(FillEnum.getByValue(fill));
    }

    public void setFill(Byte fill) {
        this.setFill(FillEnum.getByValue(fill));
    }

    public FillEnum getFillValue() {
        return JRStyleResolver.getFillValue(this);
    }

    public FillEnum getOwnFillValue() {
        return this.fillValue;
    }

    public void setFill(FillEnum fillValue) {
        this.fillValue = fillValue;
    }

    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.fillValue = FillEnum.getByValue(this.fill);
            this.fill = null;
        }
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
    }
}

