/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.fill.JRFillPieSeries;
import net.sf.jasperreports.charts.util.PieLabelGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;

public class JRFillPieDataset
extends JRFillChartDataset
implements JRPieDataset {
    protected JRFillPieSeries[] pieSeries = null;
    private Map values = null;
    private Map labels = null;
    private Map sectionHyperlinks;
    private Comparable otherKey = null;
    private String otherLabel = null;
    private JRPrintHyperlink otherSectionHyperlink;

    public JRFillPieDataset(JRPieDataset pieDataset, JRFillObjectFactory factory) {
        super(pieDataset, factory);
        JRPieSeries[] srcPieSeries = pieDataset.getSeries();
        if (srcPieSeries != null && srcPieSeries.length > 0) {
            this.pieSeries = new JRFillPieSeries[srcPieSeries.length];
            for (int i = 0; i < this.pieSeries.length; ++i) {
                this.pieSeries[i] = (JRFillPieSeries)factory.getPieSeries(srcPieSeries[i]);
            }
        }
    }

    public Float getMinPercentage() {
        return ((JRPieDataset)this.parent).getMinPercentage();
    }

    public void setMinPercentage(Float minPercentage) {
    }

    public Integer getMaxCount() {
        return ((JRPieDataset)this.parent).getMaxCount();
    }

    public void setMaxCount(Integer maxCount) {
    }

    public JRPieSeries[] getSeries() {
        return this.pieSeries;
    }

    public JRExpression getKeyExpression() {
        return ((JRPieDataset)this.parent).getKeyExpression();
    }

    public JRExpression getValueExpression() {
        return ((JRPieDataset)this.parent).getValueExpression();
    }

    public JRExpression getLabelExpression() {
        return ((JRPieDataset)this.parent).getLabelExpression();
    }

    public JRHyperlink getSectionHyperlink() {
        return ((JRPieDataset)this.parent).getSectionHyperlink();
    }

    public JRExpression getOtherKeyExpression() {
        return ((JRPieDataset)this.parent).getOtherKeyExpression();
    }

    public JRExpression getOtherLabelExpression() {
        return ((JRPieDataset)this.parent).getOtherLabelExpression();
    }

    public JRHyperlink getOtherSectionHyperlink() {
        return ((JRPieDataset)this.parent).getOtherSectionHyperlink();
    }

    protected void customInitialize() {
        this.values = new LinkedHashMap();
        this.labels = new HashMap();
        this.sectionHyperlinks = new HashMap();
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.pieSeries != null && this.pieSeries.length > 0) {
            for (int i = 0; i < this.pieSeries.length; ++i) {
                this.pieSeries[i].evaluate(calculator);
            }
        }
        this.otherKey = (String)calculator.evaluate(this.getOtherKeyExpression());
        this.otherLabel = (String)calculator.evaluate(this.getOtherLabelExpression());
        if (!JRHyperlinkHelper.isEmpty(this.getOtherSectionHyperlink())) {
            this.evaluateOtherSectionHyperlink(calculator);
        }
    }

    protected void evaluateOtherSectionHyperlink(JRCalculator calculator) throws JRExpressionEvalException {
        try {
            this.otherSectionHyperlink = JRFillHyperlinkHelper.evaluateHyperlink(this.getOtherSectionHyperlink(), calculator, (byte)3);
        }
        catch (JRExpressionEvalException e) {
            throw e;
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void customIncrement() {
        if (this.pieSeries != null && this.pieSeries.length > 0) {
            for (int i = 0; i < this.pieSeries.length; ++i) {
                JRFillPieSeries crtPieSeries = this.pieSeries[i];
                Comparable key = crtPieSeries.getKey();
                if (key == null) {
                    throw new JRRuntimeException("Key is null in pie dataset.");
                }
                this.values.put(key, crtPieSeries.getValue());
                if (crtPieSeries.getLabelExpression() != null) {
                    this.labels.put(key, crtPieSeries.getLabel());
                }
                if (!crtPieSeries.hasSectionHyperlinks()) continue;
                this.sectionHyperlinks.put(key, crtPieSeries.getPrintSectionHyperlink());
            }
        }
    }

    public Dataset getCustomDataset() {
        double total = 0.0;
        ArrayList<Number> sortedValues = new ArrayList<Number>();
        for (Number value : this.values.values()) {
            total += value.doubleValue();
            sortedValues.add(value);
        }
        Collections.sort(sortedValues);
        Number minValue = null;
        if (this.getMinPercentage() != null && this.getMinPercentage().intValue() >= 0 && this.getMinPercentage().intValue() <= 100) {
            minValue = new Double((double)this.getMinPercentage().floatValue() * total / 100.0);
        }
        if (this.getMaxCount() != null && this.getMaxCount() >= 0 && this.getMaxCount() <= this.values.size()) {
            Number minValue2 = (Number)sortedValues.get(sortedValues.size() - this.getMaxCount());
            minValue = minValue != null && minValue.doubleValue() > minValue2.doubleValue() ? (Number)minValue : (Number)minValue2;
        }
        int otherCount = 0;
        Comparable lastOtherKey = null;
        Number lastOtherValue = null;
        double otherTotal = 0.0;
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Comparable key : this.values.keySet()) {
            Number value = (Number)this.values.get(key);
            if (minValue == null || value.doubleValue() >= minValue.doubleValue()) {
                dataset.setValue(key, value);
                continue;
            }
            ++otherCount;
            lastOtherKey = key;
            lastOtherValue = value;
            otherTotal += value.doubleValue();
        }
        if (otherCount == 1) {
            dataset.setValue(lastOtherKey, lastOtherValue);
        } else if (otherCount > 1) {
            this.otherKey = this.otherKey == null ? "Other" : this.otherKey;
            dataset.setValue(this.otherKey, (Number)new Double(otherTotal));
            this.labels.put(this.otherKey, this.otherLabel);
            if (!JRHyperlinkHelper.isEmpty(this.getOtherSectionHyperlink())) {
                this.sectionHyperlinks.put(this.otherKey, this.otherSectionHyperlink);
            }
        }
        return dataset;
    }

    public byte getDatasetType() {
        return 1;
    }

    public Object getLabelGenerator() {
        return this.getLabelExpression() == null ? null : new PieLabelGenerator(this.labels);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Map getSectionHyperlinks() {
        return this.sectionHyperlinks;
    }

    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }
}

