/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETableColumn
extends TableColumn
implements Comparable<ETableColumn> {
    private static final String PROP_PREFIX = "ETableColumn-";
    private static final String PROP_WIDTH = "Width";
    private static final String PROP_PREFERRED_WIDTH = "PreferredWidth";
    private static final String PROP_SORT_RANK = "SortRank";
    private static final String PROP_COMPARATOR = "Comparator";
    private static final String PROP_HEADER_VALUE = "HeaderValue";
    private static final String PROP_MODEL_INDEX = "ModelIndex";
    private static final String PROP_ASCENDING = "Ascending";
    private int sortRank = 0;
    private Comparator<ETable.RowMapping> comparator;
    private boolean ascending = true;
    private boolean headerRendererSetExternally = false;
    private ETable table;
    private Icon customIcon;
    private TableCellRenderer myHeaderRenderer;

    public ETableColumn(ETable eTable) {
        this.table = eTable;
    }

    public ETableColumn(int n, ETable eTable) {
        super(n);
        this.table = eTable;
    }

    public ETableColumn(int n, int n2, ETable eTable) {
        super(n, n2);
        this.table = eTable;
    }

    public ETableColumn(int n, int n2, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor, ETable eTable) {
        super(n, n2, tableCellRenderer, tableCellEditor);
        this.table = eTable;
    }

    void setSorted(int n, boolean bl) {
        if (!(this.isSortingAllowed() || n == 0 && this.comparator == null)) {
            throw new IllegalStateException("Cannot sort an unsortable column.");
        }
        this.ascending = bl;
        this.sortRank = n;
        this.comparator = n != 0 ? this.getRowComparator(this.getModelIndex(), bl) : null;
    }

    public boolean isSorted() {
        return this.comparator != null;
    }

    void setSortRank(int n) {
        if (!this.isSortingAllowed() && n != 0) {
            throw new IllegalStateException("Cannot sort an unsortable column.");
        }
        this.sortRank = n;
    }

    public int getSortRank() {
        return this.sortRank;
    }

    Comparator<ETable.RowMapping> getComparator() {
        return this.comparator;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    void setAscending(boolean bl) {
        if (!this.isSortingAllowed()) {
            throw new IllegalStateException("Cannot sort an unsortable column.");
        }
        if (!this.isSorted()) {
            return;
        }
        if (this.ascending == bl) {
            return;
        }
        Comparator<ETable.RowMapping> comparator = this.getRowComparator(this.getModelIndex(), bl);
        if (comparator == null) {
            throw new IllegalStateException("getRowComparator returned null for " + this);
        }
        this.ascending = bl;
        this.comparator = comparator;
    }

    @Override
    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        this.headerRendererSetExternally = true;
        super.setHeaderRenderer(tableCellRenderer);
    }

    @Override
    public TableCellRenderer getHeaderRenderer() {
        if (this.headerRendererSetExternally) {
            return super.getHeaderRenderer();
        }
        return this.createDefaultHeaderRenderer();
    }

    public boolean isHidingAllowed() {
        return true;
    }

    public boolean isSortingAllowed() {
        return true;
    }

    public void setCustomIcon(Icon icon) {
        this.customIcon = icon;
    }

    void updatePreferredWidth(JTable jTable, boolean bl) {
        TableModel tableModel = jTable.getModel();
        int n = tableModel.getRowCount();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 15;
        for (int i = 0; i < n; ++i) {
            Object object = tableModel.getValueAt(i, this.modelIndex);
            int n4 = this.estimatedWidth(object, jTable);
            n2 += n4;
            if (n4 <= n3) continue;
            n3 = n4;
        }
        this.setPreferredWidth(n3 += 5);
        if (bl) {
            this.resize(n3, jTable);
        }
    }

    private void resize(int n, JTable jTable) {
        Container container;
        int n2 = this.getWidth();
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (jTableHeader == null) {
            return;
        }
        jTableHeader.setResizingColumn(this);
        final int n3 = this.getMinWidth();
        final int n4 = this.getMaxWidth();
        this.setMinWidth(n);
        this.setMaxWidth(n);
        this.setWidth(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ETableColumn.this.setMinWidth(n3);
                ETableColumn.this.setMaxWidth(n4);
            }
        });
        if (jTableHeader.getParent() == null || (container = jTableHeader.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
            jTableHeader.setResizingColumn(null);
            return;
        }
        if (!container.getComponentOrientation().isLeftToRight() && !jTableHeader.getComponentOrientation().isLeftToRight() && jTable != null) {
            JViewport jViewport = ((JScrollPane)container).getViewport();
            int n5 = jViewport.getWidth();
            int n6 = n - n2;
            int n7 = jTable.getWidth() + n6;
            Dimension dimension = jTable.getSize();
            dimension.width += n6;
            jTable.setSize(dimension);
            if (n7 >= n5 && jTable.getAutoResizeMode() == 0) {
                Point point = jViewport.getViewPosition();
                point.x = Math.max(0, Math.min(n7 - n5, point.x + n6));
                jViewport.setViewPosition(point);
            }
        }
        jTableHeader.setResizingColumn(null);
    }

    private int estimatedWidth(Object object, JTable jTable) {
        Serializable serializable;
        TableCellRenderer tableCellRenderer = this.getCellRenderer();
        if (tableCellRenderer == null) {
            serializable = jTable.getModel().getColumnClass(this.modelIndex);
            tableCellRenderer = jTable.getDefaultRenderer((Class<?>)serializable);
        }
        serializable = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, jTable.getColumnModel().getColumnIndex(this.getIdentifier()));
        return ((Component)serializable).getPreferredSize().width;
    }

    public void readSettings(Properties properties, int n, String string) {
        String string2;
        String string3;
        String string4;
        String string5 = string + PROP_PREFIX + Integer.toString(n) + "-";
        String string6 = properties.getProperty(string5 + PROP_MODEL_INDEX);
        if (string6 != null) {
            this.modelIndex = Integer.parseInt(string6);
        }
        if ((string4 = properties.getProperty(string5 + PROP_WIDTH)) != null) {
            this.width = Integer.parseInt(string4);
        }
        if ((string3 = properties.getProperty(string5 + PROP_PREFERRED_WIDTH)) != null) {
            this.setPreferredWidth(Integer.parseInt(string3));
        }
        this.ascending = true;
        String string7 = properties.getProperty(string5 + PROP_ASCENDING);
        if ("false".equals(string7)) {
            this.ascending = false;
        }
        if ((string2 = properties.getProperty(string5 + PROP_SORT_RANK)) != null) {
            this.sortRank = Integer.parseInt(string2);
            if (this.sortRank > 0) {
                this.comparator = this.getRowComparator(this.modelIndex, this.ascending);
            }
        }
        this.headerValue = properties.getProperty(string5 + PROP_HEADER_VALUE);
    }

    public void writeSettings(Properties properties, int n, String string) {
        String string2 = string + PROP_PREFIX + Integer.toString(n) + "-";
        properties.setProperty(string2 + PROP_MODEL_INDEX, Integer.toString(this.modelIndex));
        properties.setProperty(string2 + PROP_WIDTH, Integer.toString(this.width));
        properties.setProperty(string2 + PROP_PREFERRED_WIDTH, Integer.toString(this.getPreferredWidth()));
        properties.setProperty(string2 + PROP_SORT_RANK, Integer.toString(this.sortRank));
        properties.setProperty(string2 + PROP_ASCENDING, this.ascending ? "true" : "false");
        if (this.headerValue != null) {
            properties.setProperty(string2 + PROP_HEADER_VALUE, this.headerValue.toString());
        }
    }

    @Override
    public int compareTo(ETableColumn eTableColumn) {
        if (this.modelIndex < eTableColumn.modelIndex) {
            return -1;
        }
        if (this.modelIndex > eTableColumn.modelIndex) {
            return 1;
        }
        return 0;
    }

    protected Comparator<ETable.RowMapping> getRowComparator(int n, boolean bl) {
        if (bl) {
            return new RowComparator(n);
        }
        return new FlippingComparator(new RowComparator(n));
    }

    @Override
    protected TableCellRenderer createDefaultHeaderRenderer() {
        if (this.myHeaderRenderer == null) {
            this.myHeaderRenderer = new ETableHeaderRenderer();
        }
        return this.myHeaderRenderer;
    }

    private static final Icon mergeIcons(Icon icon, Icon icon2, int n, int n2, Component component) {
        int n3 = 0;
        int n4 = 0;
        if (icon != null) {
            n3 = icon.getIconWidth();
            n4 = icon.getIconHeight();
        }
        if (icon2 != null) {
            n3 = icon2.getIconWidth() + n > n3 ? icon2.getIconWidth() + n : n3;
            int n5 = n4 = icon2.getIconHeight() + n2 > n4 ? icon2.getIconHeight() + n2 : n4;
        }
        if (n3 < 1) {
            n3 = 16;
        }
        if (n4 < 1) {
            n4 = 16;
        }
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n4), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (icon != null) {
            icon.paintIcon(component, graphics2D, 0, 0);
        }
        if (icon2 != null) {
            icon2.paintIcon(component, graphics2D, n, n2);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RowComparator
    implements Comparator<ETable.RowMapping> {
        protected int column;

        public RowComparator(int n) {
            this.column = n;
        }

        @Override
        public int compare(ETable.RowMapping rowMapping, ETable.RowMapping rowMapping2) {
            Object object = rowMapping.getModelObject(this.column);
            Object object2 = rowMapping2.getModelObject(this.column);
            object = ETableColumn.this.table.transformValue(object);
            object2 = ETableColumn.this.table.transformValue(object2);
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
                Comparable comparable = (Comparable)object;
                return comparable.compareTo(object2);
            }
            return object.toString().compareTo(object2.toString());
        }
    }

    private class ETableHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private TableCellRenderer headerRenderer = new JTable().getTableHeader().getDefaultRenderer();

        private ETableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                Object object2;
                JLabel jLabel = (JLabel)component;
                String string = "";
                if (object != null) {
                    string = object.toString();
                }
                if (jTable instanceof ETable) {
                    object2 = (ETable)jTable;
                    string = ((ETable)object2).getColumnDisplayName(string);
                }
                object2 = null;
                if (ETableColumn.this.sortRank != 0) {
                    jLabel.setText(object == null ? Integer.toString(ETableColumn.this.sortRank) : ETableColumn.this.sortRank + " " + string);
                    if (ETableColumn.this.ascending) {
                        object2 = UIManager.getIcon("ETableHeader.ascendingIcon");
                        if (object2 == null) {
                            object2 = new SortUpIcon();
                        }
                    } else {
                        object2 = UIManager.getIcon("ETableHeader.descendingIcon");
                        if (object2 == null) {
                            object2 = new SortDownIcon();
                        }
                    }
                } else {
                    jLabel.setText(string);
                }
                if (object2 == null) {
                    if (ETableColumn.this.customIcon == null) {
                        Icon icon = new Icon(){

                            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                            }

                            public int getIconWidth() {
                                return 0;
                            }

                            public int getIconHeight() {
                                return 0;
                            }
                        };
                        jLabel.setIcon(icon);
                    } else {
                        jLabel.setIcon(ETableColumn.this.customIcon);
                    }
                } else if (ETableColumn.this.customIcon == null) {
                    jLabel.setIcon((Icon)object2);
                } else {
                    jLabel.setIcon(ETableColumn.mergeIcons(ETableColumn.this.customIcon, (Icon)object2, 16, 0, this));
                }
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FlippingComparator
    implements Comparator<ETable.RowMapping> {
        private Comparator<ETable.RowMapping> origComparator;

        public FlippingComparator(Comparator<ETable.RowMapping> comparator) {
            this.origComparator = comparator;
        }

        @Override
        public int compare(ETable.RowMapping rowMapping, ETable.RowMapping rowMapping2) {
            return -this.origComparator.compare(rowMapping, rowMapping2);
        }

        public Comparator<ETable.RowMapping> getOriginalComparator() {
            return this.origComparator;
        }
    }

    private static class SortDownIcon
    implements Icon {
        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 8;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2 + 6, n + 8, n2 + 6);
            graphics.drawLine(n, n2 + 6, n + 4, n2 + 2);
            graphics.drawLine(n + 8, n2 + 6, n + 4, n2 + 2);
        }
    }

    private static class SortUpIcon
    implements Icon {
        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 8;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2 + 2, n + 8, n2 + 2);
            graphics.drawLine(n, n2 + 2, n + 4, n2 + 6);
            graphics.drawLine(n + 8, n2 + 2, n + 4, n2 + 6);
        }
    }
}

