/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.languages.ParseException;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.Folds;
import org.netbeans.modules.languages.features.LocalizationSupport;

public class ExpandFoldTypeAction
extends BaseAction {
    public ExpandFoldTypeAction(String string) {
        super(string);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        try {
            String string = (String)jTextComponent.getDocument().getProperty("mimeType");
            Language language = LanguagesManager.getDefault().getLanguage(string);
            if (this.expand(foldHierarchy, language)) {
                return;
            }
            Iterator<Language> iterator = language.getImportedLanguages().iterator();
            while (iterator.hasNext()) {
                if (!this.expand(foldHierarchy, iterator.next())) continue;
                return;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private boolean expand(FoldHierarchy foldHierarchy, Language language) {
        List<Feature> list = language.getFeatureList().getFeatures("FOLD");
        for (Feature feature : list) {
            String string;
            String string2 = LocalizationSupport.localize(language, (String)feature.getValue("expand_type_action_name"));
            if (string2 == null || !string2.equals(this.getValue("Name")) || (string = LocalizationSupport.localize(language, (String)feature.getValue("collapse_type_action_name"))) == null) continue;
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(Folds.getFoldType(string));
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, arrayList);
            return true;
        }
        return false;
    }
}

