/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.DialogStream;
import nickyb.sqleonardo.environment.ctrl.content.TaskRetrieve;
import nickyb.sqleonardo.environment.ctrl.editor._TaskSource;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.environment.mdi.MDIMenubar;

public class ClientContent
extends MDIClient {
    public static final String DEFAULT_TITLE = "content";
    private ContentPane control;
    private JMenuItem[] m_actions;
    private Toolbar toolbar;

    public ClientContent(String title, _TaskSource query, boolean readonly, boolean retrieve) {
        super(title == null ? DEFAULT_TITLE : title);
        this.setMaximizable(true);
        this.setResizable(true);
        this.control = new ContentPane(query, readonly, retrieve);
        this.setComponentCenter(this.control);
        this.control.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setDefaultCloseOperation(0);
        InternalFrameAdapter ifl = new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent evt) {
                if (!ClientContent.this.control.isBusy() && !ClientContent.this.control.isReadOnly() && ClientContent.this.control.getView().getChanges().count() > 0) {
                    int option = JOptionPane.showConfirmDialog(Application.window, "do you want save changes?", "SQLeonardo", 1);
                    if (option == 0) {
                        ClientContent.this.control.getActionMap().get("changes-save").actionPerformed(null);
                    } else if (option == 2) {
                        return;
                    }
                }
                ClientContent.this.control.onEndTask();
                ClientContent.this.dispose();
            }
        };
        this.addInternalFrameListener(ifl);
        this.createToolbar();
        this.initMenuActions();
    }

    private void createToolbar() {
        this.toolbar = new Toolbar(0);
        this.toolbar.add(this.control.getActionMap().get("changes-save"));
        this.toolbar.addSeparator();
        this.toolbar.add(this.control.getActionMap().get("record-insert"));
        this.toolbar.add(this.control.getActionMap().get("record-delete"));
        this.toolbar.addSeparator();
        this.toolbar.add(this.control.getActionMap().get("stop-task"));
        this.setComponentEast(this.toolbar);
    }

    private void initMenuActions() {
        this.m_actions = new JMenuItem[]{MDIMenubar.createItem(this.control.getActionMap().get("changes-show")), null, MDIMenubar.createItem(new ActionShowExport()), MDIMenubar.createItem(new ActionShowImport()), null, MDIMenubar.createItem(new ActionRelaunch())};
    }

    protected String getMessage() {
        int rows = this.control.getView().getRowCount();
        if (rows == 0) {
            return null;
        }
        String first = this.control.getView().getValueAt(0, 0).toString();
        String last = this.control.getView().getValueAt(rows - 1, 0).toString();
        return "block " + this.control.getView().getBlock() + " of " + this.control.getView().getBlockCount() + " - record(s) " + first + " to " + last + " of " + this.control.getView().getFlatRowCount();
    }

    public JMenuItem[] getMenuActions() {
        return this.m_actions;
    }

    public Toolbar getSubToolbar() {
        return this.toolbar;
    }

    protected void setPreferences() {
    }

    private class ActionShowExport
    extends AbstractAction {
        ActionShowExport() {
            this.putValue("Name", "export...");
        }

        public void actionPerformed(ActionEvent ae) {
            int pos1 = ClientContent.this.getTitle().indexOf(58);
            int pos2 = ClientContent.this.getTitle().lastIndexOf(58);
            String name = ClientContent.this.getTitle().substring(pos1 + 1, pos2);
            DialogStream.showExport(ClientContent.this.control.getView(), name.trim());
        }
    }

    private class ActionShowImport
    extends AbstractAction {
        ActionShowImport() {
            this.putValue("Name", "import...");
            this.setEnabled(!ClientContent.this.control.isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            int pos1 = ClientContent.this.getTitle().indexOf(58);
            int pos2 = ClientContent.this.getTitle().lastIndexOf(58);
            String content = ClientContent.this.getTitle().substring(pos1 + 1, pos2);
            DialogStream.showImport(ClientContent.this.control.getView(), content.trim());
        }
    }

    private class ActionRelaunch
    extends AbstractAction {
        ActionRelaunch() {
            this.putValue("Name", "relaunch query");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        }

        public void actionPerformed(ActionEvent ae) {
            if (!ClientContent.this.control.isBusy()) {
                TaskRetrieve task = new TaskRetrieve(ClientContent.this.control, ClientContent.this.control.getTaskSource());
                ClientContent.this.control.getView().reset();
                ClientContent.this.control.onBeginTask(task);
            }
        }
    }
}

