/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.EventQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.refactoring.api.impl.ActionsImplementationFactory;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.spi.impl.RefactoringGlobalAction;
import org.openide.explorer.ExtendedDelete;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SafeDeleteAction
extends RefactoringGlobalAction
implements ExtendedDelete {
    private static final Logger LOGGER = Logger.getLogger(SafeDeleteAction.class.getName());
    private boolean regularDelete = false;

    public SafeDeleteAction() {
        super(NbBundle.getMessage(SafeDeleteAction.class, (String)"LBL_SafeDel_Action"), null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public final void performAction(Lookup lookup) {
        ActionsImplementationFactory.doDelete(lookup);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "SafeDeleteAction.performAction", new Exception());
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Lookup lookup) {
        return ActionsImplementationFactory.canDelete(lookup);
    }

    protected Lookup getLookup(Node[] nodeArray) {
        Lookup lookup = super.getLookup(nodeArray);
        if (this.regularDelete) {
            ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
            if (explorerContext != null) {
                explorerContext.setDelete(true);
            } else {
                explorerContext = new ExplorerContext();
                explorerContext.setDelete(true);
                return new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)explorerContext)});
            }
        }
        return lookup;
    }

    public boolean delete(final Node[] nodeArray) {
        if (this.enable(nodeArray)) {
            if (EventQueue.isDispatchThread()) {
                this.regularDelete = true;
                this.performAction(nodeArray);
                this.regularDelete = false;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SafeDeleteAction.this.regularDelete = true;
                        SafeDeleteAction.this.performAction(nodeArray);
                        SafeDeleteAction.this.regularDelete = false;
                    }
                });
            }
            return true;
        }
        return false;
    }
}

