/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;

public class ToolTipSupport
extends MouseAdapter
implements MouseMotionListener,
ActionListener,
PropertyChangeListener,
FocusListener {
    public static final String PROP_TOOL_TIP = "toolTip";
    public static final String PROP_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROP_STATUS = "status";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_INITIAL_DELAY = "initialDelay";
    public static final String PROP_DISMISS_DELAY = "dismissDelay";
    private static final String UI_PREFIX = "ToolTip";
    public static final int INITIAL_DELAY = 200;
    public static final int DISMISS_DELAY = 60000;
    public static final int STATUS_HIDDEN = 0;
    public static final int STATUS_VISIBILITY_ENABLED = 1;
    public static final int STATUS_TEXT_VISIBLE = 2;
    public static final int STATUS_COMPONENT_VISIBLE = 3;
    private static final int MOUSE_EXTRA_HEIGHT = 5;
    private static final String HTML_PREFIX_LOWERCASE = "<html";
    private static final String HTML_PREFIX_UPPERCASE = "<HTML";
    private EditorUI extEditorUI;
    private JComponent toolTip;
    private String toolTipText;
    private Timer enterTimer;
    private Timer exitTimer;
    private boolean enabled;
    private int status;
    private MouseEvent lastMouseEvent;
    private PropertyChangeSupport pcs;
    private PopupManager.HorizontalBounds horizontalBounds = PopupManager.ViewPortBounds;
    private PopupManager.Placement placement = PopupManager.AbovePreferred;
    private int verticalAdjustment;
    private int horizontalAdjustment;
    private boolean glyphListenerAdded = false;

    public ToolTipSupport(EditorUI editorUI) {
        this.extEditorUI = editorUI;
        this.enterTimer = new Timer(200, new WeakTimerListener(this));
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(60000, new WeakTimerListener(this));
        this.exitTimer.setRepeats(false);
        editorUI.addPropertyChangeListener(this);
        this.setEnabled(true);
    }

    public final JComponent getToolTip() {
        if (this.toolTip == null) {
            this.setToolTip(this.createDefaultToolTip());
        }
        return this.toolTip;
    }

    public void setToolTip(JComponent jComponent) {
        this.setToolTip(jComponent, PopupManager.ViewPortBounds, PopupManager.AbovePreferred);
    }

    public void setToolTip(JComponent jComponent, PopupManager.HorizontalBounds horizontalBounds, PopupManager.Placement placement) {
        this.setToolTip(jComponent, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0);
    }

    public void setToolTip(JComponent jComponent, PopupManager.HorizontalBounds horizontalBounds, PopupManager.Placement placement, int n, int n2) {
        JComponent jComponent2 = this.toolTip;
        this.toolTip = jComponent;
        this.horizontalBounds = horizontalBounds;
        this.placement = placement;
        this.horizontalAdjustment = n;
        this.verticalAdjustment = n2;
        if (this.status >= 1) {
            this.ensureVisibility();
        }
        this.firePropertyChange(PROP_TOOL_TIP, jComponent2, this.toolTip);
    }

    protected JComponent createDefaultToolTip() {
        return this.createTextToolTip(false);
    }

    private JEditorPane createHtmlTextToolTip() {
        JEditorPane jEditorPane = new JEditorPane(){

            public void setSize(int n, int n2) {
                Dimension dimension = this.getPreferredSize();
                if (n >= dimension.width) {
                    n = dimension.width;
                } else {
                    super.setSize(n, 10000);
                    dimension = this.getPreferredSize();
                }
                if (n2 >= dimension.height) {
                    n2 = dimension.height;
                }
                super.setSize(n, n2);
            }
        };
        Font font = UIManager.getFont("ToolTip.font");
        Color color = UIManager.getColor("ToolTip.background");
        Color color2 = UIManager.getColor("ToolTip.foreground");
        if (font != null) {
            jEditorPane.setFont(font);
        }
        if (color2 != null) {
            jEditorPane.setForeground(color2);
        }
        if (color != null) {
            jEditorPane.setBackground(color);
        }
        jEditorPane.setOpaque(true);
        jEditorPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(jEditorPane.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        jEditorPane.setContentType("text/html");
        jEditorPane.setActionMap(new ActionMap());
        jEditorPane.setInputMap(1, null);
        return jEditorPane;
    }

    private JTextArea createTextToolTip(final boolean bl) {
        JTextArea jTextArea = new JTextArea(){

            public void setSize(int n, int n2) {
                Dimension dimension = this.getPreferredSize();
                if (n >= dimension.width) {
                    n = dimension.width;
                } else {
                    if (bl) {
                        this.setLineWrap(true);
                        this.setWrapStyleWord(true);
                    }
                    super.setSize(n, 10000);
                    dimension = this.getPreferredSize();
                }
                if (n2 >= dimension.height) {
                    n2 = dimension.height;
                } else {
                    Element element;
                    super.setSize(n, 10000);
                    int n3 = this.viewToModel(new Point(0, n2));
                    Document document = this.getDocument();
                    Element element2 = document.getDefaultRootElement();
                    int n4 = element2.getElementIndex(n3);
                    if (--n4 >= 0 && (element = element2.getElement(n4)) != null) {
                        try {
                            n3 = element.getStartOffset();
                            document.remove(n3, document.getLength() - n3);
                            document.insertString(n3, "...", null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        n2 = Math.min(n2, this.getPreferredSize().height);
                    }
                }
                super.setSize(n, n2);
            }
        };
        jTextArea.setActionMap(new ActionMap());
        jTextArea.setInputMap(1, null);
        Font font = UIManager.getFont("ToolTip.font");
        Color color = UIManager.getColor("ToolTip.background");
        Color color2 = UIManager.getColor("ToolTip.foreground");
        if (font != null) {
            jTextArea.setFont(font);
        }
        if (color2 != null) {
            jTextArea.setForeground(color2);
        }
        if (color != null) {
            jTextArea.setBackground(color);
        }
        jTextArea.setOpaque(true);
        jTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(jTextArea.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        return jTextArea;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            jComponent = (JTextComponent)propertyChangeEvent.getNewValue();
            if (jComponent != null) {
                jComponent.addPropertyChangeListener(this);
                this.disableSwingToolTip(jComponent);
                jComponent.addFocusListener(this);
                if (jComponent.hasFocus()) {
                    this.focusGained(new FocusEvent(jComponent, 1004));
                }
                jComponent.addMouseListener(this);
                jComponent.addMouseMotionListener(this);
                GlyphGutter glyphGutter = this.extEditorUI.getGlyphGutter();
                if (glyphGutter != null && !this.glyphListenerAdded) {
                    this.glyphListenerAdded = true;
                    glyphGutter.addMouseListener(this);
                    glyphGutter.addMouseMotionListener(this);
                }
            } else {
                jComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                jComponent.removeFocusListener(this);
                jComponent.removePropertyChangeListener(this);
                jComponent.removeMouseListener(this);
                jComponent.removeMouseMotionListener(this);
                GlyphGutter glyphGutter = this.extEditorUI.getGlyphGutter();
                if (glyphGutter != null) {
                    glyphGutter.removeMouseListener(this);
                    glyphGutter.removeMouseMotionListener(this);
                }
                this.setToolTipVisible(false);
            }
        }
        if ("ToolTipText".equals(string)) {
            jComponent = (JComponent)propertyChangeEvent.getSource();
            this.disableSwingToolTip(jComponent);
            this.componentToolTipTextChanged(propertyChangeEvent);
        }
    }

    private void disableSwingToolTip(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolTipManager.sharedInstance().unregisterComponent(jComponent);
                GlyphGutter glyphGutter = ToolTipSupport.this.extEditorUI.getGlyphGutter();
                if (glyphGutter != null) {
                    ToolTipManager.sharedInstance().unregisterComponent(glyphGutter);
                }
            }
        });
    }

    protected void updateToolTip() {
        EditorUI editorUI = this.extEditorUI;
        if (editorUI == null) {
            return;
        }
        JTextComponent jTextComponent = editorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (this.isGlyphGutterMouseEvent(this.lastMouseEvent)) {
            this.setToolTipText(this.extEditorUI.getGlyphGutter().getToolTipText(this.lastMouseEvent));
        } else {
            Action action;
            BaseKit baseKit = Utilities.getKit(jTextComponent);
            if (baseKit != null && (action = baseKit.getActionByName("build-tool-tip")) != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 0, ""));
            }
        }
    }

    protected void setToolTipVisible(boolean bl) {
        if (!bl) {
            this.enterTimer.stop();
            this.exitTimer.stop();
        }
        if (bl && this.status < 1 || !bl && this.status >= 1) {
            if (bl) {
                if (this.enabled) {
                    this.setStatus(1);
                    this.updateToolTip();
                }
            } else {
                if (this.toolTip != null && this.toolTip.isVisible()) {
                    this.toolTip.setVisible(false);
                    PopupManager popupManager = this.extEditorUI.getPopupManager();
                    if (popupManager != null) {
                        popupManager.uninstall(this.toolTip);
                    }
                }
                this.setStatus(0);
            }
        }
    }

    public boolean isToolTipVisible() {
        return this.status > 1;
    }

    public final int getStatus() {
        return this.status;
    }

    private void setStatus(int n) {
        if (this.status != n) {
            int n2 = this.status;
            this.status = n;
            this.firePropertyChange(PROP_STATUS, new Integer(n2), new Integer(this.status));
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    private static String makeDisplayable(String string, Font font) {
        if (string == null || font == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\t': {
                    stringBuffer.append(c);
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append(c);
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append(c);
                    continue block7;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block7;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block7;
                }
                default: {
                    if (font == null || font.canDisplay(c)) {
                        stringBuffer.append(c);
                        continue block7;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void setToolTipText(String string) {
        final String string2 = ToolTipSupport.makeDisplayable(string, UIManager.getFont("ToolTip.font"));
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                String string = ToolTipSupport.this.toolTipText;
                ToolTipSupport.this.toolTipText = string2;
                ToolTipSupport.this.firePropertyChange(ToolTipSupport.PROP_TOOL_TIP_TEXT, string, ToolTipSupport.this.toolTipText);
                if (ToolTipSupport.this.toolTipText != null) {
                    if (ToolTipSupport.this.toolTipText.startsWith(ToolTipSupport.HTML_PREFIX_LOWERCASE) || ToolTipSupport.this.toolTipText.startsWith(ToolTipSupport.HTML_PREFIX_UPPERCASE)) {
                        JEditorPane jEditorPane = ToolTipSupport.this.createHtmlTextToolTip();
                        jEditorPane.setText(ToolTipSupport.this.toolTipText);
                        ToolTipSupport.this.setToolTip(jEditorPane);
                    } else {
                        boolean bl = ToolTipSupport.this.toolTipText.contains("\n");
                        JTextArea jTextArea = ToolTipSupport.this.createTextToolTip(!bl);
                        jTextArea.setText(ToolTipSupport.this.toolTipText);
                        ToolTipSupport.this.setToolTip(jTextArea);
                    }
                } else if (ToolTipSupport.this.status == 2) {
                    ToolTipSupport.this.setToolTipVisible(false);
                }
            }
        });
    }

    private boolean isGlyphGutterMouseEvent(MouseEvent mouseEvent) {
        return mouseEvent != null && mouseEvent.getSource() == this.extEditorUI.getGlyphGutter();
    }

    private void ensureVisibility() {
        JTextComponent jTextComponent = this.extEditorUI.getComponent();
        if (jTextComponent != null) {
            int n = jTextComponent.viewToModel(this.getLastMouseEventPoint());
            Rectangle rectangle = null;
            if (n >= 0) {
                try {
                    rectangle = jTextComponent.modelToView(n);
                    if (this.horizontalBounds != PopupManager.ScrollBarBounds) {
                        if (this.placement == PopupManager.AbovePreferred || this.placement == PopupManager.Above) {
                            rectangle.y -= 5;
                            rectangle.height += 10;
                        } else if (this.placement == PopupManager.BelowPreferred || this.placement == PopupManager.Below) {
                            rectangle.y = rectangle.y + rectangle.height + 5 + 1;
                            rectangle.height += 5;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (rectangle == null) {
                rectangle = new Rectangle(this.getLastMouseEventPoint(), new Dimension(1, 1));
            }
            PopupManager popupManager = this.extEditorUI.getPopupManager();
            if (this.toolTip != null && this.toolTip.isVisible()) {
                this.toolTip.setVisible(false);
            }
            popupManager.install(this.toolTip, rectangle, this.placement, this.horizontalBounds, this.horizontalAdjustment, this.verticalAdjustment);
            if (this.toolTip != null) {
                this.toolTip.setVisible(true);
            }
        }
        this.exitTimer.restart();
    }

    public String getIdentifierUnderCursor() {
        String string = null;
        if (!this.isGlyphGutterMouseEvent(this.lastMouseEvent)) {
            try {
                JTextComponent jTextComponent = this.extEditorUI.getComponent();
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                Point point = this.getLastMouseEventPoint();
                int n = baseTextUI.viewToModel(jTextComponent, point);
                if (n >= 0) {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n2 = Utilities.getRowEnd(baseDocument, n);
                    Rectangle rectangle = baseTextUI.modelToView(jTextComponent, n2);
                    int n3 = this.extEditorUI.getLineHeight();
                    if (point.x <= rectangle.x && point.y <= rectangle.y + n3) {
                        string = Utilities.getIdentifier(baseDocument, n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.firePropertyChange(PROP_ENABLED, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
            if (!bl) {
                this.setToolTipVisible(false);
            }
        }
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int n) {
        if (this.enterTimer.getDelay() != n) {
            int n2 = this.enterTimer.getDelay();
            this.enterTimer.setDelay(n);
            this.firePropertyChange(PROP_INITIAL_DELAY, new Integer(n2), new Integer(this.enterTimer.getDelay()));
        }
    }

    public int getDismissDelay() {
        return this.exitTimer.getDelay();
    }

    public void setDismissDelay(int n) {
        if (this.exitTimer.getDelay() != n) {
            int n2 = this.exitTimer.getDelay();
            this.exitTimer.setDelay(n);
            this.firePropertyChange(PROP_DISMISS_DELAY, new Integer(n2), new Integer(this.exitTimer.getDelay()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.enterTimer) {
            this.setToolTipVisible(true);
        } else if (actionEvent.getSource() == this.exitTimer) {
            this.setToolTipVisible(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
        EditorUI editorUI = this.extEditorUI;
        if (editorUI != null) {
            JTextComponent jTextComponent = editorUI.getComponent();
            if (this.enabled && jTextComponent != null && Utilities.isSelectionShowing(jTextComponent)) {
                this.enterTimer.restart();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.lastMouseEvent = mouseEvent;
        this.setToolTipVisible(false);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.setToolTipVisible(false);
        if (this.enabled) {
            this.enterTimer.restart();
        }
        this.lastMouseEvent = mouseEvent;
    }

    public final MouseEvent getLastMouseEvent() {
        return this.lastMouseEvent;
    }

    private Point getLastMouseEventPoint() {
        Point point = null;
        MouseEvent mouseEvent = this.lastMouseEvent;
        if (mouseEvent != null) {
            JTextComponent jTextComponent;
            point = mouseEvent.getPoint();
            if (mouseEvent.getSource() == this.extEditorUI.getGlyphGutter() && (jTextComponent = this.extEditorUI.getComponent()) != null && jTextComponent.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)jTextComponent.getParent();
                point = new Point(jViewport.getViewPosition().x, point.y);
            }
        }
        return point;
    }

    protected void componentToolTipTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        this.setToolTipText(jComponent.getToolTipText());
    }

    private synchronized PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPCS().removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPCS().firePropertyChange(string, object, object2);
    }

    public void focusGained(FocusEvent focusEvent) {
        GlyphGutter glyphGutter = this.extEditorUI.getGlyphGutter();
        if (glyphGutter != null && !this.glyphListenerAdded) {
            this.glyphListenerAdded = true;
            glyphGutter.addMouseListener(this);
            glyphGutter.addMouseMotionListener(this);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

