/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata.resultelements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.metadata.QueryElement;
import rex.metadata.UniqueNameElement;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;

public class Member
implements QueryElement,
UniqueNameElement {
    private String hierarchy;
    private String uName;
    private String caption;
    private String lName;
    private int lNum;
    private String displayInfo;
    private int span;
    private boolean lastMemberInTuple;
    private static int INDENT_SPACE_PER_LEVEL = 2;
    static ImageIcon icon = S.getAppIcon("measure.gif");

    public Member(String _hierarchy, String _uName, String _caption, boolean _lastMemberInTuple) {
        this.hierarchy = _hierarchy;
        this.uName = _uName;
        this.caption = _caption;
        this.lastMemberInTuple = _lastMemberInTuple;
        this.span = 1;
    }

    public Member(Node memberNode, Member prevMember, boolean _lastMemberInTuple) {
        this.hierarchy = memberNode.getAttributes().getNamedItem("Hierarchy").getNodeValue();
        NodeList nl = memberNode.getChildNodes();
        this.lastMemberInTuple = _lastMemberInTuple;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("UName")) {
                this.uName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("Caption")) {
                this.caption = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LName")) {
                this.lName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LNum")) {
                this.lNum = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("DisplayInfo")) continue;
            this.displayInfo = DOM.getTextFromDOMElement(nl.item(i));
        }
        this.span = prevMember != null && this.uName.equals(prevMember.getUniqueName()) ? 1 + prevMember.getMemberSpan() : 1;
    }

    public Member(Node memberNode, boolean _lastMemberInTuple) {
        this(memberNode, null, _lastMemberInTuple);
    }

    public String getCaption() {
        return this.caption;
    }

    public String toString() {
        if (this.caption == null) {
            return I18n.getString("toolTip.notInitiliazed");
        }
        String retVal = "";
        for (int i = 0; i < INDENT_SPACE_PER_LEVEL * this.lNum; ++i) {
            retVal = retVal + " ";
        }
        return retVal + this.caption;
    }

    public String getUniqueName() {
        return this.uName;
    }

    public int getMemberSpan() {
        if (this.lastMemberInTuple) {
            return 1;
        }
        return this.span;
    }

    public String getHierarchy() {
        return this.hierarchy;
    }

    public boolean equals(Member otherMember) {
        return this.uName.equals(otherMember.getUniqueName());
    }

    public String getQueryMembersExpression() {
        return this.getUniqueName();
    }

    public String getHierarchyUniqueName() {
        return this.uName.substring(0, this.uName.lastIndexOf("."));
    }

    private String getDimensionNameForSorting() {
        return this.getDimensionUniqueName();
    }

    public String getDimensionUniqueName() {
        return this.lName.substring(0, this.lName.lastIndexOf("."));
    }

    public String getLname() {
        return this.lName;
    }

    public String getSortingExpression() {
        if (this.isMeasure()) {
            return "(" + this.uName + ")";
        }
        return this.getDimensionNameForSorting() + ".CurrentMember.Name";
    }

    public boolean isMeasure() {
        return this.uName.indexOf("Measures") != -1;
    }

    public ImageIcon getIcon() {
        if (this.isMeasure()) {
            return icon;
        }
        return null;
    }

    public String getToolTip() {
        return "<html><b>" + I18n.getString("toolTip.caption") + "</b>" + this.caption + "<br><b>Unique " + I18n.getString("toolTip.name") + "</b>" + this.uName + "<br><b>Level " + I18n.getString("toolTip.name") + "</b>" + this.lName + "</html>";
    }
}

