/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import javax.swing.JLabel;
import javax.swing.JPanel;
import rex.graphics.TupleMemberLabel;
import rex.graphics.TupleMemberLabelPopUpActions;
import rex.metadata.Query;
import rex.metadata.resultelements.Member;
import rex.metadata.resultelements.Tuple;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;

public class RowTupleMemberLabel
extends TupleMemberLabel
implements LanguageChangedListener {
    Query query;
    Tuple tuple;
    int memberOrdinal;
    int rowNumber;
    Member thisMember;

    public RowTupleMemberLabel(String caption, Query _query, Tuple _tuple, int _memberOrdinal, int _rowNumber) {
        super(caption);
        I18n.addOnLanguageChangedListener(this);
        this.query = _query;
        this.tuple = _tuple;
        this.memberOrdinal = _memberOrdinal;
        this.thisMember = this.tuple.getMemberAt(this.memberOrdinal);
        this.rowNumber = _rowNumber;
        this.setBorder(AppColors.HIERARCHY_LABEL_BORDER);
        this.setForeground(AppColors.HIERARCHY_LABEL_FORECOLOR);
    }

    public int setHighlight(Tuple t, int mOrdinal) {
        for (int i = 0; i <= this.memberOrdinal && i <= mOrdinal; ++i) {
            if (t.getMemberAt(i).getUniqueName().equals(this.tuple.getMemberAt(i).getUniqueName())) continue;
            this.setOpaque(false);
            return 0;
        }
        this.setBackground(AppColors.HIERARCHY_LABEL_SELECTED_BACKGROUND);
        this.setOpaque(true);
        return 1;
    }

    void highlightHierarchy() {
        int i;
        JPanel parent = (JPanel)this.getParent();
        int levelsHighlighted = 0;
        for (i = 0; i < parent.getComponentCount() && levelsHighlighted <= this.memberOrdinal; ++i) {
            if (!(parent.getComponent(i) instanceof RowTupleMemberLabel)) continue;
            levelsHighlighted += ((RowTupleMemberLabel)parent.getComponent(i)).setHighlight(this.tuple, this.memberOrdinal);
        }
        if (i < parent.getComponentCount()) {
            while (i < parent.getComponentCount()) {
                ((JLabel)parent.getComponent(i)).setOpaque(false);
                ++i;
            }
        }
        parent.revalidate();
        parent.repaint();
    }

    void toggleHierarchy() {
        this.query.toggleRowsDrillState(this.thisMember);
    }

    void moveDimensionUp() {
        this.query.moveRowDimensionUp(this.thisMember);
    }

    void moveDimensionFirst() {
        this.query.moveRowDimensionFirst(this.thisMember);
    }

    void moveDimensionLast() {
        this.query.moveRowDimensionLast(this.thisMember);
    }

    void removeDimensionFromQuery() {
        this.query.removeRowDimensionFromQuery(this.thisMember);
    }

    void removeMemberFromQuery() {
        if (this.thisMember.isMeasure()) {
            this.query.removeMeasureMemberFromQuery(this.thisMember);
        } else {
            this.query.removeRowMemberFromQuery(this.thisMember);
        }
    }

    void sortByMeasureAscending() {
        this.query.sortByThisMember(this.thisMember, "ASC");
    }

    void sortByMeasureDescending() {
        this.query.sortByThisMember(this.thisMember, "DESC");
    }

    void sortByMeasureBAscending() {
        this.query.sortByThisMember(this.thisMember, "BASC");
    }

    void sortByMeasureBDescending() {
        this.query.sortByThisMember(this.thisMember, "BDESC");
    }

    void keepThisMemberOnly() {
        if (this.thisMember.isMeasure()) {
            this.query.keepThisMemberOnlyOnMeasures(this.thisMember);
        } else {
            this.query.keepThisMemberOnlyOnRows(this.thisMember);
        }
    }

    void sendMemberToFilter() {
        this.query.addRowMemberToFilter(this.thisMember);
    }

    public String[] getPopUpActionList() {
        return new String[]{TupleMemberLabelPopUpActions.MOVE_DIMENSION_UP, TupleMemberLabelPopUpActions.MOVE_DIMENSION_FIRST, TupleMemberLabelPopUpActions.MOVE_DIMENSION_LAST, TupleMemberLabelPopUpActions.REMOVE_DIMENSION_FROM_QUERY, TupleMemberLabelPopUpActions.REMOVE_MEMBER_FROM_QUERY, TupleMemberLabelPopUpActions.KEEP_THIS_MEMBER_ONLY, TupleMemberLabelPopUpActions.SEND_MEMBER_TO_FILTER, TupleMemberLabelPopUpActions.SORT_BY_THIS_BASCENDING, TupleMemberLabelPopUpActions.SORT_BY_THIS_BDESCENDING, TupleMemberLabelPopUpActions.SORT_BY_THIS_ASCENDING, TupleMemberLabelPopUpActions.SORT_BY_THIS_DESCENDING};
    }

    public void languageChanged(LanguageChangedEvent evt) {
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.MOVE_DIMENSION_UP, I18n.getString("menu.moveDimUp"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.MOVE_DIMENSION_FIRST, I18n.getString("menu.moveDimFirst"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.MOVE_DIMENSION_LAST, I18n.getString("menu.moveDimLast"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.REMOVE_DIMENSION_FROM_QUERY, I18n.getString("menu.removeDim"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.REMOVE_MEMBER_FROM_QUERY, I18n.getString("menu.removeMem"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.KEEP_THIS_MEMBER_ONLY, I18n.getString("menu.keepMem"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.SEND_MEMBER_TO_FILTER, I18n.getString("menu.sendMem"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.SORT_BY_THIS_ASCENDING, I18n.getString("menu.sortAsc"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.SORT_BY_THIS_DESCENDING, I18n.getString("menu.sortDsc"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.SORT_BY_THIS_BASCENDING, I18n.getString("menu.sortBAsc"));
        TupleMemberLabelPopUpActions.popUpCaptions.put(TupleMemberLabelPopUpActions.SORT_BY_THIS_BDESCENDING, I18n.getString("menu.sortBDsc"));
    }
}

